/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.granite.ui.components.impl.include;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(service={Filter.class}, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"sling.filter.scope=INCLUDE", "sling.filter.resourceTypes=acs-commons/granite/ui/components/include"})
public class IncludeDecoratorFilterImpl
implements Filter {
    static final String RESOURCE_TYPE = "acs-commons/granite/ui/components/include";
    static final String REQ_ATTR_NAMESPACE = "ACS_AEM_COMMONS_INCLUDE_NAMESPACE";
    static final String NN_PARAMETERS = "parameters";
    static final String PN_NAMESPACE = "namespace";
    static final String PREFIX = "ACS_AEM_COMMONS_INCLUDE_PREFIX_";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        ValueMap parameters = ValueMap.EMPTY;
        if (servletRequest instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest request = (SlingHttpServletRequest)servletRequest;
            Resource parameterResource = request.getResource().getChild(NN_PARAMETERS);
            if (parameterResource != null) {
                parameters = parameterResource.getValueMap();
            }
            ValueMap includeProperties = request.getResource().getValueMap();
            Object existingNamespace = request.getAttribute(REQ_ATTR_NAMESPACE);
            boolean hasExistingNamespace = existingNamespace != null;
            boolean hasNamespaceInInclude = includeProperties.containsKey((Object)PN_NAMESPACE);
            if (MapUtils.isNotEmpty((Map)parameters)) {
                parameters.forEach((key, object) -> request.setAttribute(PREFIX + key, object));
            }
            if (hasNamespaceInInclude && hasExistingNamespace) {
                request.setAttribute(REQ_ATTR_NAMESPACE, (Object)(existingNamespace + "/" + (String)includeProperties.get(PN_NAMESPACE, String.class)));
            } else if (hasNamespaceInInclude) {
                request.setAttribute(REQ_ATTR_NAMESPACE, includeProperties.get(PN_NAMESPACE, String.class));
            }
            chain.doFilter((ServletRequest)request, servletResponse);
            if (MapUtils.isNotEmpty((Map)parameters)) {
                parameters.forEach((key, object) -> request.removeAttribute(PREFIX + key));
            }
            if (existingNamespace != null) {
                servletRequest.setAttribute(REQ_ATTR_NAMESPACE, existingNamespace);
            } else {
                servletRequest.removeAttribute(REQ_ATTR_NAMESPACE);
            }
            return;
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

