/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentfinder.querybuilder.impl.viewhandler;

import com.adobe.acs.commons.contentfinder.querybuilder.impl.viewhandler.ContentFinderConstants;
import com.adobe.acs.commons.contentfinder.querybuilder.impl.viewhandler.GQLToQueryBuilderConverter;
import com.adobe.acs.commons.contentfinder.querybuilder.impl.viewhandler.QueryBuilderViewQuery;
import com.adobe.acs.commons.search.CloseableQuery;
import com.adobe.acs.commons.search.CloseableQueryBuilder;
import com.day.cq.search.PredicateGroup;
import com.day.cq.wcm.core.contentfinder.ViewHandler;
import com.day.cq.wcm.core.contentfinder.ViewQuery;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Session;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Properties(value={@Property(label="Servlet Paths", name="sling.servlet.paths", value={"/bin/wcm/contentfinder/qb/view"})})
@Service
public final class QueryBuilderViewHandler
extends ViewHandler {
    private static final Logger log = LoggerFactory.getLogger(QueryBuilderViewHandler.class);
    @Reference
    private transient CloseableQueryBuilder queryBuilder;

    protected ViewQuery createQuery(SlingHttpServletRequest slingRequest, Session session, String queryString) throws Exception {
        Map<String, String> map;
        if (GQLToQueryBuilderConverter.convertToQueryBuilder(slingRequest)) {
            map = this.convertToQueryBuilderParams(slingRequest, queryString);
            log.debug("Forced QueryBuilder Parameter Map: {}", map);
        } else {
            map = this.getQueryBuilderParams(slingRequest, queryString);
            log.debug("Converted QueryBuilder Parameter Map: {}", map);
        }
        CloseableQuery query = this.queryBuilder.createQuery(PredicateGroup.create(map), session);
        return new QueryBuilderViewQuery(query);
    }

    private Map<String, String> getQueryBuilderParams(SlingHttpServletRequest request, String queryString) {
        Map<String, String> map = new LinkedHashMap<String, String>();
        for (String key : request.getParameterMap().keySet()) {
            if (!ArrayUtils.contains((Object[])ContentFinderConstants.QUERYBUILDER_BLACKLIST, (Object)key)) {
                String val = request.getParameter(key);
                if (!StringUtils.isNotBlank((String)val)) continue;
                map.put(key, val);
                continue;
            }
            log.debug("Rejecting property [ {} ] due to blacklist match", (Object)key);
        }
        map = GQLToQueryBuilderConverter.addFulltext(request, map, queryString);
        map = GQLToQueryBuilderConverter.addLimitAndOffset(request, map);
        return map;
    }

    private Map<String, String> convertToQueryBuilderParams(SlingHttpServletRequest request, String queryString) {
        Map<String, String> map = new LinkedHashMap<String, String>();
        int userDefinedPropertyCount = 0;
        for (String key : request.getRequestParameterMap().keySet()) {
            if (StringUtils.equals((String)key, (String)"path")) {
                log.debug("Converting path...");
                map = GQLToQueryBuilderConverter.addPath(request, map);
                continue;
            }
            if (StringUtils.equals((String)key, (String)"type")) {
                log.debug("Converting type...");
                map = GQLToQueryBuilderConverter.addType(request, map);
                continue;
            }
            if (StringUtils.equals((String)key, (String)"name")) {
                log.debug("Converting name...");
                map = GQLToQueryBuilderConverter.addName(request, map);
                continue;
            }
            if (StringUtils.equals((String)key, (String)"tags")) {
                log.debug("Converting tags...");
                map = GQLToQueryBuilderConverter.addTags(request, map);
                continue;
            }
            if (StringUtils.equals((String)key, (String)"mimeType")) {
                log.debug("Converting mimeType...");
                map = GQLToQueryBuilderConverter.addMimeType(request, map);
                continue;
            }
            if (StringUtils.equals((String)key, (String)"query")) {
                log.debug("Converting fulltext...");
                map = GQLToQueryBuilderConverter.addFulltext(request, map, queryString);
                continue;
            }
            if (StringUtils.equals((String)key, (String)"order")) {
                log.debug("Converting order...");
                map = GQLToQueryBuilderConverter.addOrder(request, map, queryString);
                continue;
            }
            if (StringUtils.equals((String)key, (String)"limit")) {
                log.debug("Converting limit...");
                map = GQLToQueryBuilderConverter.addLimitAndOffset(request, map);
                continue;
            }
            log.debug("Converting property [ {} ]...", (Object)key);
            map = GQLToQueryBuilderConverter.addProperty(request, map, key, userDefinedPropertyCount);
            ++userDefinedPropertyCount;
        }
        map.put("p.or", "false");
        return map;
    }

    protected void bindQueryBuilder(CloseableQueryBuilder closeableQueryBuilder) {
        this.queryBuilder = closeableQueryBuilder;
    }

    protected void unbindQueryBuilder(CloseableQueryBuilder closeableQueryBuilder) {
        if (this.queryBuilder == closeableQueryBuilder) {
            this.queryBuilder = null;
        }
    }
}

