/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.functions.CheckedFunction;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.CheckboxComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.PathfieldComponent;
import com.adobe.acs.commons.mcp.form.SelectComponent;
import com.adobe.acs.commons.mcp.form.TextfieldComponent;
import com.adobe.acs.commons.mcp.model.GenericReport;
import com.adobe.acs.commons.util.visitors.TreeFilteringResourceVisitor;
import com.day.cq.replication.AgentFilter;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class TreeReplication
extends ProcessDefinition {
    public static int ASYNC_LIMIT = 10000;
    Replicator replicatorService;
    @FormField(name="Starting Path", component=PathfieldComponent.FolderSelectComponent.class, description="This item and its descendants will be published/unpublished")
    private String startingPath = null;
    @FormField(name="What to Publish", component=SelectComponent.EnumerationSelector.class, description="Publish only folders/pages or all content inside of folders (assets, etc) -- Unpublish will unpublish everything", options={"default=FOLDERS_AND_PAGES_ONLY"})
    private ReplicationFilter publishFilter = ReplicationFilter.FOLDERS_AND_PAGES_ONLY;
    @FormField(name="Queueing Method", component=SelectComponent.EnumerationSelector.class, description="For small publishing tasks, standard is sufficient.  For large folder trees, MCP is recommended.", options={"default=USE_MCP_QUEUE"})
    QueueMethod queueMethod = QueueMethod.USE_MCP_QUEUE;
    @FormField(name="Agents", component=TextfieldComponent.class, hint="(leave blank for default agents)", description="Publish agents to use, if blank then all default agents will be used. Multiple agents can be listed using commas or regex.")
    private String agents = null;
    List<String> agentList = new ArrayList<String>();
    AgentFilter replicationAgentFilter;
    @FormField(name="Action", component=SelectComponent.EnumerationSelector.class, description="Publish or Unpublish?", options={"default=PUBLISH"})
    ReplicationAction action = ReplicationAction.PUBLISH;
    @FormField(name="Dry Run", component=CheckboxComponent.class, options={"checked"}, description="If checked, only generate a report but don't perform the work")
    private boolean dryRun = true;
    List<EnumMap<ReportColumns, String>> reportData = Collections.synchronizedList(new ArrayList());
    public AtomicInteger replicationCount = new AtomicInteger();
    static final String[] FOLDERS_AND_PAGES = new String[]{"nt:folder", "sling:Folder", "sling:OrderedFolder", "cq:Page"};

    public TreeReplication(Replicator replicator) {
        this.replicatorService = replicator;
    }

    @Override
    public void init() {
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        instance.getInfo().setDescription(this.startingPath + "; " + this.action.name() + " " + this.publishFilter.name() + "; " + this.queueMethod.name() + (this.dryRun ? " (dry run)" : ""));
        if (this.action == ReplicationAction.PUBLISH) {
            instance.defineCriticalAction("Activate tree structure", rr, this::activateTreeStructure);
            if (this.publishFilter != ReplicationFilter.FOLDERS_AND_PAGES_ONLY) {
                instance.defineAction("Activiate content", rr, this::activateContent);
            }
            if (this.agents == null || this.agents.isEmpty()) {
                this.replicationAgentFilter = AgentFilter.DEFAULT;
            } else {
                this.agentList = Arrays.asList(this.agents.toLowerCase().split(","));
                this.replicationAgentFilter = agent -> this.agentList.stream().anyMatch(p -> p.matches(agent.getId().toLowerCase()));
            }
        } else {
            instance.defineCriticalAction("Deactivate tree structure", rr, this::deactivateTreeStructure);
        }
    }

    private void record(String path, String action, String description) {
        EnumMap<ReportColumns, String> row = new EnumMap<ReportColumns, String>(ReportColumns.class);
        row.put(ReportColumns.PATH, path);
        row.put(ReportColumns.ACTION, action);
        row.put(ReportColumns.DESCRIPTION, description);
        this.reportData.add(row);
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        GenericReport report = new GenericReport();
        report.setName("Tree Replication " + this.startingPath);
        report.setRows(this.reportData, ReportColumns.class);
        report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    public static Boolean isFolderOrPage(Resource res) {
        String primaryType = String.valueOf(res.getResourceType()).toLowerCase();
        return primaryType.contains("folder") || primaryType.equalsIgnoreCase("cq:Page");
    }

    private void activateTreeStructure(ActionManager t) {
        TreeFilteringResourceVisitor visitor = TreeReplication.createFolderPageVisitor();
        visitor.setResourceVisitorChecked((resource, u) -> {
            String path = resource.getPath();
            if (this.publishFilter.shouldReplicate((Resource)resource)) {
                t.withResolver(rr -> this.performReplication(t, path));
            } else {
                this.record(path, "Skip", "Skipping folder");
            }
        });
        t.deferredWithResolver(rr -> visitor.accept(rr.getResource(this.startingPath)));
    }

    private void deactivateTreeStructure(ActionManager t) {
        t.deferredWithResolver(rr -> this.performAsynchronousReplication(t, this.startingPath));
    }

    private void activateContent(ActionManager t) {
        TreeFilteringResourceVisitor visitor = TreeReplication.createFolderPageVisitor();
        visitor.setLeafVisitorChecked((resource, u) -> {
            String path = resource.getPath();
            if (this.publishFilter.shouldReplicate((Resource)resource)) {
                t.deferredWithResolver(rr -> this.performReplication(t, path));
            } else {
                this.record(path, "Skip", "Skipping content");
            }
        });
        t.deferredWithResolver(rr -> visitor.accept(rr.getResource(this.startingPath)));
    }

    private void performReplication(ActionManager t, String path) {
        int counter = this.replicationCount.incrementAndGet();
        if (this.queueMethod == QueueMethod.USE_MCP_QUEUE || this.queueMethod == QueueMethod.MCP_AFTER_10K && counter >= ASYNC_LIMIT) {
            this.performSynchronousReplication(t, path);
        } else {
            this.performAsynchronousReplication(t, path);
        }
    }

    private void performSynchronousReplication(ActionManager t, String path) {
        ReplicationOptions options = this.buildOptions();
        options.setSynchronous(true);
        this.scheduleReplication(t, options, path);
        this.record(path, this.action == ReplicationAction.PUBLISH ? "Publish" : "Unpublish", "Synchronous replication");
    }

    private void performAsynchronousReplication(ActionManager t, String path) {
        ReplicationOptions options = this.buildOptions();
        options.setSynchronous(false);
        this.scheduleReplication(t, options, path);
        this.record(path, this.action == ReplicationAction.PUBLISH ? "Publish" : "Unpublish", "Asynchronous replication");
    }

    private ReplicationOptions buildOptions() {
        ReplicationOptions options = new ReplicationOptions();
        options.setFilter(this.replicationAgentFilter);
        return options;
    }

    private void scheduleReplication(ActionManager t, ReplicationOptions options, String path) {
        if (!this.dryRun) {
            t.deferredWithResolver(rr -> {
                Session session = (Session)rr.adaptTo(Session.class);
                this.replicatorService.replicate(session, this.action == ReplicationAction.PUBLISH ? ReplicationActionType.ACTIVATE : ReplicationActionType.DEACTIVATE, path, options);
            });
        }
    }

    static TreeFilteringResourceVisitor createFolderPageVisitor() {
        return new TreeFilteringResourceVisitor(FOLDERS_AND_PAGES);
    }

    public static enum ReportColumns {
        PATH,
        ACTION,
        DESCRIPTION;

    }

    protected static enum ReplicationAction {
        PUBLISH,
        UNPUBLISH;

    }

    protected static enum QueueMethod {
        USE_PUBLISH_QUEUE,
        USE_MCP_QUEUE,
        MCP_AFTER_10K;

    }

    protected static enum ReplicationFilter {
        ALL(r -> true),
        FOLDERS_AND_PAGES_ONLY(TreeReplication::isFolderOrPage);

        CheckedFunction<Resource, Boolean> test;

        private ReplicationFilter(CheckedFunction<Resource, Boolean> ... tests) {
            this.test = CheckedFunction.or(tests);
        }

        public boolean shouldReplicate(Resource r) throws Exception {
            return this.test.apply(r);
        }
    }
}

