/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.form;

import com.adobe.acs.commons.mcp.form.FieldComponent;
import com.adobe.acs.commons.mcp.util.SyntheticResourceBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;

public class AutocompleteComponent
extends FieldComponent {
    private boolean disabled = false;
    private boolean multiple = false;
    private boolean forceSelection = false;
    private String icon;
    private String datasource = "cq/gui/components/common/datasources/tags";
    private String displayProperty = null;
    private String values = "granite/ui/components/coral/foundation/form/autocomplete/tags";
    private String options = "granite/ui/components/coral/foundation/form/autocomplete/list";
    private String optionsQuery = null;
    private String[] predicates = null;

    @Override
    public void init() {
        this.setResourceType("granite/ui/components/coral/foundation/form/autocomplete");
        this.setMultiple(this.hasOption("multiple"));
        this.setDisabled(this.hasOption("disabled"));
        this.setForceSelection(this.hasOption("forceSelection"));
        this.getOption("icon").ifPresent(this::setIcon);
        this.getOption("datasource").ifPresent(this::setDatasource);
        this.getOption("values").ifPresent(this::setValues);
        this.getOption("options").ifPresent(this::setOptions);
        this.getOption("query").ifPresent(this::setOptionsQuery);
        this.getOption("displayProperty").ifPresent(this::setDisplayProperty);
        this.setPredicatesFromOptions();
        if (this.displayProperty != null && this.predicates != null) {
            this.addClientLibrary("acs-commons.widgets.search-based-path-browser");
            this.datasource = "acs-commons/granite/ui/components/form/queryautocomplete/datasource";
        }
    }

    @Override
    public Resource buildComponentResource() {
        SyntheticResourceBuilder builder = new SyntheticResourceBuilder(this.getName(), this.getResourceType());
        builder.withAttributes((Map<String, Object>)this.getComponentMetadata()).withAttributes("multiple", this.isMultiple(), "disabled", this.isDisabled(), "forceSelection", this.isForceSelection(), "icon", this.getIcon());
        if (StringUtils.isNotBlank((String)this.displayProperty) && this.getPredicates() != null) {
            builder.withAttributes("displayProperty", this.getDisplayProperty(), "predicates", this.getPredicates());
        }
        if (StringUtils.isNotBlank((String)this.datasource)) {
            builder.createChild("datasource", this.datasource).up();
        }
        if (StringUtils.isNotBlank((String)this.values)) {
            builder.createChild("values", this.values).up();
        }
        if (StringUtils.isNotBlank((String)this.options)) {
            builder.createChild("options", this.options);
            if (this.optionsQuery != null) {
                builder.withAttributes("src", this.optionsQuery);
            }
        }
        return builder.build();
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public boolean isForceSelection() {
        return this.forceSelection;
    }

    public void setForceSelection(boolean forceSelection) {
        this.forceSelection = forceSelection;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public String getValues() {
        return this.values;
    }

    public void setValues(String values) {
        this.values = values;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public String getOptionsQuery() {
        return this.optionsQuery;
    }

    public void setOptionsQuery(String optionsQuery) {
        this.optionsQuery = optionsQuery;
    }

    public String getDisplayProperty() {
        return this.displayProperty;
    }

    public void setDisplayProperty(String displayProperty) {
        this.displayProperty = displayProperty;
    }

    public String[] getPredicates() {
        return this.predicates == null ? null : Arrays.copyOf(this.predicates, this.predicates.length);
    }

    public void setPredicates(String[] predicates) {
        this.predicates = predicates == null ? null : Arrays.copyOf(predicates, predicates.length);
    }

    private void setPredicatesFromOptions() {
        String[] optionPredicates = this.getOptionNames().stream().filter(s -> s.startsWith("predicate_")).map(s -> s.substring("predicate_".length()) + "=" + this.getOption((String)s).get()).collect(Collectors.toList()).toArray(new String[0]);
        this.setPredicates(optionPredicates);
    }
}

