/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.indesign.dynamicdeckdynamo.workflow.processes.impl;

import com.adobe.acs.commons.indesign.dynamicdeckdynamo.exception.DynamicDeckDynamoException;
import com.adobe.acs.commons.indesign.dynamicdeckdynamo.utils.DynamicDeckUtils;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.dam.commons.util.DamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component(service={WorkflowProcess.class}, property={"process.label=Dynamic Deck Dynamo Write Back Process"})
public class DynamicDeckBackTrackProcess
implements WorkflowProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicDeckBackTrackProcess.class);

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        try {
            ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
            Session jcrSession = (Session)workflowSession.adaptTo(Session.class);
            if (null == jcrSession) {
                LOGGER.error("JCR Session is null");
                return;
            }
            DynamicDeckUtils.updateUserData(jcrSession);
            DynamicDeckUtils.updateUserData((Session)resourceResolver.adaptTo(Session.class));
            Resource assetResource = DynamicDeckUtils.getAssetResourceFromPayload(workItem, resourceResolver);
            if (null == assetResource) {
                LOGGER.error("Asset resource from payload is null");
                return;
            }
            if (this.isFileEligibleToProcess(assetResource)) {
                InputStream xmlInputStream = DynamicDeckUtils.getInddXmlRenditionInputStream(assetResource);
                if (null == xmlInputStream) {
                    LOGGER.debug("File xml input stream is null, hence skipping the parsing process.");
                    return;
                }
                this.parseXML(xmlInputStream, resourceResolver);
            } else {
                LOGGER.info("File is not eligible to be parsed, hence skipping the parsing process.");
            }
        }
        catch (DynamicDeckDynamoException e) {
            LOGGER.error("Back track: Error while parsing asset xml", (Throwable)e);
            throw new WorkflowException("Error while performing back track operation", (Throwable)e);
        }
    }

    private void parseXML(InputStream xmlInputStream, ResourceResolver resourceResolver) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder dBuilder = dbf.newDocumentBuilder();
            Document doc = dBuilder.parse(xmlInputStream);
            if (doc.hasChildNodes()) {
                String assetPath = "";
                this.readNode(doc.getChildNodes(), "", resourceResolver);
            }
        }
        catch (DynamicDeckDynamoException | IOException | ParserConfigurationException | TransformerFactoryConfigurationError | DOMException | SAXException e) {
            LOGGER.error("Error while processing the xml template ", e);
        }
    }

    private void readNode(NodeList nodeList, String assetPath, ResourceResolver resourceResolver) throws DOMException, DynamicDeckDynamoException {
        for (int count = 0; count < nodeList.getLength(); ++count) {
            Node tempNode = nodeList.item(count);
            if (tempNode.getNodeType() != 1) continue;
            if (tempNode.hasAttributes()) {
                Node sectionType;
                NamedNodeMap nodeMap = tempNode.getAttributes();
                Node node = sectionType = nodeMap != null ? nodeMap.getNamedItem("section-type") : null;
                if (sectionType != null && StringUtils.isNotBlank((CharSequence)(assetPath = this.getAssetPath(nodeMap, assetPath)))) {
                    this.retrieveFieldValues(assetPath, tempNode, resourceResolver);
                }
            }
            if (!tempNode.hasChildNodes()) continue;
            this.readNode(tempNode.getChildNodes(), assetPath, resourceResolver);
        }
        DynamicDeckUtils.commit(resourceResolver);
    }

    private void retrieveFieldValues(String assetPath, Node sectionNode, ResourceResolver resourceResolver) throws DynamicDeckDynamoException {
        NodeList childNodes = sectionNode.getChildNodes();
        block8: for (int i = 0; i < childNodes.getLength(); ++i) {
            String fieldType;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !childNode.hasAttributes()) continue;
            NamedNodeMap nodeMap = childNode.getAttributes();
            Node fieldTypeAttr = nodeMap != null ? nodeMap.getNamedItem("field-type") : null;
            Node dataSyncAttr = nodeMap != null ? nodeMap.getNamedItem("is-data-sync") : null;
            Node isArrayAttr = nodeMap != null ? nodeMap.getNamedItem("is-array") : null;
            Boolean isArray = isArrayAttr != null && "true".equals(isArrayAttr.getNodeValue());
            if (fieldTypeAttr == null || dataSyncAttr == null || !"true".equals(dataSyncAttr.getNodeValue())) continue;
            Resource assetResource = resourceResolver.getResource(assetPath);
            ModifiableValueMap mValueMap = null;
            if (assetResource != null) {
                mValueMap = (ModifiableValueMap)assetResource.adaptTo(ModifiableValueMap.class);
            }
            if (mValueMap == null) continue;
            switch (fieldType = fieldTypeAttr.getNodeValue()) {
                case "image": {
                    this.handleImageType(assetResource, childNode, resourceResolver, isArray);
                    continue block8;
                }
                case "text": {
                    this.handleTextType(assetResource, childNode, isArray);
                    continue block8;
                }
            }
        }
    }

    private void handleTextType(Resource assetResource, Node childNode, Boolean isArray) {
        Node propertyPathNode = childNode.getAttributes().getNamedItem("property-path");
        if (propertyPathNode != null) {
            String propertyPath = this.getAssetPropertyPath(propertyPathNode.getNodeValue(), assetResource.getValueMap());
            String textValue = childNode.getTextContent();
            this.setNewPropertyValue(isArray, propertyPath, assetResource, textValue);
        }
    }

    private void setNewPropertyValue(Boolean isArray, String propertyPath, Resource assetResource, String nodeContentValue) {
        ModifiableValueMap properties;
        String nodePath = StringUtils.substringBeforeLast((String)propertyPath, (String)"/");
        if (StringUtils.isNotBlank((CharSequence)nodePath)) {
            Resource childResource = assetResource.getChild(nodePath);
            properties = (ModifiableValueMap)childResource.adaptTo(ModifiableValueMap.class);
            propertyPath = StringUtils.substringAfterLast((String)propertyPath, (String)"/");
        } else {
            properties = (ModifiableValueMap)assetResource.adaptTo(ModifiableValueMap.class);
        }
        if (isArray.booleanValue()) {
            String[] values;
            String index = StringUtils.substringBetween((String)propertyPath, (String)"[", (String)"]");
            propertyPath = StringUtils.substringBeforeLast((String)propertyPath, (String)"[");
            int indexVal = Integer.parseInt(index);
            if (indexVal >= (values = (String[])properties.get(propertyPath, String[].class)).length) {
                values = Arrays.copyOf(values, indexVal + 1);
            }
            values[indexVal] = nodeContentValue;
            properties.put((Object)propertyPath, (Object)values);
        } else {
            properties.put((Object)propertyPath, (Object)nodeContentValue);
        }
    }

    private void handleImageType(Resource assetResource, Node childNode, ResourceResolver resourceResolver, Boolean isArray) throws DynamicDeckDynamoException {
        Node propertyPathNode = childNode.getAttributes().getNamedItem("property-path");
        if (propertyPathNode != null) {
            String propertyPath = this.getAssetPropertyPath(propertyPathNode.getNodeValue(), assetResource.getValueMap());
            Node hrefNode = childNode.getAttributes().getNamedItem("href");
            try {
                if (hrefNode != null) {
                    String hrefValue = hrefNode.getNodeValue();
                    if (StringUtils.contains((CharSequence)hrefValue, (CharSequence)"INDD-SERVER-DOCUMENTS/")) {
                        return;
                    }
                    String completeHrefValue = null;
                    if (hrefValue.contains("/content/dam/")) {
                        String hrefEncodedValue = StringUtils.substringAfter((String)URLDecoder.decode(hrefValue, StandardCharsets.UTF_8.toString()), (String)"/content/dam/");
                        completeHrefValue = "/content/dam/" + hrefEncodedValue;
                    }
                    if (null == completeHrefValue) {
                        LOGGER.error("Back track root path is not correct {}", (Object)hrefValue);
                        return;
                    }
                    Resource imageResource = resourceResolver.getResource(completeHrefValue);
                    if (DamUtil.isAsset((Resource)imageResource)) {
                        this.setNewPropertyValue(isArray, propertyPath, assetResource, completeHrefValue);
                    } else {
                        LOGGER.error("ERROR: DATA SYNC : Invalid asset embedded. Asset not found in repository {}", (Object)hrefValue);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new DynamicDeckDynamoException("Exception while handling the image type.", e);
            }
        }
    }

    private String getAssetPropertyPath(String nodeValue, ValueMap properties) {
        String propertyPath = nodeValue;
        if (!properties.containsKey((Object)nodeValue)) {
            propertyPath = "jcr:content/metadata/" + propertyPath;
        }
        return propertyPath;
    }

    private String getAssetPath(NamedNodeMap nodeMap, String assetPath) {
        Node assetPathNode = nodeMap.getNamedItem("asset-path");
        if (assetPathNode != null) {
            return assetPathNode.getNodeValue();
        }
        return assetPath;
    }

    private boolean isFileEligibleToProcess(Resource assetResource) {
        Resource metadataResource = assetResource.getResourceResolver().getResource(assetResource.getPath() + "/" + "jcr:content" + "/" + "metadata");
        if (null == metadataResource) {
            LOGGER.error("Metadata resource is null, hence returning false");
            return false;
        }
        ValueMap metadataValueMap = metadataResource.getValueMap();
        Resource jcrContentResource = assetResource.getResourceResolver().getResource(assetResource.getPath() + "/" + "jcr:content");
        if (null == jcrContentResource) {
            LOGGER.error("JCR Content resource is null, hence returning false");
            return false;
        }
        ValueMap jcrContentValueMap = jcrContentResource.getValueMap();
        String assetMimeType = (String)metadataValueMap.get("dc:format", String.class);
        String assetTemplateType = (String)jcrContentValueMap.get("dam:templateType", String.class);
        Object[] eligibleAssetMimeType = new String[]{"application/x-indesign"};
        return StringUtils.isNotEmpty((CharSequence)assetMimeType) && ArrayUtils.contains((Object[])eligibleAssetMimeType, (Object)assetMimeType) && StringUtils.isNotBlank((CharSequence)assetTemplateType) && assetTemplateType.equals("DYNAMIC DECK");
    }
}

