/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam.impl;

import com.adobe.acs.commons.fam.CancelHandler;
import com.adobe.acs.commons.fam.ThrottledTaskRunner;
import com.adobe.acs.commons.fam.impl.PriorityThreadPoolExecutor;
import com.adobe.acs.commons.fam.impl.RunningStatistic;
import com.adobe.acs.commons.fam.impl.ThrottledTaskRunnerStats;
import com.adobe.acs.commons.fam.impl.TimedRunnable;
import com.adobe.acs.commons.fam.mbean.ThrottledTaskRunnerMBean;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import java.lang.management.ManagementFactory;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="ACS AEM Commons - Throttled Task Runner Service", description="WARNING: Setting a low 'Watchdog time' value that results in the interrupting of writing threads can lead to repository corruption. Ensure that this value is high enough to allow even outlier writing processes to complete.")
@Service(value={ThrottledTaskRunner.class, ThrottledTaskRunnerStats.class})
@Properties(value={@Property(name="jmx.objectname", value={"com.adobe.acs.commons.fam:type=Throttled Task Runner"}, propertyPrivate=true), @Property(name="max.threads", label="Max threads", description="Default is 4, recommended not to exceed the number of CPU cores", value={"4"}), @Property(name="max.cpu", label="Max cpu %", description="Range is 0..1; -1 means disable this check", doubleValue={0.75}), @Property(name="max.heap", label="Max heap %", description="Range is 0..1; -1 means disable this check", doubleValue={0.85}), @Property(name="cooldown.wait.time", label="Cooldown time", description="Time to wait for cpu/mem cooldown between checks", value={"100"}), @Property(name="task.timeout", label="Watchdog time", description="Maximum time allowed (in ms) per action before it is interrupted forcefully. Defaults to 1 hour.", value={"3600000"})})
public class ThrottledTaskRunnerImpl
extends AnnotatedStandardMBean
implements ThrottledTaskRunner,
ThrottledTaskRunnerStats {
    private static final Logger LOG = LoggerFactory.getLogger(ThrottledTaskRunnerImpl.class);
    private int taskTimeout;
    private int cooldownWaitTime;
    private int maxThreads;
    private double maxCpu;
    private double maxHeap;
    private volatile boolean isPaused;
    private final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private ObjectName osBeanName;
    private ObjectName memBeanName;
    private PriorityThreadPoolExecutor workerPool;
    private BlockingQueue<Runnable> workQueue;
    RunningStatistic waitTime = new RunningStatistic("Queue wait time");
    RunningStatistic throttleTime = new RunningStatistic("Throttle time");
    RunningStatistic processingTime = new RunningStatistic("Processing time");
    List<Runnable> resumeList = null;
    private final Semaphore pollingLock = new Semaphore(1);
    private long lastCheck = -1L;
    private boolean wasRecentlyBusy = false;

    public ThrottledTaskRunnerImpl() throws NotCompliantMBeanException {
        super(ThrottledTaskRunnerMBean.class);
    }

    @Override
    public void scheduleWork(Runnable work) {
        TimedRunnable r = new TimedRunnable(work, this, this.taskTimeout, TimeUnit.MILLISECONDS, 0);
        this.submitWork(r);
    }

    @Override
    public void scheduleWork(Runnable work, CancelHandler cancelHandler) {
        TimedRunnable r = new TimedRunnable(work, this, this.taskTimeout, TimeUnit.MILLISECONDS, cancelHandler, 0);
        this.submitWork(r);
    }

    @Override
    public void scheduleWork(Runnable work, int priority) {
        TimedRunnable r = new TimedRunnable(work, this, this.taskTimeout, TimeUnit.MILLISECONDS, priority);
        this.submitWork(r);
    }

    @Override
    public void scheduleWork(Runnable work, CancelHandler cancelHandler, int priority) {
        TimedRunnable r = new TimedRunnable(work, this, this.taskTimeout, TimeUnit.MILLISECONDS, cancelHandler, priority);
        this.submitWork(r);
    }

    private void submitWork(TimedRunnable r) {
        if (this.isPaused) {
            this.resumeList.add(r);
        } else {
            this.workerPool.submit(r);
        }
    }

    @Override
    public void logCompletion(long created, long started, long executed, long finished, boolean successful, Throwable error) {
        this.waitTime.log(started - created);
        this.throttleTime.log(executed - started);
        this.processingTime.log(finished - executed);
    }

    @Override
    public void clearProcessingStatistics() {
        this.waitTime.reset();
        this.throttleTime.reset();
        this.processingTime.reset();
    }

    @Override
    public TabularDataSupport getStatistics() {
        try {
            TabularDataSupport stats = new TabularDataSupport(RunningStatistic.getStaticsTableType());
            stats.put(this.waitTime.getStatistics());
            stats.put(this.throttleTime.getStatistics());
            stats.put(this.processingTime.getStatistics());
            return stats;
        }
        catch (OpenDataException ex) {
            LOG.error("Error generating statistics", (Throwable)ex);
            return null;
        }
    }

    @Override
    public boolean isRunning() {
        return this.workerPool != null && !this.workerPool.isTerminating() && !this.workerPool.isTerminated();
    }

    @Override
    public long getActiveCount() {
        return this.workerPool.getActiveCount();
    }

    @Override
    public long getTaskCount() {
        return this.workerPool.getTaskCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.workerPool.getCompletedTaskCount();
    }

    @Override
    public void pauseExecution() {
        if (this.isRunning()) {
            this.resumeList = this.workerPool.shutdownNow();
            this.isPaused = true;
        }
    }

    @Override
    public void resumeExecution() {
        if (!this.isRunning()) {
            this.initThreadPool();
            if (this.isPaused && this.resumeList != null) {
                this.resumeList.forEach(this.workerPool::execute);
                this.resumeList.clear();
            }
            this.isPaused = false;
        }
    }

    @Override
    public void stopExecution() {
        this.workerPool.shutdownNow();
        this.isPaused = false;
        if (this.resumeList != null) {
            this.resumeList.clear();
        }
    }

    @Override
    public int getMaxThreads() {
        return this.maxThreads;
    }

    private boolean isTooBusy() throws InterruptedException {
        if (this.maxCpu <= 0.0 && this.maxHeap <= 0.0) {
            return false;
        }
        long now = System.currentTimeMillis();
        long timeSinceLastCheck = now - this.lastCheck;
        if (timeSinceLastCheck < 0L || timeSinceLastCheck > (long)this.cooldownWaitTime) {
            this.pollingLock.acquire();
            now = System.currentTimeMillis();
            timeSinceLastCheck = now - this.lastCheck;
            if (timeSinceLastCheck < 0L || timeSinceLastCheck > (long)this.cooldownWaitTime) {
                try {
                    double cpuLevel = this.maxCpu > 0.0 ? this.getCpuLevel() : -1.0;
                    double heapUsage = this.maxHeap > 0.0 ? this.getMemoryUsage() : -1.0;
                    this.wasRecentlyBusy = this.maxCpu > 0.0 && cpuLevel >= this.maxCpu || this.maxHeap > 0.0 && heapUsage >= this.maxHeap;
                }
                catch (InstanceNotFoundException ex) {
                    LOG.error("OS MBean Instance not found (should not ever happen)", (Throwable)ex);
                }
                catch (ReflectionException ex) {
                    LOG.error("OS MBean Instance reflection error (should not ever happen)", (Throwable)ex);
                }
                this.lastCheck = System.currentTimeMillis();
            }
            this.pollingLock.release();
        }
        return this.wasRecentlyBusy;
    }

    @Override
    public void waitForLowCpuAndLowMemory() throws InterruptedException {
        while (this.isTooBusy()) {
            Thread.sleep(this.cooldownWaitTime);
        }
    }

    @Override
    public final double getCpuLevel() throws InstanceNotFoundException, ReflectionException {
        AttributeList list = this.mbs.getAttributes(this.osBeanName, new String[]{"ProcessCpuLoad"});
        if (list.isEmpty()) {
            LOG.error("No CPU stats found for ProcessCpuLoad");
            return -1.0;
        }
        Attribute att = (Attribute)list.get(0);
        return (Double)att.getValue();
    }

    @Override
    public final double getMemoryUsage() {
        try {
            Object memoryusage = this.mbs.getAttribute(this.memBeanName, "HeapMemoryUsage");
            CompositeData cd = (CompositeData)memoryusage;
            long max = (Long)cd.get("max");
            long used = (Long)cd.get("used");
            return (double)used / (double)max;
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
            LOG.error("No Memory stats found for HeapMemoryUsage", (Throwable)e);
            return -1.0;
        }
    }

    @Override
    public double getMaxCpu() {
        return this.maxCpu;
    }

    @Override
    public double getMaxHeap() {
        return this.maxHeap;
    }

    @Override
    public void setThreadPoolSize(int newSize) {
        this.maxThreads = newSize;
        this.initThreadPool();
    }

    private void initThreadPool() {
        if (this.workQueue == null) {
            this.workQueue = new PriorityBlockingQueue<Runnable>();
        }
        if (this.workerPool != null && this.workerPool.getMaximumPoolSize() != this.maxThreads) {
            try {
                this.workerPool.shutdown();
                this.workerPool.awaitTermination(this.taskTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                LOG.error("Timeout occurred when waiting to terminate worker pool", (Throwable)ex);
                this.workerPool.shutdownNow();
            }
            this.workerPool = null;
        }
        if (!this.isRunning()) {
            this.workerPool = new PriorityThreadPoolExecutor(this.maxThreads, this.maxThreads, this.taskTimeout, TimeUnit.MILLISECONDS, this.workQueue);
        }
    }

    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        int defaultThreadCount = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        this.maxCpu = PropertiesUtil.toDouble(properties.get("max.cpu"), (double)0.75);
        this.maxHeap = PropertiesUtil.toDouble(properties.get("max.heap"), (double)0.85);
        this.maxThreads = PropertiesUtil.toInteger(properties.get("max.threads"), (int)defaultThreadCount);
        this.cooldownWaitTime = PropertiesUtil.toInteger(properties.get("cooldown.wait.time"), (int)100);
        this.taskTimeout = PropertiesUtil.toInteger(properties.get("task.timeout"), (int)3600000);
        try {
            this.memBeanName = ObjectName.getInstance("java.lang:type=Memory");
            this.osBeanName = ObjectName.getInstance("java.lang:type=OperatingSystem");
        }
        catch (NullPointerException | MalformedObjectNameException ex) {
            LOG.error("Error getting OS MBean (shouldn't ever happen)", (Throwable)ex);
        }
        this.initThreadPool();
    }
}

