/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam.actions;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.functions.CheckedBiConsumer;
import com.adobe.acs.commons.functions.CheckedConsumer;
import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowModel;
import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowRunner;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public final class Actions {
    private static final Logger LOG = LoggerFactory.getLogger(Actions.class);
    private static ThreadLocal<ActionManager> currentActionManager = new ThreadLocal();

    private Actions() {
    }

    public static ActionManager getCurrentActionManager() {
        return currentActionManager.get();
    }

    public static void setCurrentActionManager(ActionManager a) {
        if (a == null) {
            currentActionManager.remove();
        } else {
            currentActionManager.set(a);
        }
    }

    public static void setCurrentItem(String item) {
        ActionManager manager = Actions.getCurrentActionManager();
        if (manager != null) {
            manager.setCurrentItem(item);
        } else {
            LOG.error("Could not identify current action manager.", (Throwable)new IllegalStateException());
        }
    }

    public static final CheckedBiConsumer<ResourceResolver, String> retryAll(int retries, long pausePerRetry, CheckedBiConsumer<ResourceResolver, String> action) {
        return (r, s) -> {
            int remaining = retries;
            while (remaining > 0) {
                try {
                    action.accept((ResourceResolver)r, (String)s);
                    return;
                }
                catch (InterruptedException e) {
                    r.revert();
                    r.refresh();
                    LOG.info("Timeout reached, aborting work", (Throwable)e);
                    throw e;
                }
                catch (Throwable e) {
                    r.revert();
                    r.refresh();
                    if (remaining-- <= 0) {
                        throw e;
                    }
                    Thread.sleep(pausePerRetry);
                }
            }
        };
    }

    public static final CheckedBiConsumer<ResourceResolver, String> startSyntheticWorkflows(SyntheticWorkflowModel model, SyntheticWorkflowRunner workflowRunner) {
        return (r, path) -> {
            ((Session)r.adaptTo(Session.class)).getWorkspace().getObservationManager().setUserData("changedByWorkflowProcess");
            Actions.nameThread("synWf-" + path);
            workflowRunner.execute((ResourceResolver)r, (String)path, model, false, false);
        };
    }

    public static final CheckedConsumer<ResourceResolver> retry(int retries, long pausePerRetry, CheckedConsumer<ResourceResolver> action) {
        return r -> {
            int remaining = retries;
            while (remaining > 0) {
                try {
                    action.accept((ResourceResolver)r);
                    return;
                }
                catch (InterruptedException e) {
                    r.revert();
                    r.refresh();
                    LOG.info("Timeout reached, aborting work", (Throwable)e);
                    throw e;
                }
                catch (Error e) {
                    LOG.info("Critical runtime exception " + e.getMessage(), (Throwable)e);
                    throw e;
                }
                catch (Throwable e) {
                    LOG.info("Error commit, retry count is {}. Switch to DEBUG logging to get the full stacktrace", (Object)remaining);
                    LOG.debug("Error commit, retry count is " + remaining, e);
                    r.revert();
                    r.refresh();
                    if (--remaining <= 0) {
                        throw e;
                    }
                    Thread.sleep(pausePerRetry);
                }
            }
        };
    }

    public static final CheckedConsumer<ResourceResolver> startSyntheticWorkflow(SyntheticWorkflowModel model, String path, SyntheticWorkflowRunner workflowRunner) {
        return res -> Actions.startSyntheticWorkflows(model, workflowRunner).accept((ResourceResolver)res, path);
    }

    static void nameThread(String string) {
        Thread.currentThread().setName(string);
    }
}

