/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam.impl;

import com.adobe.acs.commons.search.CloseableQuery;
import com.adobe.acs.commons.search.CloseableQueryBuilder;
import com.adobe.granite.asset.api.Asset;
import com.adobe.granite.asset.api.AssetManager;
import com.adobe.granite.asset.api.AssetVersionManager;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.search.PredicateGroup;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Review Task Move Handler", description="Create an OSGi configuration to enable this feature.", metatype=true, immediate=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(label="Event Topics", value={"com/adobe/granite/taskmanagement/event"}, description="[Required] Event Topics this event handler will to respond to. Defaults to: com/adobe/granite/taskmanagement/event", name="event.topics", propertyPrivate=true), @Property(label="Event Filters", value={"(&(TaskTypeName=dam:review)(EventType=TASK_COMPLETED))"}, description="Event Filters used to further restrict this event handler; Uses LDAP expression against event properties. Defaults to: (&(TaskTypeName=dam:review)(EventType=TASK_COMPLETED))", name="event.filter", propertyPrivate=true)})
@Service
public class ReviewTaskAssetMoverHandler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(ReviewTaskAssetMoverHandler.class);
    private static final String PATH_CONTENT_DAM = "/content/dam";
    private static final String APPROVED = "approved";
    private static final String REJECTED = "rejected";
    private static final String REL_ASSET_METADATA = "jcr:content/metadata";
    private static final String REL_ASSET_RENDITIONS = "jcr:content/renditions";
    private static final String REL_PN_DAM_STATUS = "jcr:content/metadata/dam:status";
    private static final String PN_ON_APPROVE = "onApproveMoveTo";
    private static final String PN_ON_REJECT = "onRejectMoveTo";
    private static final String PN_CONTENT_PATH = "contentPath";
    private static final String PN_CONFLICT_RESOLUTION = "onReviewConflictResolution";
    private static final String CONFLICT_RESOLUTION_SKIP = "skip";
    private static final String CONFLICT_RESOLUTION_REPLACE = "replace";
    private static final String CONFLICT_RESOLUTION_NEW_ASSET = "new-asset";
    private static final String CONFLICT_RESOLUTION_NEW_VERSION = "new-version";
    public static final String USER_EVENT_TYPE = "acs-aem-commons.review-task-mover";
    private static final String SERVICE_NAME = "review-task-asset-mover";
    private static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "review-task-asset-mover");
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Scheduler scheduler;
    @Reference
    private CloseableQueryBuilder queryBuilder;
    private static final String DEFAULT_DEFAULT_CONFLICT_RESOLUTION = "new-version";
    private String defaultConflictResolution = "new-version";
    @Property(label="Default Conflict Resolution", description="Select default behavior if conflict resolution is not provided at the review task level.", options={@PropertyOption(name="new-version", value="Add as version (new-version)"), @PropertyOption(name="new-asset", value="Add as new asset (new-asset)"), @PropertyOption(name="replace", value="Replace (replace)"), @PropertyOption(name="skip", value="Skip (skip)")}, value={"new-version"})
    public static final String PROP_DEFAULT_CONFLICT_RESOLUTION = "conflict-resolution.default";
    private static final String DEFAULT_LAST_MODIFIED_BY = "Review Task";
    private String lastModifiedBy = "Review Task";
    @Property(label="Last Modified By", description="For Conflict Resolution: Version, the review task event does not track the user that completed the event. Use this property to specify the static name of of the [dam:Asset]/jcr:content@jcr:lastModifiedBy. Default: Review Task", value={"Review Task"})
    public static final String PROP_LAST_MODIFIED_BY = "conflict-resolution.version.last-modified-by";

    @Activate
    protected void activate(Map<String, Object> config) {
        this.lastModifiedBy = PropertiesUtil.toString((Object)config.get(PROP_LAST_MODIFIED_BY), (String)DEFAULT_LAST_MODIFIED_BY);
        this.defaultConflictResolution = PropertiesUtil.toString((Object)config.get(PROP_DEFAULT_CONFLICT_RESOLUTION), (String)"new-version");
    }

    public void handleEvent(Event event) {
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH_INFO);){
            ValueMap taskProperties;
            String path = (String)event.getProperty("TaskId");
            Resource taskResource = resourceResolver.getResource(path);
            if (taskResource != null && (StringUtils.startsWith((String)((String)(taskProperties = taskResource.getValueMap()).get(PN_ON_APPROVE, String.class)), (String)PATH_CONTENT_DAM) || StringUtils.startsWith((String)((String)taskProperties.get(PN_ON_REJECT, String.class)), (String)PATH_CONTENT_DAM))) {
                log.debug("Handling event (creating a Job) for Assets Review Task @ [ {} ]", (Object)path);
                ScheduleOptions options = this.scheduler.NOW();
                String jobName = this.getClass().getSimpleName().toString().replace(".", "/") + "/" + path;
                options.name(jobName);
                options.canRunConcurrently(false);
                this.scheduler.schedule((Object)new ImmediateJob(path), options);
            }
        }
        catch (LoginException e) {
            log.error("Could not get resource resolver", (Throwable)e);
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindQueryBuilder(CloseableQueryBuilder closeableQueryBuilder) {
        this.queryBuilder = closeableQueryBuilder;
    }

    protected void unbindQueryBuilder(CloseableQueryBuilder closeableQueryBuilder) {
        if (this.queryBuilder == closeableQueryBuilder) {
            this.queryBuilder = null;
        }
    }

    private class ImmediateJob
    implements Runnable {
        private final String path;

        public ImmediateJob(String path) {
            this.path = path;
        }

        @Override
        public void run() {
            block27: {
                try (ResourceResolver resourceResolver = ReviewTaskAssetMoverHandler.this.resourceResolverFactory.getServiceResourceResolver(AUTH_INFO);){
                    ValueMap taskProperties;
                    String contentPath;
                    Resource resource = resourceResolver.getResource(this.path);
                    AssetManager assetManager = (AssetManager)resourceResolver.adaptTo(AssetManager.class);
                    if (resource == null || !StringUtils.startsWith((String)(contentPath = (String)(taskProperties = resource.getValueMap()).get(ReviewTaskAssetMoverHandler.PN_CONTENT_PATH, String.class)), (String)ReviewTaskAssetMoverHandler.PATH_CONTENT_DAM)) break block27;
                    try (CloseableQuery query = this.findAssets(resourceResolver, contentPath);){
                        log.debug("Found [ {} ] assets under [ {} ] that were reviewed and require processing.", (Object)query.getResult().getHits().size(), (Object)contentPath);
                        Iterator assets = query.getResult().getResources();
                        ((Session)resourceResolver.adaptTo(Session.class)).getWorkspace().getObservationManager().setUserData(ReviewTaskAssetMoverHandler.USER_EVENT_TYPE);
                        while (assets.hasNext()) {
                            Asset asset = assetManager.getAsset(((Resource)assets.next()).getPath());
                            this.moveAsset(resourceResolver, assetManager, asset, taskProperties);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Could not process Review Task Mover", (Throwable)e);
                }
            }
        }

        private CloseableQuery findAssets(ResourceResolver resourceResolver, String contentPath) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("type", "dam:Asset");
            params.put("path", contentPath);
            params.put("property", ReviewTaskAssetMoverHandler.REL_PN_DAM_STATUS);
            params.put("property.1_value", ReviewTaskAssetMoverHandler.APPROVED);
            params.put("property.2_value", ReviewTaskAssetMoverHandler.REJECTED);
            params.put("p.offset", "0");
            params.put("p.limit", "-1");
            return ReviewTaskAssetMoverHandler.this.queryBuilder.createQuery(PredicateGroup.create(params), resourceResolver);
        }

        private String createUniqueAssetPath(AssetManager assetManager, String destPath, String assetName) throws PersistenceException {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String now = sdf.format(new Date());
            String destAssetPath = destPath + "/" + assetName;
            int count = 0;
            while (assetManager.assetExists(destAssetPath)) {
                if (count > 1000) {
                    throw new PersistenceException("Unable to generate a unique name after 1000 attempts. Something must be wrong!");
                }
                destAssetPath = count == 0 ? destPath + "/" + now + "_" + assetName : destPath + "/" + now + "_" + count + "_" + assetName;
                ++count;
            }
            return destAssetPath;
        }

        private void createRevision(ResourceResolver resourceResolver, AssetManager assetManager, Asset originalAsset, Asset reviewedAsset) throws PersistenceException {
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            AssetVersionManager versionManager = (AssetVersionManager)resourceResolver.adaptTo(AssetVersionManager.class);
            versionManager.createVersion(originalAsset.getPath(), "Review Task (" + (String)reviewedAsset.getValueMap().get(ReviewTaskAssetMoverHandler.REL_PN_DAM_STATUS, (Object)"Unknown") + ")");
            String assetPath = originalAsset.getPath();
            resourceResolver.delete(resourceResolver.getResource(assetPath + "/" + ReviewTaskAssetMoverHandler.REL_ASSET_METADATA));
            resourceResolver.delete(resourceResolver.getResource(assetPath + "/" + ReviewTaskAssetMoverHandler.REL_ASSET_RENDITIONS));
            try {
                Node originalAssetJcrContentNode = session.getNode(originalAsset.getPath() + "/" + "jcr:content");
                Node newAssetMetadataNode = session.getNode(reviewedAsset.getPath() + "/" + ReviewTaskAssetMoverHandler.REL_ASSET_METADATA);
                Node newAssetRenditionsNode = session.getNode(reviewedAsset.getPath() + "/" + ReviewTaskAssetMoverHandler.REL_ASSET_RENDITIONS);
                JcrUtil.copy((Node)newAssetMetadataNode, (Node)originalAssetJcrContentNode, null);
                JcrUtil.copy((Node)newAssetRenditionsNode, (Node)originalAssetJcrContentNode, null);
                JcrUtil.setProperty((Node)originalAssetJcrContentNode, (String)"jcr:lastModified", (Object)new Date());
                JcrUtil.setProperty((Node)originalAssetJcrContentNode, (String)"jcr:lastModifiedBy", (Object)ReviewTaskAssetMoverHandler.this.lastModifiedBy);
                assetManager.removeAsset(reviewedAsset.getPath());
            }
            catch (RepositoryException e) {
                log.error("Could not create a new version of the asset", (Throwable)e);
                throw new PersistenceException(e.getMessage());
            }
        }

        private void moveAsset(ResourceResolver resourceResolver, AssetManager assetManager, Asset asset, ValueMap taskProperties) {
            try {
                String status = (String)asset.getValueMap().get(ReviewTaskAssetMoverHandler.REL_PN_DAM_STATUS, String.class);
                String conflictResolution = (String)taskProperties.get(ReviewTaskAssetMoverHandler.PN_CONFLICT_RESOLUTION, (Object)ReviewTaskAssetMoverHandler.this.defaultConflictResolution);
                String onApprovePath = (String)taskProperties.get(ReviewTaskAssetMoverHandler.PN_ON_APPROVE, String.class);
                String onRejectPath = (String)taskProperties.get(ReviewTaskAssetMoverHandler.PN_ON_REJECT, String.class);
                String destPath = null;
                if (StringUtils.equals((String)ReviewTaskAssetMoverHandler.APPROVED, (String)status)) {
                    destPath = onApprovePath;
                } else if (StringUtils.equals((String)ReviewTaskAssetMoverHandler.REJECTED, (String)status)) {
                    destPath = onRejectPath;
                }
                if (destPath != null) {
                    if (StringUtils.startsWith((String)destPath, (String)ReviewTaskAssetMoverHandler.PATH_CONTENT_DAM)) {
                        String destAssetPath = destPath + "/" + asset.getName();
                        boolean exists = assetManager.assetExists(destAssetPath);
                        if (exists) {
                            if (StringUtils.equals((String)asset.getPath(), (String)destAssetPath)) {
                                log.info("Reviewed asset [ {} ] is already in its final location, so there is nothing to do.", (Object)asset.getPath());
                            } else if (ReviewTaskAssetMoverHandler.CONFLICT_RESOLUTION_REPLACE.equals(conflictResolution)) {
                                assetManager.removeAsset(destAssetPath);
                                resourceResolver.commit();
                                assetManager.moveAsset(asset.getPath(), destAssetPath);
                                log.info("Moved with replace [ {} ] ~> [ {} ] based on approval status [ {} ]", new Object[]{asset.getPath(), destAssetPath, status});
                            } else if (ReviewTaskAssetMoverHandler.CONFLICT_RESOLUTION_NEW_ASSET.equals(conflictResolution)) {
                                destAssetPath = this.createUniqueAssetPath(assetManager, destPath, asset.getName());
                                assetManager.moveAsset(asset.getPath(), destAssetPath);
                                log.info("Moved with unique asset name [ {} ] ~> [ {} ] based on approval status [ {} ]", new Object[]{asset.getPath(), destAssetPath, status});
                            } else if ("new-version".equals(conflictResolution)) {
                                log.info("Creating new version of existing asset [ {} ] ~> [ {} ] based on approval status [ {} ]", new Object[]{asset.getPath(), destAssetPath, status});
                                this.createRevision(resourceResolver, assetManager, assetManager.getAsset(destAssetPath), asset);
                            } else if (ReviewTaskAssetMoverHandler.CONFLICT_RESOLUTION_SKIP.equals(conflictResolution)) {
                                log.info("Skipping with due to existing asset at the same destination [ {} ] ~> [ {} ] based on approval status [ {} ]", new Object[]{asset.getPath(), destAssetPath, status});
                            }
                        } else {
                            assetManager.moveAsset(asset.getPath(), destAssetPath);
                            log.info("Moved [ {} ] ~> [ {} ] based on approval status [ {} ]", new Object[]{asset.getPath(), destAssetPath, status});
                        }
                    } else {
                        log.warn("Request to move reviewed asset to a non DAM Asset path [ {} ]", (Object)destPath);
                    }
                }
                if (resourceResolver.hasChanges()) {
                    resourceResolver.commit();
                }
            }
            catch (PersistenceException e) {
                log.error("Could not move reviewed asset [ {} ]", (Object)asset.getPath(), (Object)e);
                resourceResolver.revert();
                resourceResolver.refresh();
            }
        }
    }
}

