/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.synthetic.impl.granite;

import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticMetaDataMap;
import com.adobe.acs.commons.workflow.synthetic.impl.granite.SyntheticWorkflow;
import com.adobe.granite.workflow.exec.InboxItem;
import com.adobe.granite.workflow.exec.Status;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.Workflow;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.adobe.granite.workflow.model.WorkflowNode;
import java.util.Date;
import java.util.UUID;

public class SyntheticWorkItem
implements WorkItem {
    private static final String CURRENT_ASSIGNEE = "Synthetic Workflow";
    private final UUID uuid = UUID.randomUUID();
    private Date timeStarted = null;
    private Date timeEnded = null;
    private Date dueTime = null;
    private Date progressBeginTime = null;
    private Workflow workflow;
    private final WorkflowData workflowData;
    private MetaDataMap metaDataMap = new SyntheticMetaDataMap();
    private InboxItem.Priority priority = null;

    public SyntheticWorkItem(WorkflowData workflowData) {
        this.workflowData = workflowData;
        this.timeStarted = new Date();
    }

    public final String getId() {
        return this.uuid.toString() + "_" + this.getWorkflowData().getPayload();
    }

    public final Date getTimeStarted() {
        return this.timeStarted == null ? null : (Date)this.timeStarted.clone();
    }

    public final Date getTimeEnded() {
        return this.timeEnded == null ? null : (Date)this.timeEnded.clone();
    }

    public Date getDueTime() {
        return this.dueTime;
    }

    public Date getProgressBeginTime() {
        return this.progressBeginTime;
    }

    public final void setTimeEnded(Date timeEnded) {
        this.timeEnded = timeEnded == null ? null : (Date)timeEnded.clone();
    }

    public final WorkflowData getWorkflowData() {
        return this.workflowData;
    }

    public final String getCurrentAssignee() {
        return CURRENT_ASSIGNEE;
    }

    public void setDueTime(Date date) {
        this.dueTime = date;
    }

    public void setProgressBeginTime(Date date) {
        this.progressBeginTime = date;
    }

    public void setPriority(InboxItem.Priority priority) {
        this.priority = priority;
    }

    public final MetaDataMap getMetaDataMap() {
        return this.metaDataMap;
    }

    public final Workflow getWorkflow() {
        return this.workflow;
    }

    public final void setWorkflow(SyntheticWorkflow workflow) {
        workflow.setActiveWorkItem(this);
        this.workflow = workflow;
    }

    public Status getStatus() {
        return Status.ACTIVE;
    }

    public final WorkflowNode getNode() {
        return null;
    }

    public String getItemType() {
        return CURRENT_ASSIGNEE;
    }

    public String getItemSubType() {
        return null;
    }

    public String getContentPath() {
        if ("JCR_PATH".equals(this.workflowData.getPayloadType())) {
            return (String)this.workflowData.getPayload();
        }
        return null;
    }

    public InboxItem.Priority getPriority() {
        return this.priority;
    }
}

