/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import com.adobe.acs.commons.search.CloseableQuery;
import com.adobe.acs.commons.search.CloseableQueryBuilder;
import com.adobe.acs.commons.util.ParameterUtil;
import com.adobe.acs.commons.util.QueryHelper;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.result.Hit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

@Component
@Service
public class QueryHelperImpl
implements QueryHelper {
    @Reference
    private CloseableQueryBuilder queryBuilder;
    public static final String QUERY_BUILDER = "queryBuilder";
    public static final String LIST = "list";

    @Override
    public List<Resource> findResources(ResourceResolver resourceResolver, String language, String statement, String relPath) throws RepositoryException {
        if (StringUtils.isEmpty((String)statement)) {
            return Collections.emptyList();
        }
        String[] lines = StringUtils.split((String)statement, (char)'\n');
        if (QUERY_BUILDER.equalsIgnoreCase(language)) {
            return this.getResourcesFromQueryBuilder(resourceResolver, lines, relPath);
        }
        if (LIST.equalsIgnoreCase(language)) {
            return this.getResourcesFromList(resourceResolver, lines, relPath);
        }
        return this.getResourcesFromQuery(resourceResolver, language, statement, relPath);
    }

    private List<Resource> getResourcesFromQuery(ResourceResolver resourceResolver, String language, String statement, String relPath) throws RepositoryException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        QueryManager queryManager = ((Session)resourceResolver.adaptTo(Session.class)).getWorkspace().getQueryManager();
        NodeIterator nodeIter = queryManager.createQuery(statement, language).execute().getNodes();
        while (nodeIter.hasNext()) {
            Resource resource = resourceResolver.getResource(nodeIter.nextNode().getPath());
            Resource relativeAwareResource = this.getRelativeAwareResource(resource, relPath);
            if (relativeAwareResource == null) continue;
            resources.add(relativeAwareResource);
        }
        return resources;
    }

    private List<Resource> getResourcesFromList(ResourceResolver resourceResolver, String[] lines, String relPath) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String line : lines) {
            Resource resource;
            Resource relativeAwareResource;
            if (!StringUtils.isNotBlank((String)line) || (relativeAwareResource = this.getRelativeAwareResource(resource = resourceResolver.getResource(line), relPath)) == null) continue;
            resources.add(relativeAwareResource);
        }
        return resources;
    }

    private List<Resource> getResourcesFromQueryBuilder(ResourceResolver resourceResolver, String[] lines, String relPath) throws RepositoryException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Map<String, String> params = ParameterUtil.toMap(lines, "=", false, null, true);
        if (!params.containsKey("p.limit")) {
            params.put("p.limit", "-1");
        }
        try (CloseableQuery query = this.queryBuilder.createQuery(PredicateGroup.create(params), resourceResolver);){
            List hits = query.getResult().getHits();
            for (Hit hit : hits) {
                Resource resource = resourceResolver.getResource(hit.getPath());
                Resource relativeAwareResource = this.getRelativeAwareResource(resource, relPath);
                if (relativeAwareResource == null) continue;
                resources.add(relativeAwareResource);
            }
        }
        return resources;
    }

    @Override
    public boolean isTraversal(ResourceResolver resourceResolver, String language, String statement) throws RepositoryException {
        QueryManager queryManager = ((Session)resourceResolver.adaptTo(Session.class)).getWorkspace().getQueryManager();
        Query query = queryManager.createQuery("explain " + statement, language);
        QueryResult queryResult = query.execute();
        RowIterator rows = queryResult.getRows();
        Row firstRow = rows.nextRow();
        String plan = firstRow.getValue("plan").getString();
        return StringUtils.contains((String)plan, (String)" /* traverse ");
    }

    @Override
    public boolean isTraversal(ResourceResolver resourceResolver, Map<String, String> queryBuilderParams) throws RepositoryException {
        try (CloseableQuery query = this.queryBuilder.createQuery(PredicateGroup.create(queryBuilderParams), resourceResolver);){
            boolean bl = this.isTraversal(resourceResolver, "xpath", query.getResult().getQueryStatement());
            return bl;
        }
    }

    private Resource getRelativeAwareResource(Resource resource, String relPath) {
        Resource relResource;
        if (resource != null && StringUtils.isNotBlank((String)relPath) && (relResource = resource.getChild(relPath)) != null) {
            return relResource;
        }
        return resource;
    }

    protected void bindQueryBuilder(CloseableQueryBuilder closeableQueryBuilder) {
        this.queryBuilder = closeableQueryBuilder;
    }

    protected void unbindQueryBuilder(CloseableQueryBuilder closeableQueryBuilder) {
        if (this.queryBuilder == closeableQueryBuilder) {
            this.queryBuilder = null;
        }
    }
}

