/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import com.adobe.acs.commons.util.ModeUtil;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static ServiceTracker<AdapterManager, AdapterManager> adapterManagerServiceTracker;
    private static final Logger LOG;

    public void start(BundleContext context) throws Exception {
        LOG.info("{} started", (Object)context.getBundle().getSymbolicName());
        ServiceReference ref = context.getServiceReference(SlingSettingsService.class);
        SlingSettingsService service = (SlingSettingsService)context.getService(ref);
        try {
            ModeUtil.configure(service);
        }
        catch (ConfigurationException ex) {
            LOG.error("Unable to configure ModeUtil with Sling Settings.", (Throwable)ex);
        }
        context.ungetService(ref);
        adapterManagerServiceTracker = new ServiceTracker(context, AdapterManager.class, null);
        adapterManagerServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        adapterManagerServiceTracker.close();
        LOG.info("{} stopped", (Object)context.getBundle().getSymbolicName());
    }

    public static AdapterManager getAdapterManager() {
        return adapterManagerServiceTracker != null ? (AdapterManager)adapterManagerServiceTracker.getService() : null;
    }

    static {
        LOG = LoggerFactory.getLogger(Activator.class);
    }
}

