/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.marketo.impl;

import com.adobe.acs.commons.marketo.MarketoClientConfiguration;
import com.adobe.acs.commons.marketo.MarketoClientConfigurationManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={MarketoClientConfigurationManager.class})
public class MarketoClientConfigurationManagerImpl
implements MarketoClientConfigurationManager {
    private static final Logger log = LoggerFactory.getLogger(MarketoClientConfigurationManagerImpl.class);
    @OSGiService
    private ConfigurationResourceResolver configRsrcRslvr;
    private Resource resource;

    public MarketoClientConfigurationManagerImpl(SlingHttpServletRequest slingRequest) {
        this.resource = slingRequest.getResource().getPath().startsWith("/content") ? slingRequest.getResource() : slingRequest.getRequestPathInfo().getSuffixResource();
    }

    @Override
    public MarketoClientConfiguration getConfiguration() {
        log.trace("getConfiguration");
        log.debug("Using context path: {}", (Object)this.configRsrcRslvr.getContextPath(this.resource));
        return this.configRsrcRslvr.getResourceCollection(this.resource, "settings", "cloudconfigs").stream().filter(c -> {
            boolean matches = "/apps/acs-commons/templates/utilities/marketocloudconfig".equals(c.getValueMap().get("jcr:content/cq:template", (Object)""));
            log.debug("Resource: {} matches: {}", c, (Object)matches);
            return matches;
        }).findFirst().map(c -> c.getChild("jcr:content")).map(c -> (MarketoClientConfiguration)c.adaptTo(MarketoClientConfiguration.class)).orElse(null);
    }

    public void setConfigRsrcRslvr(ConfigurationResourceResolver configRsrcRslvr) {
        this.configRsrcRslvr = configRsrcRslvr;
    }
}

