/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.data;

import com.adobe.acs.commons.data.CompositeVariant;
import com.adobe.acs.commons.data.Variant;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.sling.api.request.RequestParameter;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class Spreadsheet {
    public static final String DEFAULT_DELIMITER = ",";
    public static final String ROW_NUMBER = "~~ROWNUM~~";
    private String fileName = "unknown";
    private int rowCount;
    private transient List<Map<String, CompositeVariant>> dataRows;
    private final List<String> requiredColumns;
    private Map<String, Optional<Class>> headerTypes;
    private List<String> headerRow;
    private final Map<String, String> delimiters;
    private boolean enableHeaderNameConversion = true;
    private InputStream inputStream;
    private List<String> caseInsensitiveHeaders;

    public Spreadsheet(boolean convertHeaderNames, String ... headerArray) {
        this.enableHeaderNameConversion = convertHeaderNames;
        this.headerTypes = Arrays.stream(headerArray).collect(Collectors.toMap(this::convertHeaderName, this::detectTypeFromName));
        this.headerRow = Arrays.asList(headerArray);
        this.requiredColumns = Collections.EMPTY_LIST;
        this.dataRows = new ArrayList<Map<String, CompositeVariant>>();
        this.delimiters = new HashMap<String, String>();
    }

    public Spreadsheet(boolean convertHeaderNames, List<String> caseInsensitiveHeaders, String ... headerArray) {
        this(convertHeaderNames, headerArray);
        this.caseInsensitiveHeaders = caseInsensitiveHeaders;
    }

    public Spreadsheet(boolean convertHeaderNames, InputStream file, String ... required) {
        this.delimiters = new HashMap<String, String>();
        this.enableHeaderNameConversion = convertHeaderNames;
        this.requiredColumns = required == null || required.length == 0 ? Collections.EMPTY_LIST : Arrays.stream(required).map(this::convertHeaderName).collect(Collectors.toList());
        this.inputStream = file;
    }

    public Spreadsheet(boolean convertHeaderNames, RequestParameter file, String ... required) throws IOException {
        this(convertHeaderNames, file.getInputStream(), required);
        this.fileName = file.getFileName();
    }

    public Spreadsheet(InputStream file, String ... required) {
        this(true, file, required);
    }

    public Spreadsheet(RequestParameter file, String ... required) throws IOException {
        this(true, file, required);
    }

    public Spreadsheet(RequestParameter file, List<String> caseInsensitiveHeaders, String ... required) throws IOException {
        this(true, file, required);
        this.caseInsensitiveHeaders = caseInsensitiveHeaders;
    }

    public Spreadsheet buildSpreadsheet() throws IOException {
        return this.buildSpreadsheet(Locale.getDefault());
    }

    public Spreadsheet buildSpreadsheet(Locale locale) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook(this.inputStream);
        XSSFSheet sheet = workbook.getSheetAt(0);
        this.rowCount = sheet.getLastRowNum();
        Iterator rows = sheet.rowIterator();
        Row firstRow = (Row)rows.next();
        this.headerRow = this.readRow(firstRow, locale).stream().map(v -> v != null ? this.convertHeaderName(v.toString()) : null).collect(Collectors.toList());
        this.headerTypes = this.readRow(firstRow, locale).stream().map(Variant::toString).collect(Collectors.toMap(this::convertHeaderName, this::detectTypeFromName, this::upgradeToArray));
        Iterable remainingRows = () -> rows;
        this.dataRows = StreamSupport.stream(remainingRows.spliterator(), false).map(row -> this.buildRow((Row)row, locale)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return this;
    }

    private List<Variant> readRow(Row row, Locale locale) {
        Iterator iterator = row.cellIterator();
        ArrayList<Variant> rowOut = new ArrayList<Variant>();
        while (iterator.hasNext()) {
            Cell c = (Cell)iterator.next();
            while (c.getColumnIndex() > rowOut.size()) {
                rowOut.add(null);
            }
            Variant val = new Variant(c, locale);
            rowOut.add(val.isEmpty() ? null : val);
        }
        return rowOut;
    }

    private Optional<Map<String, CompositeVariant>> buildRow(Row row, Locale locale) {
        LinkedHashMap<String, CompositeVariant<Object>> out = new LinkedHashMap<String, CompositeVariant<Object>>();
        out.put(ROW_NUMBER, new CompositeVariant<Integer>(row.getRowNum()));
        List<Variant> data = this.readRow(row, locale);
        boolean empty = true;
        for (int i = 0; i < data.size() && i < this.getHeaderRow().size(); ++i) {
            Object type;
            String colName = this.getHeaderRow().get(i);
            if (colName == null || data.get(i) == null || data.get(i).isEmpty()) continue;
            empty = false;
            if (!out.containsKey(colName)) {
                type = this.headerTypes.get(colName).orElse(data.get(i).getBaseType());
                if (type == Object.class) {
                    type = data.get(i).getBaseType();
                } else if (type == Object[].class) {
                    type = Spreadsheet.getArrayType(Optional.of(data.get(i).getBaseType())).get();
                }
                out.put(colName, new CompositeVariant<Object>(type));
            }
            if (((Optional)(type = this.headerTypes.get(colName))).isPresent() && ((Optional)type).get().isArray()) {
                String[] values;
                for (String value : values = data.get(i).toString().split(Pattern.quote(this.delimiters.getOrDefault(colName, DEFAULT_DELIMITER)))) {
                    if (value == null || value.isEmpty()) continue;
                    ((CompositeVariant)out.get(colName)).addValue(value.trim());
                }
                continue;
            }
            ((CompositeVariant)out.get(colName)).addValue(data.get(i));
        }
        if (empty || !this.requiredColumns.isEmpty() && !out.keySet().containsAll(this.requiredColumns)) {
            return Optional.empty();
        }
        return Optional.of(out);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public List<String> getHeaderRow() {
        return this.headerRow;
    }

    public List<Map<String, CompositeVariant>> getDataRowsAsCompositeVariants() {
        return this.dataRows;
    }

    public Long getRowNum(Map<String, CompositeVariant> row) {
        if (row.containsKey(ROW_NUMBER)) {
            return row.get(ROW_NUMBER).getValueAs(Long.class);
        }
        return this.dataRows.indexOf(row);
    }

    public List<String> getRequiredColumns() {
        return this.requiredColumns;
    }

    public String convertHeaderName(String str) {
        String name = str.contains("@") ? StringUtils.substringBefore((String)str, (String)"@") : str;
        if (name.contains("[")) {
            name = StringUtils.substringBefore((String)name, (String)"[");
        }
        if (this.enableHeaderNameConversion && this.isHeaderCaseInsensitive(name)) {
            name = String.valueOf(name).toLowerCase().replaceAll("[^0-9a-zA-Z:\\-]+", "_");
        }
        return name;
    }

    private boolean isHeaderCaseInsensitive(String name) {
        return CollectionUtils.isEmpty(this.caseInsensitiveHeaders) || this.caseInsensitiveHeaders.stream().anyMatch(s -> s.equalsIgnoreCase(name));
    }

    private Optional<Class> detectTypeFromName(String name) {
        boolean isArray = false;
        Class detectedClass = Object.class;
        if (name.contains("@")) {
            String typeStr = StringUtils.substringAfter((String)name, (String)"@");
            if (typeStr.contains("[")) {
                typeStr = StringUtils.substringBefore((String)typeStr, (String)"[");
            }
            detectedClass = this.getClassFromName(typeStr);
        }
        if (name.endsWith("]")) {
            isArray = true;
            String delimiter = StringUtils.substringBetween((String)name, (String)"[", (String)"]");
            if (!StringUtils.isEmpty((CharSequence)delimiter)) {
                String colName = this.convertHeaderName(name);
                this.delimiters.put(colName, delimiter);
            }
        }
        if (isArray) {
            return Spreadsheet.getArrayType(Optional.of(detectedClass));
        }
        return Optional.of(detectedClass);
    }

    private Class getClassFromName(String typeStr) {
        switch (typeStr.toLowerCase()) {
            case "int": 
            case "integer": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "double": 
            case "number": {
                return Double.TYPE;
            }
            case "date": 
            case "calendar": 
            case "cal": 
            case "time": {
                return Calendar.class;
            }
            case "boolean": 
            case "bool": {
                return Boolean.TYPE;
            }
        }
        return String.class;
    }

    private Optional<Class> upgradeToArray(Optional<Class> a, Optional<Class> b) {
        if (!a.isPresent()) {
            return b;
        }
        if (!b.isPresent()) {
            return a;
        }
        if (a.get().equals(b.get()) || b.get() == Object.class) {
            return Spreadsheet.getArrayType(a);
        }
        return Spreadsheet.getArrayType(b);
    }

    private static Optional<Class> getArrayType(Optional<Class> clazz) {
        if (!clazz.isPresent()) {
            return Optional.empty();
        }
        if (clazz.get().isArray()) {
            return clazz;
        }
        return Optional.of(Array.newInstance(clazz.get(), 0).getClass());
    }
}

