/*
 * Decompiled with CFR 0.152.
 */
package com.adminlib.widget.svprogresshud;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.adminlib.widget.svprogresshud.SVCircleProgressBar;
import com.adminlib.widget.svprogresshud.SVProgressDefaultView;
import com.adminlib.widget.svprogresshud.SVProgressHUDAnimateUtil;
import com.adminlibs.R;

public class SVProgressHUD {
    private Context context;
    private static SVProgressHUD mSVProgressHUD;
    private static final long DISMISSDELAYED = 1000L;
    private SVProgressHUDMaskType mSVProgressHUDMaskType;
    private final FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2, 80);
    private ViewGroup decorView;
    private ViewGroup rootView;
    private SVProgressDefaultView mSharedView;
    private Animation outAnim;
    private Animation inAnim;
    private int gravity = 17;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            SVProgressHUD.this.dismiss();
        }
    };
    private final View.OnTouchListener onCancelableTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0) {
                SVProgressHUD.this.dismiss();
                SVProgressHUD.this.setCancelable(false);
            }
            return false;
        }
    };
    Animation.AnimationListener outAnimListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            SVProgressHUD.this.dismissImmediately();
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };

    private static final SVProgressHUD getInstance(Context context) {
        if (mSVProgressHUD == null) {
            mSVProgressHUD = new SVProgressHUD();
            SVProgressHUD.mSVProgressHUD.context = context;
            SVProgressHUD.mSVProgressHUD.gravity = 17;
            mSVProgressHUD.initViews();
            mSVProgressHUD.initDefaultView();
            mSVProgressHUD.initAnimation();
        }
        if (context != null && context != SVProgressHUD.mSVProgressHUD.context) {
            SVProgressHUD.mSVProgressHUD.context = context;
            mSVProgressHUD.initViews();
        }
        return mSVProgressHUD;
    }

    protected void initViews() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context);
        this.decorView = (ViewGroup)((Activity)this.context).getWindow().getDecorView().findViewById(0x1020002);
        this.rootView = (ViewGroup)layoutInflater.inflate(R.layout.progress_layout_svprogresshud, null, false);
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    protected void initDefaultView() {
        this.mSharedView = new SVProgressDefaultView(this.context);
        this.params.gravity = this.gravity;
        this.mSharedView.setLayoutParams((ViewGroup.LayoutParams)this.params);
    }

    protected void initAnimation() {
        if (this.inAnim == null) {
            this.inAnim = this.getInAnimation();
        }
        if (this.outAnim == null) {
            this.outAnim = this.getOutAnimation();
        }
    }

    private void onAttached() {
        this.decorView.addView((View)this.rootView);
        if (this.mSharedView.getParent() != null) {
            ((ViewGroup)this.mSharedView.getParent()).removeView((View)this.mSharedView);
        }
        this.rootView.addView((View)this.mSharedView);
    }

    private void svShow() {
        this.mHandler.removeCallbacksAndMessages(null);
        if (!this.isShowing()) {
            this.onAttached();
        }
        this.mSharedView.startAnimation(this.inAnim);
    }

    public static void show(Context context) {
        SVProgressHUD.getInstance(context).setMaskType(SVProgressHUDMaskType.Black);
        SVProgressHUD.getInstance((Context)context).mSharedView.show();
        SVProgressHUD.getInstance(context).svShow();
    }

    public static void showWithMaskType(Context context, SVProgressHUDMaskType maskType) {
        SVProgressHUD.getInstance(context).setMaskType(maskType);
        SVProgressHUD.getInstance((Context)context).mSharedView.show();
        SVProgressHUD.getInstance(context).svShow();
    }

    public static void showWithStatus(Context context, String string) {
        SVProgressHUD.getInstance(context).setMaskType(SVProgressHUDMaskType.Black);
        SVProgressHUD.getInstance((Context)context).mSharedView.showWithStatus(string);
        SVProgressHUD.getInstance(context).svShow();
    }

    public static void showWithStatus(Context context, String string, SVProgressHUDMaskType maskType) {
        SVProgressHUD.getInstance(context).setMaskType(maskType);
        SVProgressHUD.getInstance((Context)context).mSharedView.showWithStatus(string);
        SVProgressHUD.getInstance(context).svShow();
    }

    public static void showInfoWithStatus(Context context, String string) {
        SVProgressHUD.getInstance(context).setMaskType(SVProgressHUDMaskType.Black);
        SVProgressHUD.getInstance((Context)context).mSharedView.showInfoWithStatus(string);
        SVProgressHUD.getInstance(context).svShow();
        SVProgressHUD.getInstance(context).scheduleDismiss();
    }

    public static void showInfoWithStatus(Context context, String string, SVProgressHUDMaskType maskType) {
        SVProgressHUD.getInstance(context).setMaskType(maskType);
        SVProgressHUD.getInstance((Context)context).mSharedView.showInfoWithStatus(string);
        SVProgressHUD.getInstance(context).svShow();
        SVProgressHUD.getInstance(context).scheduleDismiss();
    }

    public static void showSuccessWithStatus(Context context, String string) {
        SVProgressHUD.getInstance(context).setMaskType(SVProgressHUDMaskType.Black);
        SVProgressHUD.getInstance((Context)context).mSharedView.showSuccessWithStatus(string);
        SVProgressHUD.getInstance(context).svShow();
        SVProgressHUD.getInstance(context).scheduleDismiss();
    }

    public static void showSuccessWithStatus(Context context, String string, SVProgressHUDMaskType maskType) {
        SVProgressHUD.getInstance(context).setMaskType(maskType);
        SVProgressHUD.getInstance((Context)context).mSharedView.showSuccessWithStatus(string);
        SVProgressHUD.getInstance(context).svShow();
        SVProgressHUD.getInstance(context).scheduleDismiss();
    }

    public static void showErrorWithStatus(Context context, String string) {
        SVProgressHUD.getInstance(context).setMaskType(SVProgressHUDMaskType.Black);
        SVProgressHUD.getInstance((Context)context).mSharedView.showErrorWithStatus(string);
        SVProgressHUD.getInstance(context).svShow();
        SVProgressHUD.getInstance(context).scheduleDismiss();
    }

    public static void showErrorWithStatus(Context context, String string, SVProgressHUDMaskType maskType) {
        SVProgressHUD.getInstance(context).setMaskType(maskType);
        SVProgressHUD.getInstance((Context)context).mSharedView.showErrorWithStatus(string);
        SVProgressHUD.getInstance(context).svShow();
        SVProgressHUD.getInstance(context).scheduleDismiss();
    }

    public static void showWithProgress(Context context, String string, SVProgressHUDMaskType maskType) {
        SVProgressHUD.getInstance(context).setMaskType(maskType);
        SVProgressHUD.getInstance((Context)context).mSharedView.showWithProgress(string);
        SVProgressHUD.getInstance(context).svShow();
    }

    public static SVCircleProgressBar getProgressBar(Context context) {
        return SVProgressHUD.getInstance((Context)context).mSharedView.getCircleProgressBar();
    }

    public static void setText(Context context, String string) {
        SVProgressHUD.getInstance((Context)context).mSharedView.setText(string);
    }

    private void setMaskType(SVProgressHUDMaskType maskType) {
        this.mSVProgressHUDMaskType = maskType;
        switch (this.mSVProgressHUDMaskType) {
            case None: {
                this.configMaskType(17170445, false, false);
                break;
            }
            case Clear: {
                this.configMaskType(17170445, true, false);
                break;
            }
            case ClearCancel: {
                this.configMaskType(17170445, true, true);
                break;
            }
            case Black: {
                this.configMaskType(R.color.bgColor_overlay, true, false);
                break;
            }
            case BlackCancel: {
                this.configMaskType(R.color.bgColor_overlay, true, true);
                break;
            }
            case Gradient: {
                this.configMaskType(R.drawable.bg_overlay_gradient, true, false);
                break;
            }
            case GradientCancel: {
                this.configMaskType(R.drawable.bg_overlay_gradient, true, true);
                break;
            }
        }
    }

    private void configMaskType(int bg, boolean clickable, boolean cancelable) {
        this.rootView.setBackgroundResource(bg);
        this.rootView.setClickable(clickable);
        this.setCancelable(cancelable);
    }

    public boolean isShowing() {
        return this.rootView.getParent() != null;
    }

    public static boolean isShowing(Context context) {
        return SVProgressHUD.getInstance((Context)context).rootView.getParent() != null;
    }

    public static void dismiss(Context context) {
        SVProgressHUD.getInstance(context).dismiss();
    }

    public void dismiss() {
        this.outAnim.setAnimationListener(this.outAnimListener);
        this.mSharedView.startAnimation(this.outAnim);
    }

    public void dismissImmediately() {
        this.mSharedView.dismiss();
        this.rootView.removeView((View)this.mSharedView);
        this.decorView.removeView((View)this.rootView);
        this.context = null;
    }

    public Animation getInAnimation() {
        int res = SVProgressHUDAnimateUtil.getAnimationResource(this.gravity, true);
        return AnimationUtils.loadAnimation((Context)this.context, (int)res);
    }

    public Animation getOutAnimation() {
        int res = SVProgressHUDAnimateUtil.getAnimationResource(this.gravity, false);
        return AnimationUtils.loadAnimation((Context)this.context, (int)res);
    }

    private void setCancelable(boolean isCancelable) {
        View view = this.rootView.findViewById(R.id.sv_outmost_container);
        if (isCancelable) {
            view.setOnTouchListener(this.onCancelableTouchListener);
        } else {
            view.setOnTouchListener(null);
        }
    }

    private void scheduleDismiss() {
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.sendEmptyMessageDelayed(0, 1000L);
    }

    public static enum SVProgressHUDMaskType {
        None,
        Clear,
        Black,
        Gradient,
        ClearCancel,
        BlackCancel,
        GradientCancel;

    }
}

