/*
 * Decompiled with CFR 0.152.
 */
package com.adminlib.widget.dot;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.adminlibs.R;
import com.adutils.ABTextUtil;

public class Dot
extends ImageView {
    public static final float SCALE = 1.0f;
    public static final int ALPHA = 255;
    private float[] scaleFloats = new float[]{1.0f, 1.0f, 1.0f};
    private int[] alphas = new int[]{255, 255, 255};
    private float defaultSize = 15.0f;
    private Paint paint = null;

    public Dot(Context context) {
        this(context, null);
    }

    public Dot(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        if (null != attrs) {
            TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.BaseDoT);
            try {
                int selectedIndicatorColor = arr.getColor(R.styleable.BaseDoT_circleColor, this.getResources().getColor(R.color.cl_Grid));
                this.setColor(selectedIndicatorColor);
            }
            finally {
                arr.recycle();
            }
        }
    }

    public void setCircleRadius(float circleRadius) {
        if (circleRadius > 0.0f) {
            this.defaultSize = circleRadius * 3.0f;
        }
    }

    public void setColor(int color2) {
        if (this.paint != null) {
            this.paint.setColor(color2);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float radius = this.getWidth() / 3;
        float x = this.getWidth() / 2;
        float y = this.getHeight() / 2;
        canvas.save();
        float translateX = x;
        canvas.translate(translateX, y);
        canvas.scale(this.scaleFloats[0], this.scaleFloats[0]);
        this.paint.setAlpha(this.alphas[0]);
        canvas.drawCircle(0.0f, 0.0f, radius, this.paint);
        canvas.restore();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.measureDimension(ABTextUtil.dip2px((Context)this.getContext(), (float)this.defaultSize), widthMeasureSpec);
        int height = this.measureDimension(ABTextUtil.dip2px((Context)this.getContext(), (float)this.defaultSize), heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private int measureDimension(int defaultSize, int measureSpec) {
        int result = defaultSize;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? Math.min(defaultSize, specSize) : defaultSize);
        return result;
    }
}

