/*
 * Decompiled with CFR 0.152.
 */
package com.adminlib.widget.dot;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import com.adminlibs.R;

public abstract class BaseDoTView
extends LinearLayout {
    protected int mSlideCount;
    private static final int DEFAULT_COLOR = 1;
    private int selectedDotColor = 1;
    private int unselectedDotColor = 1;
    private int mCurrentposition;
    private int circleRadius;

    public BaseDoTView(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseDoTView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initViews();
        this.setGravity(17);
        if (null != attrs) {
            TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.BaseDoTView);
            try {
                int selectedIndicatorColor = arr.getColor(R.styleable.BaseDoTView_selectedIndicatorColor, this.getResources().getColor(R.color.cl_Grid));
                this.setSelectedIndicatorColor(selectedIndicatorColor);
                int UnselectedIndicatorColor = arr.getColor(R.styleable.BaseDoTView_unselectedIndicatorColor, this.getResources().getColor(R.color.cl_gray));
                this.setUnselectedIndicatorColor(UnselectedIndicatorColor);
                int circleRadius = arr.getInt(R.styleable.BaseDoTView_circleRadius, 0);
                if (circleRadius > 0) {
                    this.setCircleRadius(circleRadius);
                }
                int slideCount = arr.getInt(R.styleable.BaseDoTView_slideCount, 0);
                int selected = arr.getInt(R.styleable.BaseDoTView_selectPosition, 0);
                if (slideCount > 0) {
                    this.initialize(slideCount, selected);
                }
            }
            finally {
                arr.recycle();
            }
        }
    }

    public abstract void initialize(int var1, int var2);

    public abstract void setSelectPosition(int var1);

    protected abstract void initViews();

    public void setSelectedIndicatorColor(int selectedDotColor) {
        this.selectedDotColor = selectedDotColor;
    }

    public int getSelectedIndicatorColor() {
        return this.selectedDotColor;
    }

    public void setUnselectedIndicatorColor(int unselectedDotColor) {
        this.unselectedDotColor = unselectedDotColor;
    }

    public int getUnselectedIndicatorColor() {
        return this.unselectedDotColor;
    }

    public int getCurrentposition() {
        return this.mCurrentposition;
    }

    public void setCurrentposition(int mCurrentposition) {
        this.mCurrentposition = mCurrentposition;
    }

    public void setCircleRadius(int circleRadius) {
        this.circleRadius = circleRadius;
    }

    public int getCircleRadius() {
        return this.circleRadius;
    }
}

