/*
 * Decompiled with CFR 0.152.
 */
package com.adminlib.widget.textView;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import com.adminlibs.R;

public class ClearableEditText
extends EditText
implements View.OnTouchListener,
View.OnFocusChangeListener,
TextWatcher {
    private Drawable mClearTextIcon;
    private View.OnFocusChangeListener mOnFocusChangeListener;
    private View.OnTouchListener mOnTouchListener;

    public ClearableEditText(Context context) {
        super(context);
        this.init(context);
    }

    public ClearableEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ClearableEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.mOnFocusChangeListener = onFocusChangeListener;
    }

    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.mOnTouchListener = onTouchListener;
    }

    private void init(Context context) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)R.mipmap.abc_ic_clear_mtrl_alpha);
        Drawable wrappedDrawable = DrawableCompat.wrap((Drawable)drawable2);
        DrawableCompat.setTint((Drawable)wrappedDrawable, (int)this.getCurrentHintTextColor());
        this.mClearTextIcon = wrappedDrawable;
        this.mClearTextIcon.setBounds(0, 0, this.mClearTextIcon.getIntrinsicHeight(), this.mClearTextIcon.getIntrinsicHeight());
        this.setClearIconVisible(false);
        super.setOnTouchListener((View.OnTouchListener)this);
        super.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.addTextChangedListener(this);
    }

    public void onFocusChange(View view, boolean hasFocus) {
        if (hasFocus) {
            this.setClearIconVisible(this.getText().length() > 0);
        } else {
            this.setClearIconVisible(false);
        }
        if (this.mOnFocusChangeListener != null) {
            this.mOnFocusChangeListener.onFocusChange(view, hasFocus);
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        int x = (int)motionEvent.getX();
        if (this.mClearTextIcon.isVisible() && x > this.getWidth() - this.getPaddingRight() - this.mClearTextIcon.getIntrinsicWidth()) {
            if (motionEvent.getAction() == 1) {
                this.setError(null);
                this.setText("");
            }
            return true;
        }
        return this.mOnTouchListener != null && this.mOnTouchListener.onTouch(view, motionEvent);
    }

    public final void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.isFocused()) {
            this.setClearIconVisible(s.length() > 0);
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
    }

    private void setClearIconVisible(boolean visible) {
        this.mClearTextIcon.setVisible(visible, false);
        Drawable[] compoundDrawables = this.getCompoundDrawables();
        this.setCompoundDrawables(compoundDrawables[0], compoundDrawables[1], visible ? this.mClearTextIcon : null, compoundDrawables[3]);
    }
}

