/*
 * Decompiled with CFR 0.152.
 */
package com.adminlib.widget.svprogresshud;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.adminlibs.R;

public class SVCircleProgressBar
extends View {
    private Context mContext;
    private Paint paint;
    private int roundColor;
    private int roundProgressColor;
    private float roundWidth;
    private int max;
    private int progress;
    private int style;
    public static final int STROKE = 0;
    public static final int FILL = 1;

    public SVCircleProgressBar(Context context) {
        this(context, null);
        this.mContext = context;
    }

    public SVCircleProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.mContext = context;
    }

    public SVCircleProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
        this.paint = new Paint();
        TypedArray mTypedArray = context.obtainStyledAttributes(attrs, R.styleable.SVCircleProgressBar);
        this.roundColor = mTypedArray.getColor(R.styleable.SVCircleProgressBar_roundColor, -16776961);
        this.roundProgressColor = mTypedArray.getColor(R.styleable.SVCircleProgressBar_roundProgressColor, -7829368);
        this.roundWidth = mTypedArray.getDimension(R.styleable.SVCircleProgressBar_roundWidth, 5.0f);
        this.max = mTypedArray.getInteger(R.styleable.SVCircleProgressBar_max, 100);
        this.style = mTypedArray.getInt(R.styleable.SVCircleProgressBar_style, 0);
        mTypedArray.recycle();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int centre = this.getWidth() / 2;
        int radius = (int)((float)centre - this.roundWidth / 2.0f);
        this.paint.setAntiAlias(true);
        this.paint.setColor(this.roundColor);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.roundWidth);
        canvas.drawCircle((float)centre, (float)centre, (float)radius, this.paint);
        this.paint.setStrokeWidth(this.roundWidth);
        this.paint.setColor(this.roundProgressColor);
        RectF oval = new RectF((float)(centre - radius), (float)(centre - radius), (float)(centre + radius), (float)(centre + radius));
        switch (this.style) {
            case 0: {
                this.paint.setStyle(Paint.Style.STROKE);
                canvas.drawArc(oval, 270.0f, (float)(360 * this.progress / this.max), false, this.paint);
                break;
            }
            case 1: {
                this.paint.setStyle(Paint.Style.FILL_AND_STROKE);
                if (this.progress == 0) break;
                canvas.drawArc(oval, 270.0f, (float)(360 * this.progress / this.max), true, this.paint);
            }
        }
    }

    public synchronized int getMax() {
        return this.max;
    }

    public synchronized void setMax(int max) {
        if (max < 0) {
            throw new IllegalArgumentException("max not less than 0");
        }
        this.max = max;
    }

    public synchronized int getProgress() {
        return this.progress;
    }

    public synchronized void setProgress(int progress) {
        if (progress < 0) {
            throw new IllegalArgumentException("progress not less than 0");
        }
        if (progress > this.max) {
            progress = this.max;
        }
        if (progress <= this.max) {
            this.progress = progress;
            this.postInvalidate();
        }
    }

    public int getCricleColor() {
        return this.roundColor;
    }

    public void setCricleColor(int cricleColor) {
        this.roundColor = cricleColor;
    }

    public int getCricleProgressColor() {
        return this.roundProgressColor;
    }

    public void setCricleProgressColor(int cricleProgressColor) {
        this.roundProgressColor = cricleProgressColor;
    }

    public float getRoundWidth() {
        return this.roundWidth;
    }

    public void setRoundWidth(float roundWidth) {
        this.roundWidth = roundWidth;
    }
}

