/*
 * Decompiled with CFR 0.152.
 */
package com.adminlib.widget.pop;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.adminlibs.R;
import com.adutils.ABTextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AbListPopupWindow
implements AdapterView.OnItemClickListener {
    private static Context context;
    public static AbListPopupWindow application;
    private View mBaseView;
    private AdapterView.OnItemClickListener mOnItemClickListener;
    private PopupWindow mPopupWindow;
    private ListView mLV_pop;
    private InsideListAdapter mInsideListAdapter;
    private float TextSize = 14.0f;
    private int TextGravity = 17;

    public AbListPopupWindow(Context c) {
    }

    public static AbListPopupWindow getInstance(Context c) {
        if (application == null) {
            application = new AbListPopupWindow(c);
        }
        context = c;
        return application;
    }

    public float getTextSize() {
        return this.TextSize;
    }

    public void setTextSize(float textSize) {
        this.TextSize = ABTextUtil.px2sp((Context)context, (float)textSize);
    }

    public int getTextGravity() {
        return this.TextGravity;
    }

    public void setTextGravity(int textGravity) {
        this.TextGravity = textGravity;
    }

    public AbListPopupWindow(Context context, View baseView, int textSize, List<String> listString, int height, AdapterView.OnItemClickListener onItemClickListener) {
        AbListPopupWindow.context = context;
        this.openPopupWindow(true, baseView, textSize, listString, height, onItemClickListener);
    }

    public AbListPopupWindow(Context context, View baseView, int baseViewWidth, int baseViewHeight, AdapterView.OnItemClickListener onItemClickListener) {
        AbListPopupWindow.context = context;
        this.InitPopupWindow(baseView, baseViewWidth, baseViewHeight, onItemClickListener);
    }

    public void openPopupWindow(boolean isNewPopopWindow, View baseView, int textSize, List<String> listString, int height, AdapterView.OnItemClickListener onItemClickListener) {
        String mLongStr = "";
        for (String str : listString) {
            if (str.length() <= mLongStr.length()) continue;
            mLongStr = str;
        }
        int tSize = ABTextUtil.getFontWidth((int)textSize, (String)"\u6b63");
        int w = baseView.getWidth();
        int tw = mLongStr.length() * tSize;
        if (this.mBaseView == null || isNewPopopWindow || !this.mBaseView.equals(baseView)) {
            if (this.mPopupWindow != null && this.mPopupWindow.isShowing()) {
                this.mPopupWindow.dismiss();
            }
            this.mPopupWindow = null;
            this.InitPopupWindow(baseView, tw > w ? tw : w, height, onItemClickListener);
        } else if (this.mPopupWindow == null) {
            this.InitPopupWindow(baseView, tw > w ? tw : w, height, onItemClickListener);
        } else if (this.mPopupWindow.isShowing()) {
            this.mPopupWindow.dismiss();
        }
        this.setStringData(listString);
        this.mInsideListAdapter.notifyDataSetChanged();
        this.mPopupWindow.showAsDropDown(baseView, 0, 5);
    }

    private void InitPopupWindow(View baseView, int baseViewWidth, int baseViewHeight, AdapterView.OnItemClickListener onItemClickListener) {
        this.mBaseView = baseView;
        this.mOnItemClickListener = onItemClickListener;
        int w = baseViewWidth > baseView.getWidth() ? baseViewWidth : baseView.getWidth();
        LayoutInflater inflater = (LayoutInflater)baseView.getContext().getSystemService("layout_inflater");
        View popView = inflater.inflate(R.layout.popupwindow, null, false);
        this.mLV_pop = (ListView)popView.findViewById(R.id.popupwindow_list);
        this.mLV_pop.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mPopupWindow = new PopupWindow(popView, w <= 0 ? -2 : w, baseViewHeight <= 0 ? -2 : baseViewHeight);
        this.mPopupWindow.setFocusable(true);
        this.mPopupWindow.setOutsideTouchable(true);
        this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable());
        this.mInsideListAdapter = new InsideListAdapter(baseView.getContext());
        this.mLV_pop.setAdapter((ListAdapter)this.mInsideListAdapter);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (this.mOnItemClickListener != null) {
            this.mOnItemClickListener.onItemClick(parent, view, position, id2);
        }
        if (this.mPopupWindow != null && this.mPopupWindow.isShowing()) {
            this.mPopupWindow.dismiss();
        }
    }

    public void setEntityData(List<MyPopupWindowData> myPopupWindowDatas) {
        this.setData(myPopupWindowDatas, 0);
    }

    public void setStringData(List<String> listString) {
        this.setData(this.getEntityData(listString), 0);
    }

    private ArrayList<MyPopupWindowData> getEntityData(List<String> listString) {
        ArrayList<MyPopupWindowData> myPopupWindowDatas = new ArrayList<MyPopupWindowData>();
        if (listString == null || listString.size() < 1) {
            return new ArrayList<MyPopupWindowData>();
        }
        for (int i = 0; i < listString.size(); ++i) {
            MyPopupWindowData data = new MyPopupWindowData();
            data.setmPopItemName(listString.get(i) + "");
            data.setmPopItemCode(i);
            myPopupWindowDatas.add(data);
        }
        return myPopupWindowDatas;
    }

    public void setData(List<MyPopupWindowData> myPopupWindowDatas, int defaultIndex) {
        if (myPopupWindowDatas != null && myPopupWindowDatas.size() != 0) {
            this.mInsideListAdapter.setData(myPopupWindowDatas);
            this.mInsideListAdapter.notifyDataSetChanged();
            this.showPopupWindow();
        }
    }

    public void showPopupWindow() {
        if (this.mPopupWindow.isShowing()) {
            this.mPopupWindow.dismiss();
        }
        this.mPopupWindow.showAsDropDown(this.mBaseView, 0, 5);
    }

    private class InsideListAdapter
    extends BaseAdapter {
        private LayoutInflater layoutInflater;
        private List<MyPopupWindowData> myPopupWindowDatas;

        public InsideListAdapter(Context context) {
            this.layoutInflater = LayoutInflater.from((Context)context);
        }

        public void setData(List<MyPopupWindowData> myPopupWindowDatas) {
            this.myPopupWindowDatas = myPopupWindowDatas;
        }

        public int getCount() {
            if (this.myPopupWindowDatas == null) {
                return 0;
            }
            return this.myPopupWindowDatas.size();
        }

        public MyPopupWindowData getItem(int position) {
            return this.myPopupWindowDatas.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHoler viewHolder = null;
            if (convertView == null) {
                viewHolder = new ViewHoler();
                LinearLayout layout2 = new LinearLayout(context);
                layout2.setBackgroundResource(R.drawable.list_item_bg_select);
                ViewGroup.LayoutParams ltp = new ViewGroup.LayoutParams(-1, -1);
                viewHolder.tV_pop_item = new TextView(context);
                viewHolder.tV_pop_item.setGravity(AbListPopupWindow.this.getTextGravity());
                viewHolder.tV_pop_item.setPadding(0, 8, 0, 8);
                viewHolder.tV_pop_item.setTextSize(AbListPopupWindow.this.getTextSize());
                layout2.addView((View)viewHolder.tV_pop_item, ltp);
                convertView = layout2;
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHoler)convertView.getTag();
            }
            viewHolder.tV_pop_item.setText((CharSequence)this.getItem((int)position).mPopItemName);
            return convertView;
        }

        private class ViewHoler {
            TextView tV_pop_item;

            private ViewHoler() {
            }
        }
    }

    public static class MyPopupWindowData
    implements Serializable {
        public String mPopItemName = "";
        public int mPopItemCode = 0;

        public int getmPopItemCode() {
            return this.mPopItemCode;
        }

        public void setmPopItemCode(int mPopItemCode) {
            this.mPopItemCode = mPopItemCode;
        }

        public String getmPopItemName() {
            return this.mPopItemName;
        }

        public void setmPopItemName(String mPopItemName) {
            this.mPopItemName = mPopItemName;
        }
    }
}

