/*
 * Decompiled with CFR 0.152.
 */
package com.adminlib.widget.MListView;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

public class MViewHolder {
    private final SparseArray<View> mViews;
    private int mPosition;
    private View mConvertView;

    private MViewHolder(Context context, ViewGroup parent, int layoutId, int position) {
        this.mPosition = position;
        this.mViews = new SparseArray();
        this.mConvertView = LayoutInflater.from((Context)context).inflate(layoutId, parent, false);
        this.mConvertView.setTag((Object)this);
    }

    public static MViewHolder get(Context context, View convertView, ViewGroup parent, int layoutId, int position) {
        if (convertView == null) {
            return new MViewHolder(context, parent, layoutId, position);
        }
        return (MViewHolder)convertView.getTag();
    }

    public View getConvertView() {
        return this.mConvertView;
    }

    public <T extends View> T getView(int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.mConvertView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public MViewHolder setText(int viewId, String text) {
        TextView view = (TextView)this.getView(viewId);
        view.setText((CharSequence)text);
        return this;
    }

    public MViewHolder setImageResource(int viewId, int drawableId) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageResource(drawableId);
        return this;
    }

    public MViewHolder setImageBitmap(int viewId, Bitmap bm) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageBitmap(bm);
        return this;
    }

    public MViewHolder setImageByUrl(int viewId, String url) {
        return this;
    }

    public int getPosition() {
        return this.mPosition;
    }
}

