/*
 * Decompiled with CFR 0.152.
 */
package com.adminlib.widget.MListView;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.adminlib.widget.MListView.MViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class MAdapter<T>
extends BaseAdapter {
    private Activity activityContext;
    private ArrayList<T> list = new ArrayList();
    protected int mItemLayoutId;

    protected MAdapter(Activity activity, int itemLayoutId) {
        this.init(activity, new ArrayList(), itemLayoutId);
    }

    protected MAdapter(Activity activity, ArrayList<T> mDatas, int itemLayoutId) {
        this.init(activity, mDatas, itemLayoutId);
    }

    protected void init(Activity activity, ArrayList<T> mDatas, int itemLayoutId) {
        if (activity == null) {
            throw new NullPointerException("\u4e0a\u4e0b\u6587\u4f20\u5165\u4e3a\u7a7a");
        }
        this.activityContext = activity;
        if (mDatas != null) {
            this.list = mDatas;
        }
        this.mItemLayoutId = itemLayoutId;
    }

    public void setData(ArrayList<T> list) {
        this.initData(list);
    }

    public void setDataNotify(ArrayList<T> list) {
        this.initData(list);
        this.notifyDataSetChanged();
    }

    private void initData(ArrayList<T> list) {
        if (list == null || list.size() <= 0) {
            throw new NullPointerException("\u4f20\u5165\u6570\u636e\u6709\u8bef");
        }
        this.list = list;
    }

    public int getCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public T getItem(int position) {
        return this.list.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public void insert(T data) {
        this.list.add(0, data);
        this.notifyDataSetChanged();
    }

    public void append(T data) {
        this.list.add(data);
        this.notifyDataSetChanged();
    }

    public void replace(T data) {
        int idx = this.list.indexOf(data);
        this.replace(idx, data);
    }

    public void replace(int index, T data) {
        if (index < 0) {
            return;
        }
        if (index > this.list.size() - 1) {
            return;
        }
        this.list.set(index, data);
        this.notifyDataSetChanged();
    }

    public List getItems() {
        return this.list;
    }

    public void removeItem(int position) {
        if (this.list.size() <= 0) {
            return;
        }
        if (position < 0) {
            return;
        }
        if (position > this.list.size() - 1) {
            return;
        }
        this.list.remove(position);
        this.notifyDataSetChanged();
    }

    public void clear() {
        if (this.list != null) {
            this.list.clear();
        }
        this.notifyDataSetChanged();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        MViewHolder viewHolder = this.getViewHolder(position, convertView, parent);
        this.ItemConvert(viewHolder, position, this.getItem(position));
        return viewHolder.getConvertView();
    }

    public abstract void ItemConvert(MViewHolder var1, int var2, T var3);

    private MViewHolder getViewHolder(int position, View convertView, ViewGroup parent) {
        return MViewHolder.get((Context)this.activityContext, convertView, parent, this.mItemLayoutId, position);
    }
}

