/*
 * Decompiled with CFR 0.152.
 */
package com.adminlib.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import com.adminlibs.R;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class IndicatorTabView
extends HorizontalScrollView {
    private int mMaxColumn;
    private static final int Default_Column = 3;
    public TabContainer mTabContainer;
    private List<TabB> mTabList = new ArrayList<TabB>();
    private Paint linePaint = new Paint(1);
    private int layoutWidth;
    private TabB tabB;
    public long exitTime = 250L;
    private OnTabSelectedIndexListener tabSelectedIndexListener;
    private static final int TOUCH_STATE_REST = 0;
    private static final int TOUCH_STATE_HORIZONTAL_SCROLLING = 1;
    private static final int TOUCH_STATE_VERTICAL_SCROLLING = -1;
    private int mTouchSlop;
    private int mTouchState = 0;
    private float mLastMotionX;
    private float mLastMotionY;
    private OnBorderListener mOnBorderListener;

    public IndicatorTabView(Context context) {
        this(context, null);
    }

    public IndicatorTabView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IndicatorTabView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setFillViewport(true);
        this.mTabContainer = new TabContainer(context);
        this.mTabContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mTabContainer.setOrientation(0);
        this.addView((View)this.mTabContainer);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.IndicatorTabBar);
        this.mMaxColumn = attributes.getInteger(R.styleable.IndicatorTabBar_tab_max_column, 3);
        attributes.recycle();
        this.linePaint.setStyle(Paint.Style.FILL);
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int mExpandSpec = View.MeasureSpec.makeMeasureSpec((int)0x1FFFFFFF, (int)Integer.MIN_VALUE);
        super.onMeasure(widthMeasureSpec, mExpandSpec);
    }

    public void initView(ArrayList<View> view, int layoutWidth) {
        if (view != null && view.size() > 0) {
            this.initView(view, layoutWidth, this.mMaxColumn);
        }
    }

    public void initView(ArrayList<View> Views, int layoutWidth, int maxColumn) {
        this.layoutWidth = layoutWidth;
        if (maxColumn <= 0) {
            this.setMaxColumn(3);
        }
        int tabWidth = Math.round(layoutWidth / maxColumn);
        this.RemoveAllViews();
        for (int i = 0; i < Views.size(); ++i) {
            this.addView(i, tabWidth, Views.get(i));
        }
    }

    public void setMaxColumn(int column) {
        this.mMaxColumn = column;
    }

    private void addView(int index, int width, View view) {
        if (view == null) {
            return;
        }
        view.setPadding(5, 5, 5, 5);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, -1);
        this.mTabContainer.addView(view, (ViewGroup.LayoutParams)params);
        this.tabB = new TabB();
        this.tabB.setIndex(index);
        this.tabB.setItemTabView(view);
        this.mTabList.add(this.tabB);
        view.setTag((Object)this.tabB);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (IndicatorTabView.this.tabSelectedIndexListener != null) {
                    IndicatorTabView.this.tabSelectedIndexListener.onTabSelected(((TabB)v.getTag()).getIndex());
                }
            }
        });
        this.postInvalidate();
    }

    public void RemoveAllViews() {
        if (this.mTabList != null && this.mTabList.size() > 0) {
            this.mTabContainer.removeAllViews();
            this.mTabList.clear();
            this.postInvalidate();
        }
    }

    public void setTabSelected(int position) {
        int w = this.mTabContainer.getChildAt(0).getWidth();
        if ((position >= 0 || position < this.mTabList.size()) && position >= this.mMaxColumn / 2) {
            this.smoothScrollTo((position - this.mMaxColumn / 2) * w, 0);
        }
    }

    public void LeftGo() {
        if (System.currentTimeMillis() - this.exitTime > 250L) {
            this.exitTime = System.currentTimeMillis();
            this.smoothScrollBy(-this.mTabContainer.getChildAt(0).getWidth(), 0);
        }
    }

    public void RightGo() {
        if (System.currentTimeMillis() - this.exitTime > 250L) {
            this.exitTime = System.currentTimeMillis();
            this.smoothScrollBy(this.mTabContainer.getChildAt(0).getWidth(), 0);
        }
    }

    public void setSelectedIndexListener(OnTabSelectedIndexListener tabSelectedIndexListener) {
        this.tabSelectedIndexListener = tabSelectedIndexListener;
    }

    public int getScreenWidth(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return outMetrics.widthPixels;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        float mScrollX = 0.0f;
        float mScrollY = 0.0f;
        boolean intercept = false;
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 2: {
                boolean yMoved;
                if (this.mTouchState == 1) {
                    intercept = false;
                    break;
                }
                if (this.mTouchState == -1) {
                    intercept = true;
                    break;
                }
                float x = ev.getX();
                float y = ev.getY();
                int xDiff = (int)Math.abs(x - this.mLastMotionX);
                int yDiff = (int)Math.abs(y - this.mLastMotionY);
                boolean xMoved = xDiff > this.mTouchSlop;
                boolean bl = yMoved = yDiff > this.mTouchSlop;
                if (xMoved) {
                    if (xDiff >= yDiff) {
                        this.mTouchState = 1;
                    }
                    this.mLastMotionX = x;
                    break;
                }
                if (!yMoved) break;
                if (yDiff > xDiff) {
                    this.mTouchState = -1;
                }
                this.mLastMotionY = y;
                break;
            }
            case 1: 
            case 3: {
                this.mTouchState = 0;
                intercept = false;
                break;
            }
            case 0: {
                this.mTouchState = 0;
                this.mLastMotionY = ev.getY();
                this.mLastMotionX = ev.getX();
                break;
            }
        }
        this.getParent().requestDisallowInterceptTouchEvent(intercept);
        return super.onInterceptTouchEvent(ev);
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        super.onOverScrolled(scrollX, scrollY, clampedX, clampedY);
        int totalW = 0;
        if (this.mTabContainer != null && this.mTabContainer.getChildCount() > 0 && this.mTabList != null && this.mTabList.size() > 0) {
            totalW = this.mTabContainer.getChildAt(0).getWidth() * this.mTabList.size();
        }
        if (this.mOnBorderListener != null) {
            if (totalW <= this.layoutWidth + scrollX) {
                this.mOnBorderListener.onRight();
            } else if (scrollX == 0) {
                this.mOnBorderListener.onLeft();
            } else {
                this.mOnBorderListener.onScrolled();
            }
        }
    }

    public void setOnBorderListener(OnBorderListener mOnBorderListener) {
        this.mOnBorderListener = mOnBorderListener;
    }

    public static interface OnBorderListener {
        public void onLeft();

        public void onRight();

        public void onScrolled();
    }

    public static class TabB
    implements Serializable {
        private View itemTabView;
        private int index;

        public View getItemTabView() {
            return this.itemTabView;
        }

        public void setItemTabView(View itemTabView) {
            this.itemTabView = itemTabView;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }

    public static interface OnTabSelectedIndexListener {
        public void onTabSelected(int var1);
    }

    private class TabContainer
    extends LinearLayout {
        public TabContainer(Context context) {
            this(context, null);
        }

        public TabContainer(Context context, AttributeSet attrs) {
            this(context, attrs, 0);
        }

        @TargetApi(value=11)
        public TabContainer(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
            this.setGravity(17);
        }
    }
}

