/*
 * Decompiled with CFR 0.152.
 */
package com.adminlib.mine;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import android.widget.Toast;
import com.adutils.ABFileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = "CrashHandler";
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private static CrashHandler INSTANCE = new CrashHandler();
    private Context mContext;
    private Map<String, String> infos = new HashMap<String, String>();
    private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private String fileName;
    private String crashPath;

    private CrashHandler() {
    }

    public static CrashHandler getInstance() {
        return INSTANCE;
    }

    public void initCrash(Context context) {
        this.mContext = context;
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (!this.handleException(ex) && this.mDefaultHandler != null) {
            this.mDefaultHandler.uncaughtException(thread, ex);
        } else {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)"error : ", (Throwable)e);
            }
            Process.killProcess((int)Process.myPid());
            System.exit(1);
        }
    }

    private boolean handleException(Throwable ex) {
        if (ex == null) {
            return false;
        }
        new Thread(){

            @Override
            public void run() {
                Looper.prepare();
                Toast.makeText((Context)CrashHandler.this.mContext, (CharSequence)"\u5f88\u62b1\u6b49,\u7a0b\u5e8f\u51fa\u73b0\u5f02\u5e38,\u5373\u5c06\u9000\u51fa.", (int)1).show();
                Looper.loop();
            }
        }.start();
        this.collectDeviceInfo(this.mContext);
        this.saveCrashInfo2File(ex);
        return true;
    }

    public void collectDeviceInfo(Context ctx) {
        Field[] fields;
        try {
            PackageManager pm = ctx.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(ctx.getPackageName(), 1);
            if (pi != null) {
                String versionName = pi.versionName == null ? "null" : pi.versionName;
                String versionCode = pi.versionCode + "";
                this.infos.put("versionName", versionName);
                this.infos.put("versionCode", versionCode);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"an error occured when collect package info", (Throwable)e);
        }
        for (Field field : fields = Build.class.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                this.infos.put(field.getName(), field.get(null).toString());
                Log.d((String)TAG, (String)(field.getName() + " : " + field.get(null)));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"an error occured when collect crash info", (Throwable)e);
            }
        }
    }

    private String saveCrashInfo2File(Throwable ex) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : this.infos.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append(key + "=" + value + "\n");
        }
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        ex.printStackTrace(printWriter);
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        printWriter.close();
        String result = ((Object)writer).toString();
        sb.append(result);
        try {
            long timestamp = System.currentTimeMillis();
            String time = this.formatter.format(new Date());
            this.fileName = "crash-" + time + "-" + timestamp + ".log";
            if (Environment.getExternalStorageState().equals("mounted")) {
                this.crashPath = ABFileUtil.getCrachDownloadDir((Context)this.mContext);
                File dir = new File(this.crashPath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(this.crashPath + "/" + this.fileName);
                fos.write(sb.toString().getBytes());
                fos.close();
            }
            return this.fileName;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"an error occured while writing file...", (Throwable)e);
            return null;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getCrashPath() {
        return this.crashPath;
    }
}

