/*
 * Decompiled with CFR 0.152.
 */
package com.adminlib.widget.progressDialog.indicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.adminlib.widget.progressDialog.indicator.BaseIndicatorController;
import com.nineoldandroids.animation.ValueAnimator;

public class BallClipRotateMultipleIndicator
extends BaseIndicatorController {
    float scaleFloat = 1.0f;
    float degrees;

    @Override
    public void draw(Canvas canvas, Paint paint) {
        paint.setStrokeWidth(3.0f);
        paint.setStyle(Paint.Style.STROKE);
        float circleSpacing = 12.0f;
        float x = this.getWidth() / 2;
        float y = this.getHeight() / 2;
        canvas.save();
        canvas.translate(x, y);
        canvas.scale(this.scaleFloat, this.scaleFloat);
        canvas.rotate(this.degrees);
        float[] bStartAngles = new float[]{135.0f, -45.0f};
        for (int i = 0; i < 2; ++i) {
            RectF rectF = new RectF(-x + circleSpacing, -y + circleSpacing, x - circleSpacing, y - circleSpacing);
            canvas.drawArc(rectF, bStartAngles[i], 90.0f, false, paint);
        }
        canvas.restore();
        canvas.translate(x, y);
        canvas.scale(this.scaleFloat, this.scaleFloat);
        canvas.rotate(-this.degrees);
        float[] sStartAngles = new float[]{225.0f, 45.0f};
        for (int i = 0; i < 2; ++i) {
            RectF rectF = new RectF(-x / 1.8f + circleSpacing, -y / 1.8f + circleSpacing, x / 1.8f - circleSpacing, y / 1.8f - circleSpacing);
            canvas.drawArc(rectF, sStartAngles[i], 90.0f, false, paint);
        }
    }

    @Override
    public void createAnimation() {
        ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.6f, 1.0f});
        scaleAnim.setDuration(1000L);
        scaleAnim.setRepeatCount(-1);
        scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallClipRotateMultipleIndicator.this.scaleFloat = ((Float)animation.getAnimatedValue()).floatValue();
                BallClipRotateMultipleIndicator.this.postInvalidate();
            }
        });
        scaleAnim.start();
        ValueAnimator rotateAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 180.0f, 360.0f});
        rotateAnim.setDuration(1000L);
        rotateAnim.setRepeatCount(-1);
        rotateAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallClipRotateMultipleIndicator.this.degrees = ((Float)animation.getAnimatedValue()).floatValue();
                BallClipRotateMultipleIndicator.this.postInvalidate();
            }
        });
        rotateAnim.start();
    }
}

