/*
 * Decompiled with CFR 0.152.
 */
package com.adminlib.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.List;

public class ABRadioGroup
extends LinearLayout {
    private int mCheckedId = -1;
    private CompoundButton.OnCheckedChangeListener mChildOnCheckedChangeListener;
    private boolean mProtectFromCheckedChange = false;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private PassThroughHierarchyChangeListener mPassThroughListener;

    public ABRadioGroup(Context context) {
        super(context);
        this.init();
    }

    public ABRadioGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mCheckedId = -1;
        this.setOrientation(0);
        this.mChildOnCheckedChangeListener = new CheckedStateTracker();
        this.mPassThroughListener = new PassThroughHierarchyChangeListener();
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)this.mPassThroughListener);
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener) {
        this.mPassThroughListener.mOnHierarchyChangeListener = listener;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mCheckedId != -1) {
            this.mProtectFromCheckedChange = true;
            this.setCheckedStateForView(this.mCheckedId, true);
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(this.mCheckedId);
        }
    }

    private List<CompoundButton> findCheckedView(View child) {
        ArrayList<Object> allCompoundButtonList = null;
        if (child instanceof CompoundButton) {
            allCompoundButtonList = new ArrayList<CompoundButton>();
            allCompoundButtonList.add((CompoundButton)child);
        } else if (child instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)child;
            int j = group.getChildCount();
            for (int i = 0; i < j; ++i) {
                List<CompoundButton> allChildCompoundButtonList = this.findCheckedView(group.getChildAt(i));
                if (allChildCompoundButtonList == null) continue;
                if (allCompoundButtonList == null) {
                    allCompoundButtonList = new ArrayList();
                }
                allCompoundButtonList.addAll(allChildCompoundButtonList);
            }
        }
        return allCompoundButtonList;
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        List<CompoundButton> viewList = this.findCheckedView(child);
        if (viewList != null && viewList.size() > 0) {
            for (CompoundButton view : viewList) {
                if (!view.isChecked()) continue;
                this.mProtectFromCheckedChange = true;
                if (this.mCheckedId != -1) {
                    this.setCheckedStateForView(this.mCheckedId, false);
                }
                this.mProtectFromCheckedChange = false;
                this.setCheckedId(view.getId());
            }
        }
        super.addView(child, index, params);
    }

    public void check(int id) {
        if (id != -1 && id == this.mCheckedId) {
            return;
        }
        if (this.mCheckedId != -1) {
            this.setCheckedStateForView(this.mCheckedId, false);
        }
        if (id != -1) {
            this.setCheckedStateForView(id, true);
        }
        this.setCheckedId(id);
    }

    private void setCheckedId(int id) {
        this.mCheckedId = id;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this, this.mCheckedId);
        }
    }

    private void setCheckedStateForView(int viewId, boolean checked) {
        View checkedView = this.findViewById(viewId);
        if (checkedView != null && checkedView instanceof CompoundButton) {
            ((CompoundButton)checkedView).setChecked(checked);
        }
    }

    public int getCheckedRadioButtonId() {
        return this.mCheckedId;
    }

    public void clearCheck() {
        this.check(-1);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        @TargetApi(value=17)
        public void onChildViewAdded(View parent, View child) {
            if (parent == ABRadioGroup.this) {
                List viewList = ABRadioGroup.this.findCheckedView(child);
                for (CompoundButton view : viewList) {
                    if (view == null) continue;
                    int id = view.getId();
                    if (id == -1 && Build.VERSION.SDK_INT >= 17) {
                        id = View.generateViewId();
                        view.setId(id);
                    }
                    view.setOnCheckedChangeListener(ABRadioGroup.this.mChildOnCheckedChangeListener);
                }
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            if (parent == ABRadioGroup.this) {
                List viewList = ABRadioGroup.this.findCheckedView(child);
                for (CompoundButton view : viewList) {
                    if (view == null) continue;
                    view.setOnCheckedChangeListener(null);
                }
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }
    }

    private class CheckedStateTracker
    implements CompoundButton.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (ABRadioGroup.this.mProtectFromCheckedChange) {
                return;
            }
            ABRadioGroup.this.mProtectFromCheckedChange = true;
            if (ABRadioGroup.this.mCheckedId != -1) {
                ABRadioGroup.this.setCheckedStateForView(ABRadioGroup.this.mCheckedId, false);
            }
            ABRadioGroup.this.mProtectFromCheckedChange = false;
            int id = buttonView.getId();
            ABRadioGroup.this.setCheckedId(id);
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(ABRadioGroup var1, int var2);
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(int w, int h, float initWeight) {
            super(w, h, initWeight);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        protected void setBaseAttributes(TypedArray a, int widthAttr, int heightAttr) {
            this.width = a.hasValue(widthAttr) ? a.getLayoutDimension(widthAttr, "layout_width") : -2;
            this.height = a.hasValue(heightAttr) ? a.getLayoutDimension(heightAttr, "layout_height") : -2;
        }
    }
}

