/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class AdjustLinkResolution {
    private static volatile ExecutorService executor;
    private static final int maxRecursions = 10;
    private static final String[] expectedUrlHostSuffixArray;

    private AdjustLinkResolution() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void resolveLink(String stringArray, String[] stringArray2, final AdjustLinkResolutionCallback adjustLinkResolutionCallback) {
        URL uRL;
        if (adjustLinkResolutionCallback == null) {
            return;
        }
        if (stringArray == null) {
            adjustLinkResolutionCallback.resolvedLinkCallback(null);
            return;
        }
        final URL uRL2 = null;
        URL uRL3 = uRL;
        try {
            uRL = new URL((String)stringArray);
            uRL2 = uRL3;
        }
        catch (MalformedURLException malformedURLException) {}
        if (uRL2 == null) {
            adjustLinkResolutionCallback.resolvedLinkCallback(null);
            return;
        }
        if (!AdjustLinkResolution.urlMatchesSuffix(uRL2.getHost(), stringArray2)) {
            adjustLinkResolutionCallback.resolvedLinkCallback(AdjustLinkResolution.convertToUri(uRL2));
            return;
        }
        if (executor == null) {
            stringArray = expectedUrlHostSuffixArray;
            // MONITORENTER : expectedUrlHostSuffixArray
            if (executor == null) {
                executor = Executors.newSingleThreadExecutor();
            }
        }
        executor.execute(new Runnable(){

            @Override
            public final void run() {
                AdjustLinkResolution.requestAndResolve(uRL2, 0, adjustLinkResolutionCallback);
            }
        });
    }

    private static void resolveLink(URL uRL, URL uRL2, int n, AdjustLinkResolutionCallback adjustLinkResolutionCallback) {
        if (uRL == null) {
            adjustLinkResolutionCallback.resolvedLinkCallback(AdjustLinkResolution.convertToUri(uRL2));
            return;
        }
        if (AdjustLinkResolution.isTerminalUrl(uRL.getHost())) {
            adjustLinkResolutionCallback.resolvedLinkCallback(AdjustLinkResolution.convertToUri(uRL));
            return;
        }
        if (n > 10) {
            adjustLinkResolutionCallback.resolvedLinkCallback(AdjustLinkResolution.convertToUri(uRL));
            return;
        }
        AdjustLinkResolution.requestAndResolve(uRL, n, adjustLinkResolutionCallback);
    }

    private static void requestAndResolve(URL uRL, int n, AdjustLinkResolutionCallback adjustLinkResolutionCallback) {
        HttpURLConnection httpURLConnection;
        URL uRL2;
        block7: {
            block6: {
                URL uRL3;
                uRL = AdjustLinkResolution.convertToHttps(uRL);
                uRL2 = null;
                httpURLConnection = null;
                try {
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                }
                catch (Throwable throwable) {
                    break block7;
                }
                httpURLConnection.setInstanceFollowRedirects(false);
                httpURLConnection.connect();
                String string = httpURLConnection.getHeaderField("Location");
                if (string == null) break block6;
                URL uRL4 = uRL3;
                uRL3 = new URL(string);
                uRL2 = uRL4;
            }
            httpURLConnection.disconnect();
            AdjustLinkResolution.resolveLink(uRL2, uRL, n + 1, adjustLinkResolutionCallback);
            return;
        }
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        AdjustLinkResolution.resolveLink(uRL2, uRL, n + 1, adjustLinkResolutionCallback);
    }

    private static boolean isTerminalUrl(String string) {
        return AdjustLinkResolution.urlMatchesSuffix(string, expectedUrlHostSuffixArray);
    }

    private static boolean urlMatchesSuffix(String string, String[] stringArray) {
        if (string == null) {
            return false;
        }
        if (stringArray == null) {
            return false;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private static URL convertToHttps(URL uRL) {
        String string = "https:";
        if (uRL == null) {
            return uRL;
        }
        String string2 = uRL.toExternalForm();
        if (string2 != null && string2.startsWith("http:")) {
            URL uRL2;
            URL uRL3;
            try {
                URL uRL4;
                uRL3 = uRL4;
                uRL2 = uRL4;
            }
            catch (MalformedURLException malformedURLException) {}
            uRL3(string + string2.substring(5));
            return uRL2;
        }
        return uRL;
    }

    private static Uri convertToUri(URL uRL) {
        if (uRL == null) {
            return null;
        }
        return Uri.parse((String)uRL.toString());
    }

    static {
        expectedUrlHostSuffixArray = new String[]{"adjust.com", "adj.st", "go.link", "adjust.net.in", "adjust.cn", "adjust.world", "adjust.io"};
    }

    public static interface AdjustLinkResolutionCallback {
        public void resolvedLinkCallback(Uri var1);
    }
}

