/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.network;

import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.AdjustFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UrlStrategy {
    private static final String BASE_URL_IO = "https://app.adjust.io";
    private static final String GDPR_URL_IO = "https://gdpr.adjust.io";
    private static final String SUBSCRIPTION_URL_IO = "https://subscription.adjust.io";
    private static final String PURCHASE_VERIFICATION_URL_IO = "https://ssrv.adjust.io";
    private final List<String> urlStrategyDomains;
    private final boolean useSubdomains;
    private final String baseUrlOverwrite;
    private final String gdprUrlOverwrite;
    private final String subscriptionUrlOverwrite;
    private final String purchaseVerificationUrlOverwrite;
    final List<String> baseUrlChoicesList;
    final List<String> gdprUrlChoicesList;
    final List<String> subscriptionUrlChoicesList;
    final List<String> purchaseVerificationUrlChoicesList;
    boolean wasLastAttemptSuccess;
    int choiceIndex;
    int startingChoiceIndex;
    boolean wasLastAttemptWithOverwrittenUrl;

    public UrlStrategy(String string, String string2, String string3, String string4, List<String> list, boolean bl) {
        UrlStrategy urlStrategy = this;
        this.urlStrategyDomains = list;
        this.useSubdomains = bl;
        this.baseUrlOverwrite = string;
        this.gdprUrlOverwrite = string2;
        this.subscriptionUrlOverwrite = string3;
        urlStrategy.purchaseVerificationUrlOverwrite = string4;
        urlStrategy.baseUrlChoicesList = urlStrategy.baseUrlChoices();
        urlStrategy.gdprUrlChoicesList = urlStrategy.gdprUrlChoices();
        urlStrategy.subscriptionUrlChoicesList = urlStrategy.subscriptionUrlChoices();
        urlStrategy.purchaseVerificationUrlChoicesList = urlStrategy.purchaseVerificationUrlChoices();
        urlStrategy.wasLastAttemptSuccess = false;
        urlStrategy.choiceIndex = 0;
        urlStrategy.startingChoiceIndex = 0;
        urlStrategy.wasLastAttemptWithOverwrittenUrl = false;
    }

    private List<String> baseUrlChoices() {
        List<String> list = ((UrlStrategy)object).urlStrategyDomains;
        if (list != null && !list.isEmpty()) {
            ArrayList arrayList;
            Object object;
            if (((UrlStrategy)object).useSubdomains) {
                ArrayList arrayList2;
                UrlStrategy urlStrategy = object;
                object = arrayList2;
                arrayList2 = new ArrayList();
                for (String string : urlStrategy.urlStrategyDomains) {
                    StringBuilder stringBuilder = new StringBuilder("https://app.");
                    stringBuilder.append(string);
                    ((ArrayList)object).add(stringBuilder.toString());
                }
                return object;
            }
            UrlStrategy urlStrategy = object;
            object = arrayList;
            arrayList = new ArrayList();
            for (String string : urlStrategy.urlStrategyDomains) {
                StringBuilder stringBuilder = new StringBuilder("https://");
                stringBuilder.append(string);
                ((ArrayList)object).add(stringBuilder.toString());
            }
            return object;
        }
        return Arrays.asList("https://app.adjust.com", BASE_URL_IO);
    }

    private List<String> gdprUrlChoices() {
        ArrayList<String> arrayList = ((UrlStrategy)((Object)this)).urlStrategyDomains;
        if (arrayList != null && !arrayList.isEmpty()) {
            ArrayList<String> arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<String>();
            if (((UrlStrategy)((Object)this)).useSubdomains) {
                for (String string : ((UrlStrategy)((Object)this)).urlStrategyDomains) {
                    StringBuilder stringBuilder = new StringBuilder("https://gdpr.");
                    stringBuilder.append(string);
                    arrayList.add(stringBuilder.toString());
                }
            } else {
                for (String string : ((UrlStrategy)((Object)this)).urlStrategyDomains) {
                    StringBuilder stringBuilder = new StringBuilder("https://");
                    stringBuilder.append(string);
                    arrayList.add(stringBuilder.toString());
                }
            }
            return arrayList;
        }
        return Arrays.asList("https://gdpr.adjust.com", GDPR_URL_IO);
    }

    private List<String> subscriptionUrlChoices() {
        ArrayList<String> arrayList = ((UrlStrategy)((Object)this)).urlStrategyDomains;
        if (arrayList != null && !arrayList.isEmpty()) {
            ArrayList<String> arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<String>();
            if (((UrlStrategy)((Object)this)).useSubdomains) {
                for (String string : ((UrlStrategy)((Object)this)).urlStrategyDomains) {
                    StringBuilder stringBuilder = new StringBuilder("https://subscription.");
                    stringBuilder.append(string);
                    arrayList.add(stringBuilder.toString());
                }
            } else {
                for (String string : ((UrlStrategy)((Object)this)).urlStrategyDomains) {
                    StringBuilder stringBuilder = new StringBuilder("https://");
                    stringBuilder.append(string);
                    arrayList.add(stringBuilder.toString());
                }
            }
            return arrayList;
        }
        return Arrays.asList("https://subscription.adjust.com", SUBSCRIPTION_URL_IO);
    }

    private List<String> purchaseVerificationUrlChoices() {
        ArrayList<String> arrayList = ((UrlStrategy)((Object)this)).urlStrategyDomains;
        if (arrayList != null && !arrayList.isEmpty()) {
            ArrayList<String> arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<String>();
            if (((UrlStrategy)((Object)this)).useSubdomains) {
                for (String string : ((UrlStrategy)((Object)this)).urlStrategyDomains) {
                    StringBuilder stringBuilder = new StringBuilder("https://ssrv.");
                    stringBuilder.append(string);
                    arrayList.add(stringBuilder.toString());
                }
            } else {
                for (String string : ((UrlStrategy)((Object)this)).urlStrategyDomains) {
                    StringBuilder stringBuilder = new StringBuilder("https://");
                    stringBuilder.append(string);
                    arrayList.add(stringBuilder.toString());
                }
            }
            return arrayList;
        }
        return Arrays.asList("https://ssrv.adjust.com", PURCHASE_VERIFICATION_URL_IO);
    }

    public void resetAfterSuccess() {
        this.startingChoiceIndex = this.choiceIndex;
        this.wasLastAttemptSuccess = true;
    }

    public boolean shouldRetryAfterFailure(ActivityKind activityKind) {
        this.wasLastAttemptSuccess = false;
        if (AdjustFactory.isAllowUrlStrategyFallback() && this.wasLastAttemptWithOverwrittenUrl) {
            return false;
        }
        int n = activityKind == ActivityKind.GDPR ? this.gdprUrlChoicesList.size() : (activityKind == ActivityKind.SUBSCRIPTION ? this.subscriptionUrlChoicesList.size() : (activityKind == ActivityKind.PURCHASE_VERIFICATION ? this.purchaseVerificationUrlChoicesList.size() : this.baseUrlChoicesList.size()));
        this.choiceIndex = n = (this.choiceIndex + 1) % n;
        return n != this.startingChoiceIndex;
    }

    public String targetUrlByActivityKind(ActivityKind object) {
        if (object == ActivityKind.GDPR) {
            object = this.gdprUrlOverwrite;
            if (object != null) {
                this.wasLastAttemptWithOverwrittenUrl = true;
                return object;
            }
            this.wasLastAttemptWithOverwrittenUrl = false;
            return this.gdprUrlChoicesList.get(this.choiceIndex);
        }
        if (object == ActivityKind.SUBSCRIPTION) {
            object = this.subscriptionUrlOverwrite;
            if (object != null) {
                this.wasLastAttemptWithOverwrittenUrl = true;
                return object;
            }
            this.wasLastAttemptWithOverwrittenUrl = false;
            return this.subscriptionUrlChoicesList.get(this.choiceIndex);
        }
        if (object == ActivityKind.PURCHASE_VERIFICATION) {
            object = this.purchaseVerificationUrlOverwrite;
            if (object != null) {
                this.wasLastAttemptWithOverwrittenUrl = true;
                return object;
            }
            this.wasLastAttemptWithOverwrittenUrl = false;
            return this.purchaseVerificationUrlChoicesList.get(this.choiceIndex);
        }
        object = this.baseUrlOverwrite;
        if (object != null) {
            this.wasLastAttemptWithOverwrittenUrl = true;
            return object;
        }
        this.wasLastAttemptWithOverwrittenUrl = false;
        return this.baseUrlChoicesList.get(this.choiceIndex);
    }
}

