/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.scheduler;

import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Util;
import com.adjust.sdk.scheduler.FutureScheduler;
import com.adjust.sdk.scheduler.SingleThreadFutureScheduler;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TimerCycle {
    private FutureScheduler scheduler;
    private ScheduledFuture waitingTask;
    private String name;
    private Runnable command;
    private long initialDelay;
    private long cycleDelay;
    private boolean isPaused;
    private ILogger logger;

    public TimerCycle(Runnable object, long l, long l2, String string) {
        TimerCycle timerCycle;
        ((TimerCycle)object2).scheduler = new SingleThreadFutureScheduler(string, true);
        ((TimerCycle)object2).name = string;
        ((TimerCycle)object2).command = object;
        ((TimerCycle)object2).initialDelay = l;
        ((TimerCycle)object2).cycleDelay = l2;
        ((TimerCycle)object2).isPaused = true;
        ((TimerCycle)object2).logger = AdjustFactory.getLogger();
        DecimalFormat decimalFormat = Util.SecondsDisplayFormat;
        Object object2 = decimalFormat;
        object2 = ((NumberFormat)object2).format((double)l2 / 1000.0);
        object = decimalFormat.format((double)l / 1000.0);
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        objectArray[1] = object;
        objectArray[2] = object2;
        timerCycle.logger.verbose("%s configured to fire after %s seconds of starting and cycles every %s seconds", objectArray2);
    }

    private void cancel(boolean bl) {
        ScheduledFuture scheduledFuture = this.waitingTask;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(bl);
        }
        this.waitingTask = null;
    }

    public void start() {
        Runnable runnable;
        if (!((TimerCycle)((Object)string)).isPaused) {
            String string = ((TimerCycle)((Object)string)).name;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            ((TimerCycle)((Object)string)).logger.verbose("%s is already started", objectArray2);
            return;
        }
        TimerCycle timerCycle = string;
        Object object = ((TimerCycle)((Object)string)).name;
        Object[] objectArray = new Object[1];
        Object[] objectArray3 = objectArray;
        objectArray[0] = object;
        timerCycle.logger.verbose("%s starting", objectArray3);
        String string = string;
        object = runnable;
        runnable = new Runnable(){

            @Override
            public final void run() {
                1 v0 = string;
                String string = string.TimerCycle.this.name;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = string;
                v0.TimerCycle.this.logger.verbose("%s fired", objectArray2);
                v0.TimerCycle.this.command.run();
            }
        };
        long l = ((TimerCycle)((Object)string)).initialDelay;
        long l2 = ((TimerCycle)((Object)string)).cycleDelay;
        timerCycle.waitingTask = timerCycle.scheduler.scheduleFutureWithFixedDelay((Runnable)object, l, l2);
        timerCycle.isPaused = false;
    }

    public void suspend() {
        Object object;
        if (((TimerCycle)object).isPaused) {
            object = ((TimerCycle)object).name;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            ((TimerCycle)object).logger.verbose("%s is already suspended", objectArray2);
            return;
        }
        TimerCycle timerCycle = object;
        timerCycle.initialDelay = timerCycle.waitingTask.getDelay(TimeUnit.MILLISECONDS);
        timerCycle.waitingTask.cancel(false);
        String string = Util.SecondsDisplayFormat.format((double)((TimerCycle)object).initialDelay / 1000.0);
        object = ((TimerCycle)object).name;
        Object[] objectArray = new Object[2];
        Object[] objectArray3 = objectArray;
        objectArray[0] = object;
        objectArray[1] = string;
        timerCycle.logger.verbose("%s suspended with %s seconds left", objectArray3);
        timerCycle.isPaused = true;
    }

    public void teardown() {
        TimerCycle timerCycle = this;
        timerCycle.cancel(true);
        FutureScheduler futureScheduler = timerCycle.scheduler;
        if (futureScheduler != null) {
            futureScheduler.teardown();
        }
        this.scheduler = null;
    }
}

