/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.network;

import android.content.Context;
import android.net.Uri;
import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AdjustSigner;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SharedPreferencesManager;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.Util;
import com.adjust.sdk.network.IActivityPackageSender;
import com.adjust.sdk.network.UrlStrategy;
import com.adjust.sdk.network.UtilNetworking;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadExecutor;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityPackageSender
implements IActivityPackageSender {
    private String basePath;
    private String gdprPath;
    private String subscriptionPath;
    private String purchaseVerificationPath;
    private String clientSdk;
    private ILogger logger;
    private ThreadExecutor executor;
    private UrlStrategy urlStrategy;
    private UtilNetworking.IHttpsURLConnectionProvider httpsURLConnectionProvider;
    private UtilNetworking.IConnectionOptions connectionOptions;
    private Context context;
    private int connectionTimeout;

    public ActivityPackageSender(List<String> list, boolean bl, String string, String string2, String string3, String string4, String string5, int n, Context context) {
        ActivityPackageSender activityPackageSender = this;
        this.basePath = string;
        this.gdprPath = string2;
        this.subscriptionPath = string3;
        this.purchaseVerificationPath = string4;
        this.clientSdk = string5;
        this.connectionTimeout = n;
        activityPackageSender.context = context;
        activityPackageSender.logger = AdjustFactory.getLogger();
        activityPackageSender.executor = new SingleThreadCachedScheduler("ActivityPackageSender");
        activityPackageSender.urlStrategy = new UrlStrategy(AdjustFactory.getBaseUrl(), AdjustFactory.getGdprUrl(), AdjustFactory.getSubscriptionUrl(), AdjustFactory.getPurchaseVerificationUrl(), list, bl);
        activityPackageSender.httpsURLConnectionProvider = AdjustFactory.getHttpsURLConnectionProvider();
        activityPackageSender.connectionOptions = AdjustFactory.getConnectionOptions();
    }

    private Map<String, String> updateSendingParameters(Map<String, String> hashMap) {
        if (hashMap == null) {
            HashMap<String, String> hashMap2;
            hashMap = hashMap2;
            hashMap2 = new HashMap<String, String>();
        }
        HashMap<String, String> hashMap3 = hashMap;
        long l = System.currentTimeMillis();
        PackageBuilder.addString(hashMap3, "sent_at", Util.dateFormatter.format(l));
        return hashMap3;
    }

    private Map<String, String> signParameters(ActivityPackage activityPackage, Map<String, String> hashMap) {
        HashMap<String, String> hashMap2;
        HashMap<String, String> hashMap3;
        HashMap<String, String> hashMap4 = hashMap3;
        hashMap3 = new HashMap<String, String>(activityPackage.getParameters());
        if (hashMap != null) {
            hashMap4.putAll(hashMap);
        }
        hashMap = hashMap2;
        hashMap();
        hashMap.put("client_sdk", activityPackage.getClientSdk());
        hashMap.put("activity_kind", activityPackage.getActivityKind().toString());
        hashMap2.put("endpoint", activityPackageSender2.urlStrategy.targetUrlByActivityKind(activityPackage.getActivityKind()));
        activityPackage = SharedPreferencesManager.getDefaultInstance(activityPackageSender2.context).getControlParamsJson();
        if (activityPackage != null) {
            Iterator iterator = activityPackage.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    if (!(activityPackage.get(string) instanceof String)) continue;
                }
                catch (JSONException jSONException) {
                    activityPackageSender2.logger.error("JSONException while iterating control params", new Object[0]);
                    continue;
                }
                hashMap.put(string, (String)activityPackage.get(string));
            }
        }
        ActivityPackageSender activityPackageSender = activityPackageSender2;
        ActivityPackageSender activityPackageSender2 = activityPackageSender.context;
        return AdjustSigner.sign(hashMap4, hashMap, (Context)activityPackageSender2, activityPackageSender.logger);
    }

    private boolean shouldRetryToSendWithUrlStrategy(ResponseData responseData) {
        if (responseData.jsonResponse != null) {
            ActivityPackageSender activityPackageSender = this;
            activityPackageSender.logger.debug("Will not retry with current url strategy, already got a valid json response", new Object[0]);
            activityPackageSender.urlStrategy.resetAfterSuccess();
            return false;
        }
        if (this.urlStrategy.shouldRetryAfterFailure(responseData.activityKind)) {
            this.logger.error("Failed with current url strategy, but it will retry with new", new Object[0]);
            return true;
        }
        this.logger.error("Failed with current url strategy and it will not retry", new Object[0]);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void tryToGetResponse(ResponseData object) {
        Throwable throwable3;
        DataOutputStream dataOutputStream;
        block55: {
            UnsupportedEncodingException unsupportedEncodingException2;
            block53: {
                MalformedURLException malformedURLException2;
                block52: {
                    ProtocolException protocolException2;
                    block51: {
                        SocketTimeoutException socketTimeoutException2;
                        Object object2;
                        block50: {
                            SSLHandshakeException sSLHandshakeException2;
                            block49: {
                                IOException iOException2;
                                block48: {
                                    Throwable throwable22;
                                    block47: {
                                        boolean bl;
                                        Object object3;
                                        block54: {
                                            block45: {
                                                block46: {
                                                    DataOutputStream dataOutputStream2;
                                                    URL uRL;
                                                    String string;
                                                    Map<String, String> map;
                                                    dataOutputStream = null;
                                                    object3 = ActivityPackageSender.extractAuthorizationHeader(((ResponseData)object).signedParameters);
                                                    this.logger.verbose("authorizationHeader: %s", object3);
                                                    boolean bl2 = ((ResponseData)object).activityPackage.getActivityKind() == ActivityKind.ATTRIBUTION;
                                                    if (bl2) {
                                                        object2 = ((ResponseData)object).activityPackage.getPath();
                                                        map = ((ResponseData)object).activityPackage.getParameters();
                                                        Map<String, String> map2 = ((ResponseData)object).sendingParameters;
                                                        Map<String, String> map3 = ((ResponseData)object).signedParameters;
                                                        string = this.generateUrlStringForGET(((ResponseData)object).activityPackage.getActivityKind(), (String)object2, map, map2, map3);
                                                    } else {
                                                        object2 = ((ResponseData)object).activityPackage.getPath();
                                                        map = ((ResponseData)object).signedParameters;
                                                        string = this.generateUrlStringForPOST(((ResponseData)object).activityPackage.getActivityKind(), (String)object2, map);
                                                    }
                                                    object2 = string;
                                                    String string2 = object3;
                                                    map = uRL;
                                                    uRL = new URL((String)object2);
                                                    object2 = this.httpsURLConnectionProvider.generateHttpsURLConnection((URL)((Object)map));
                                                    this.connectionOptions.applyConnectionOptions((HttpsURLConnection)object2, this.clientSdk, this.connectionTimeout);
                                                    if (string2 != null) {
                                                        ((URLConnection)object2).setRequestProperty("Authorization", (String)object3);
                                                    }
                                                    if (bl2) {
                                                        dataOutputStream2 = this.configConnectionForGET((HttpsURLConnection)object2);
                                                    } else {
                                                        object3 = ((ResponseData)object).activityPackage.getParameters();
                                                        Map<String, String> map4 = ((ResponseData)object).sendingParameters;
                                                        map = ((ResponseData)object).signedParameters;
                                                        dataOutputStream2 = this.configConnectionForPOST((HttpsURLConnection)object2, (Map<String, String>)object3, map4, map);
                                                    }
                                                    dataOutputStream = dataOutputStream2;
                                                    object3 = this.readConnectionResponse((HttpsURLConnection)object2, (ResponseData)object);
                                                    boolean bl3 = ((ResponseData)object).jsonResponse != null && ((ResponseData)object).retryIn == null && object3 != null && (Integer)object3 == 200;
                                                    ((ResponseData)object).success = bl3;
                                                    object3 = ((ResponseData)object).jsonResponse;
                                                    if (object3 == null) break block45;
                                                    try {
                                                        if (((ResponseData)object).retryIn == null) break block46;
                                                        break block45;
                                                    }
                                                    catch (Throwable throwable22) {
                                                        break block47;
                                                    }
                                                    catch (IOException iOException2) {
                                                        break block48;
                                                    }
                                                    catch (SSLHandshakeException sSLHandshakeException2) {
                                                        break block49;
                                                    }
                                                    catch (SocketTimeoutException socketTimeoutException2) {
                                                        break block50;
                                                    }
                                                    catch (ProtocolException protocolException2) {
                                                        break block51;
                                                    }
                                                    catch (MalformedURLException malformedURLException2) {
                                                        break block52;
                                                    }
                                                    catch (UnsupportedEncodingException unsupportedEncodingException2) {
                                                        break block53;
                                                    }
                                                }
                                                bl = false;
                                                break block54;
                                            }
                                            bl = true;
                                        }
                                        ((ResponseData)object).willRetry = bl;
                                        if (object3 == null) {
                                            ((ResponseData)object).activityPackage.addError(1000);
                                        } else if (((ResponseData)object).retryIn != null) {
                                            ((ResponseData)object).activityPackage.addError(1001);
                                        }
                                        if (dataOutputStream == null) return;
                                        try {
                                            DataOutputStream dataOutputStream3 = dataOutputStream;
                                            dataOutputStream3.flush();
                                            ((OutputStream)dataOutputStream3).close();
                                            return;
                                        }
                                        catch (IOException iOException3) {
                                            object = ((ResponseData)object).activityPackage;
                                            this.logger.error(this.errorMessage(iOException3, "Flushing and closing connection output stream", (ActivityPackage)object), new Object[0]);
                                            return;
                                        }
                                    }
                                    try {
                                        String string = "Sending SDK package";
                                        this.localError(throwable22, string, (ResponseData)object, 1100);
                                        if (dataOutputStream == null) return;
                                    }
                                    catch (Throwable throwable3) {}
                                    try {
                                        DataOutputStream dataOutputStream4 = dataOutputStream;
                                        dataOutputStream4.flush();
                                        ((OutputStream)dataOutputStream4).close();
                                        return;
                                    }
                                    catch (IOException iOException4) {
                                        object = ((ResponseData)object).activityPackage;
                                        this.logger.error(this.errorMessage(iOException4, "Flushing and closing connection output stream", (ActivityPackage)object), new Object[0]);
                                        return;
                                    }
                                }
                                String string = "Request failed";
                                object2 = 1007;
                                this.remoteError(iOException2, string, (ResponseData)object, (Integer)object2);
                                if (dataOutputStream == null) return;
                                try {
                                    DataOutputStream dataOutputStream5 = dataOutputStream;
                                    dataOutputStream5.flush();
                                    ((OutputStream)dataOutputStream5).close();
                                    return;
                                }
                                catch (IOException iOException5) {
                                    object = ((ResponseData)object).activityPackage;
                                    this.logger.error(this.errorMessage(iOException5, "Flushing and closing connection output stream", (ActivityPackage)object), new Object[0]);
                                    return;
                                }
                            }
                            String string = "Certificate failed";
                            object2 = 1006;
                            this.remoteError(sSLHandshakeException2, string, (ResponseData)object, (Integer)object2);
                            if (dataOutputStream == null) return;
                            try {
                                DataOutputStream dataOutputStream6 = dataOutputStream;
                                dataOutputStream6.flush();
                                ((OutputStream)dataOutputStream6).close();
                                return;
                            }
                            catch (IOException iOException) {
                                object = ((ResponseData)object).activityPackage;
                                this.logger.error(this.errorMessage(iOException, "Flushing and closing connection output stream", (ActivityPackage)object), new Object[0]);
                                return;
                            }
                        }
                        String string = "Request timed out";
                        object2 = 1005;
                        this.remoteError(socketTimeoutException2, string, (ResponseData)object, (Integer)object2);
                        if (dataOutputStream == null) return;
                        try {
                            DataOutputStream dataOutputStream7 = dataOutputStream;
                            dataOutputStream7.flush();
                            ((OutputStream)dataOutputStream7).close();
                            return;
                        }
                        catch (IOException iOException) {
                            object = ((ResponseData)object).activityPackage;
                            this.logger.error(this.errorMessage(iOException, "Flushing and closing connection output stream", (ActivityPackage)object), new Object[0]);
                            return;
                        }
                    }
                    String string = "Protocol Error";
                    this.localError(protocolException2, string, (ResponseData)object, 1004);
                    if (dataOutputStream == null) return;
                    try {
                        DataOutputStream dataOutputStream8 = dataOutputStream;
                        dataOutputStream8.flush();
                        ((OutputStream)dataOutputStream8).close();
                        return;
                    }
                    catch (IOException iOException) {
                        object = ((ResponseData)object).activityPackage;
                        this.logger.error(this.errorMessage(iOException, "Flushing and closing connection output stream", (ActivityPackage)object), new Object[0]);
                        return;
                    }
                }
                String string = "Malformed URL";
                this.localError(malformedURLException2, string, (ResponseData)object, 1003);
                if (dataOutputStream == null) return;
                try {
                    DataOutputStream dataOutputStream9 = dataOutputStream;
                    dataOutputStream9.flush();
                    ((OutputStream)dataOutputStream9).close();
                    return;
                }
                catch (IOException iOException) {
                    object = ((ResponseData)object).activityPackage;
                    this.logger.error(this.errorMessage(iOException, "Flushing and closing connection output stream", (ActivityPackage)object), new Object[0]);
                    return;
                }
            }
            String string = "Failed to encode parameters";
            this.localError(unsupportedEncodingException2, string, (ResponseData)object, 1002);
            if (dataOutputStream == null) return;
            break block55;
            try {
                DataOutputStream dataOutputStream10 = dataOutputStream;
                dataOutputStream10.flush();
                ((OutputStream)dataOutputStream10).close();
                return;
            }
            catch (IOException iOException) {
                object = ((ResponseData)object).activityPackage;
                this.logger.error(this.errorMessage(iOException, "Flushing and closing connection output stream", (ActivityPackage)object), new Object[0]);
            }
            return;
        }
        if (dataOutputStream == null) throw throwable3;
        try {
            DataOutputStream dataOutputStream11 = dataOutputStream;
            dataOutputStream11.flush();
            ((OutputStream)dataOutputStream11).close();
            throw throwable3;
        }
        catch (IOException iOException) {
            object = ((ResponseData)object).activityPackage;
            this.logger.error(this.errorMessage(iOException, "Flushing and closing connection output stream", (ActivityPackage)object), new Object[0]);
        }
        throw throwable3;
    }

    private void localError(Throwable throwable, String string, ResponseData responseData, int n) {
        String string2 = this.errorMessage(throwable, string, responseData.activityPackage);
        this.logger.error(string2, new Object[0]);
        responseData.message = string2;
        responseData.willRetry = false;
        responseData.activityPackage.addError(n);
    }

    private void remoteError(Throwable throwable, String string, ResponseData responseData, Integer n) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        String string2 = stringBuilder.append(this.errorMessage(throwable, string, responseData.activityPackage)).append(" Will retry later").toString();
        this.logger.error(string2, new Object[0]);
        responseData.message = string2;
        responseData.willRetry = true;
        responseData.activityPackage.addError(n);
    }

    private String errorMessage(Throwable object, String objectArray, ActivityPackage activityPackage) {
        String string = activityPackage.getFailureMessage();
        object = Util.getReasonString((String)objectArray, (Throwable)object);
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray2[0] = string;
        objectArray2[1] = object;
        return Util.formatString("%s. (%s)", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private String generateUrlStringForGET(ActivityKind object, String object22, Map<String, String> map, Map<String, String> map2, Map<String, String> map3) {
        Object object3;
        block5: {
            void var4_11;
            void var3_10;
            block4: {
                Uri.Builder builder;
                URL uRL;
                void var5_12;
                ActivityPackageSender activityPackageSender = object3;
                object3 = activityPackageSender.urlWithExtraPathByActivityKind((ActivityKind)((Object)object), ActivityPackageSender.extractTargetUrl((Map<String, String>)var5_12, (ActivityKind)((Object)object), ((ActivityPackageSender)object3).urlStrategy));
                object = uRL;
                uRL = new URL((String)object3);
                object3 = builder;
                object3();
                object3.scheme(((URL)object).getProtocol());
                object3.encodedAuthority(((URL)object).getAuthority());
                object3.path(((URL)object).getPath());
                builder.appendPath((String)object22);
                object = object3.toString();
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = object;
                activityPackageSender.logger.debug("Making request to url: %s", objectArray2);
                if (var5_12 == null || var5_12.isEmpty()) break block4;
                for (Map.Entry entry : var5_12.entrySet()) {
                    object3.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
                }
                break block5;
            }
            if (var3_10 != null) {
                for (Map.Entry entry : var3_10.entrySet()) {
                    object3.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (var4_11 == null) break block5;
            for (Map.Entry entry : var4_11.entrySet()) {
                object3.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return object3.build().toString();
    }

    private String generateUrlStringForPOST(ActivityKind object, String string, Map<String, String> objectArray) {
        object = objectArray4.urlWithExtraPathByActivityKind((ActivityKind)((Object)object), ActivityPackageSender.extractTargetUrl(objectArray, object, objectArray4.urlStrategy));
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray2[0] = object;
        objectArray2[1] = string;
        object = Util.formatString("%s%s", objectArray);
        Object[] objectArray3 = new Object[1];
        Object[] objectArray4 = objectArray3;
        objectArray3[0] = object;
        objectArray4.logger.debug("Making request to url : %s", objectArray4);
        return object;
    }

    private String urlWithExtraPathByActivityKind(ActivityKind activityKind, String string) {
        if (activityKind == ActivityKind.GDPR) {
            if (this.gdprPath != null) {
                return string + this.gdprPath;
            }
        } else if (activityKind == ActivityKind.SUBSCRIPTION) {
            if (this.subscriptionPath != null) {
                return string + this.subscriptionPath;
            }
        } else if (activityKind == ActivityKind.PURCHASE_VERIFICATION) {
            if (this.purchaseVerificationPath != null) {
                return string + this.purchaseVerificationPath;
            }
        } else if (this.basePath != null) {
            return string + this.basePath;
        }
        return string;
    }

    private DataOutputStream configConnectionForGET(HttpsURLConnection httpsURLConnection) {
        httpsURLConnection.setRequestMethod("GET");
        return null;
    }

    private DataOutputStream configConnectionForPOST(HttpsURLConnection httpsURLConnection, Map<String, String> map, Map<String, String> map2, Map<String, String> map3) {
        HttpsURLConnection httpsURLConnection2 = httpsURLConnection;
        httpsURLConnection2.setRequestMethod("POST");
        httpsURLConnection2.setUseCaches(false);
        httpsURLConnection2.setDoInput(true);
        httpsURLConnection2.setDoOutput(true);
        String string = ((ActivityPackageSender)((Object)string)).generatePOSTBodyString(map, map2, map3);
        if (string == null) {
            return null;
        }
        DataOutputStream dataOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
        dataOutputStream.writeBytes(string);
        return dataOutputStream;
    }

    private String generatePOSTBodyString(Map<String, String> map, Map<String, String> map2, Map<String, String> map3) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (map3 != null && !map3.isEmpty()) {
            this.injectParametersToPOSTStringBuilder(map3, stringBuilder2);
        } else {
            if (map != null && !map.isEmpty()) {
                this.injectParametersToPOSTStringBuilder(map, stringBuilder2);
            }
            if (map2 != null && !map2.isEmpty()) {
                this.injectParametersToPOSTStringBuilder(map2, stringBuilder2);
            }
        }
        if (stringBuilder2.length() > 0) {
            StringBuilder stringBuilder3 = stringBuilder2;
            if (stringBuilder3.charAt(stringBuilder3.length() - 1) == '&') {
                StringBuilder stringBuilder4 = stringBuilder2;
                stringBuilder4.deleteCharAt(stringBuilder4.length() - 1);
            }
        }
        return stringBuilder2.toString();
    }

    private void injectParametersToPOSTStringBuilder(Map<String, String> object, StringBuilder stringBuilder) {
        if (object != null && !object.isEmpty()) {
            for (Map.Entry entry : object.entrySet()) {
                object = URLEncoder.encode((String)entry.getKey(), "UTF-8");
                String string = (String)entry.getValue();
                string = string != null ? URLEncoder.encode(string, "UTF-8") : "";
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.append((String)object);
                stringBuilder2.append("=");
                stringBuilder2.append(string);
                stringBuilder2.append("&");
            }
        }
    }

    private void parseResponse(ResponseData responseData, String string) {
        JSONObject jSONObject;
        if (string.length() == 0) {
            this.logger.error("Empty response string", new Object[0]);
            return;
        }
        JSONObject jSONObject2 = null;
        JSONObject jSONObject3 = jSONObject;
        try {
            jSONObject = new JSONObject(string);
            jSONObject2 = jSONObject3;
        }
        catch (JSONException jSONException) {
            ActivityPackageSender activityPackageSender = this;
            string = activityPackageSender.errorMessage(jSONException, "Failed to parse JSON response", responseData.activityPackage);
            activityPackageSender.logger.error(string, new Object[0]);
        }
        if (jSONObject2 == null) {
            return;
        }
        responseData.jsonResponse = jSONObject2;
        responseData.message = UtilNetworking.extractJsonString(jSONObject2, "message");
        responseData.adid = UtilNetworking.extractJsonString(jSONObject2, "adid");
        responseData.timestamp = UtilNetworking.extractJsonString(jSONObject2, "timestamp");
        string = UtilNetworking.extractJsonString(jSONObject2, "tracking_state");
        if (string != null && string.equals("opted_out")) {
            responseData.trackingState = TrackingState.OPTED_OUT;
        }
        responseData.askIn = UtilNetworking.extractJsonLong(jSONObject2, "ask_in");
        responseData.retryIn = UtilNetworking.extractJsonLong(jSONObject2, "retry_in");
        responseData.continueIn = UtilNetworking.extractJsonLong(jSONObject2, "continue_in");
        responseData.attribution = Util.attributionFromJson(jSONObject2.optJSONObject("attribution"), Util.getSdkPrefixPlatform(this.clientSdk));
        responseData.resolvedDeeplink = UtilNetworking.extractJsonString(jSONObject2, "resolved_click_url");
        responseData.controlParams = jSONObject2.optJSONObject("control_params");
    }

    private static String extractAuthorizationHeader(Map<String, String> map) {
        return map.remove("authorization");
    }

    private static String extractTargetUrl(Map<String, String> object, ActivityKind activityKind, UrlStrategy urlStrategy) {
        if ((object = object.remove("endpoint")) != null) {
            return object;
        }
        return urlStrategy.targetUrlByActivityKind(activityKind);
    }

    @Override
    public void sendActivityPackage(final ActivityPackage activityPackage, final Map<String, String> map, final IActivityPackageSender.ResponseDataCallbackSubscriber responseDataCallbackSubscriber) {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                1 v0 = activityPackage2;
                ActivityPackage activityPackage2 = v0.activityPackage;
                activityPackage2.responseDataCallbackSubscriber.onResponseDataCallback(activityPackage2.ActivityPackageSender.this.sendActivityPackageSync(activityPackage2, v0.map));
            }
        });
    }

    @Override
    public ResponseData sendActivityPackageSync(ActivityPackage activityPackage, Map<String, String> map) {
        Object object;
        ActivityPackageSender activityPackageSender;
        do {
            activityPackageSender = this;
            object = this.updateSendingParameters(map);
            object = ResponseData.buildResponseData(activityPackage, object, this.signParameters(activityPackage, (Map<String, String>)object));
            activityPackageSender.tryToGetResponse((ResponseData)object);
        } while (activityPackageSender.shouldRetryToSendWithUrlStrategy((ResponseData)object));
        return object;
    }

    /*
     * Exception decompiling
     */
    public Integer readConnectionResponse(HttpsURLConnection var1_2, ResponseData var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [5, 4 : 49->59)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

