/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPurchaseVerificationHandler;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.PurchaseVerificationResponseData;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.Util;
import com.adjust.sdk.network.IActivityPackageSender;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadScheduler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PurchaseVerificationHandler
implements IPurchaseVerificationHandler {
    private static final double MILLISECONDS_TO_SECONDS_DIVISOR = 1000.0;
    private static final String SCHEDULED_EXECUTOR_SOURCE = "PurchaseVerificationHandler";
    private boolean paused;
    private ILogger logger;
    private BackoffStrategy backoffStrategy;
    private List<ActivityPackage> packageQueue;
    private ThreadScheduler scheduler;
    private WeakReference<IActivityHandler> activityHandlerWeakRef;
    private IActivityPackageSender activityPackageSender;
    private long lastPackageRetryInMilli = 0L;

    public PurchaseVerificationHandler(IActivityHandler iActivityHandler, boolean bl, IActivityPackageSender iActivityPackageSender) {
        this.init(iActivityHandler, bl, iActivityPackageSender);
        this.logger = AdjustFactory.getLogger();
        this.backoffStrategy = AdjustFactory.getSdkClickBackoffStrategy();
        this.scheduler = new SingleThreadCachedScheduler(SCHEDULED_EXECUTOR_SOURCE);
    }

    private void sendNextPurchaseVerificationPackage() {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                PurchaseVerificationHandler.this.sendNextPurchaseVerificationPackageI();
            }
        });
    }

    private void sendNextPurchaseVerificationPackageI() {
        Runnable runnable;
        Object object = (IActivityHandler)this.activityHandlerWeakRef.get();
        if (object.getActivityState() == null) {
            return;
        }
        if (object.getActivityState().isGdprForgotten) {
            return;
        }
        if (this.paused) {
            return;
        }
        if (this.packageQueue.isEmpty()) {
            return;
        }
        PurchaseVerificationHandler purchaseVerificationHandler = this;
        object = purchaseVerificationHandler.packageQueue.remove(0);
        Runnable runnable2 = runnable;
        runnable = new Runnable((ActivityPackage)object){
            public final /* synthetic */ ActivityPackage a;
            {
                this.a = activityPackage;
            }

            @Override
            public final void run() {
                3 v0 = this;
                v0.PurchaseVerificationHandler.this.sendPurchaseVerificationPackageI(this.a);
                v0.PurchaseVerificationHandler.this.sendNextPurchaseVerificationPackage();
            }
        };
        long l = purchaseVerificationHandler.waitTime(((ActivityPackage)object).getRetries());
        if (l > 0L) {
            this.scheduler.schedule(runnable2, l);
        } else {
            runnable2.run();
        }
    }

    private void sendPurchaseVerificationPackageI(ActivityPackage activityPackage) {
        PurchaseVerificationHandler purchaseVerificationHandler = this;
        IActivityHandler iActivityHandler = (IActivityHandler)purchaseVerificationHandler.activityHandlerWeakRef.get();
        Object object = purchaseVerificationHandler.generateSendingParametersI();
        if (!((object = purchaseVerificationHandler.activityPackageSender.sendActivityPackageSync(activityPackage, (Map<String, String>)object)) instanceof PurchaseVerificationResponseData)) {
            return;
        }
        PurchaseVerificationResponseData purchaseVerificationResponseData = (PurchaseVerificationResponseData)object;
        if (purchaseVerificationResponseData.willRetry) {
            this.retrySendingI(activityPackage, ((ResponseData)object).retryIn);
            return;
        }
        this.lastPackageRetryInMilli = 0L;
        if (iActivityHandler == null) {
            return;
        }
        if (purchaseVerificationResponseData.trackingState == TrackingState.OPTED_OUT) {
            iActivityHandler.gotOptOutResponse();
            return;
        }
        iActivityHandler.finishedTrackingActivity(purchaseVerificationResponseData);
    }

    private Map<String, String> generateSendingParametersI() {
        HashMap<String, String> hashMap;
        PurchaseVerificationHandler purchaseVerificationHandler = hashMap2;
        HashMap<String, String> hashMap2 = hashMap;
        long l = System.currentTimeMillis();
        PackageBuilder.addString(new HashMap<String, String>(), "sent_at", Util.dateFormatter.format(l));
        int n = purchaseVerificationHandler.packageQueue.size() - 1;
        if (n > 0) {
            long l2 = n;
            PackageBuilder.addLong((Map<String, String>)hashMap2, "queue_size", l2);
        }
        return hashMap2;
    }

    private void retrySendingI(ActivityPackage activityPackage, Long l) {
        if (l != null && l > 0L) {
            this.lastPackageRetryInMilli = l;
        } else {
            int n = activityPackage.increaseRetries();
            Integer n2 = n;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = n2;
            this.logger.error("Retrying purchase_verification package for the %d time", objectArray2);
        }
        this.sendPurchaseVerificationPackage(activityPackage);
    }

    private long waitTime(int n) {
        long l = ((PurchaseVerificationHandler)((Object)string)).lastPackageRetryInMilli;
        if (l > 0L) {
            return l;
        }
        if (n > 0) {
            l = Util.getWaitingTime(n, ((PurchaseVerificationHandler)((Object)string)).backoffStrategy);
            PurchaseVerificationHandler purchaseVerificationHandler = string;
            double d = (double)l / 1000.0;
            String string = Util.SecondsDisplayFormat.format(d);
            Integer n2 = n;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray[1] = n2;
            purchaseVerificationHandler.logger.verbose("Waiting for %s seconds before retrying purchase_verification for the %d time", objectArray2);
            return l;
        }
        return 0L;
    }

    @Override
    public void init(IActivityHandler iActivityHandler, boolean bl, IActivityPackageSender iActivityPackageSender) {
        PurchaseVerificationHandler purchaseVerificationHandler = this;
        purchaseVerificationHandler.paused = bl ^ true;
        purchaseVerificationHandler.packageQueue = new ArrayList<ActivityPackage>();
        purchaseVerificationHandler.activityHandlerWeakRef = new WeakReference<IActivityHandler>(iActivityHandler);
        this.activityPackageSender = iActivityPackageSender;
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
        this.sendNextPurchaseVerificationPackage();
    }

    @Override
    public void sendPurchaseVerificationPackage(final ActivityPackage activityPackage) {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                1 v0 = string;
                v0.PurchaseVerificationHandler.this.packageQueue.add(string.activityPackage);
                Object[] objectArray = Integer.valueOf(string.PurchaseVerificationHandler.this.packageQueue.size());
                Object[] objectArray2 = new Object[1];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = objectArray;
                v0.PurchaseVerificationHandler.this.logger.debug("Added purchase_verification %d", objectArray3);
                String string = string.activityPackage.getExtendedString();
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = string;
                v0.PurchaseVerificationHandler.this.logger.verbose("%s", objectArray);
                v0.PurchaseVerificationHandler.this.sendNextPurchaseVerificationPackage();
            }
        });
    }

    @Override
    public void teardown() {
        PurchaseVerificationHandler purchaseVerificationHandler = this;
        purchaseVerificationHandler.logger.verbose("PurchaseVerificationHandler teardown", new Object[0]);
        WeakReference<IActivityHandler> weakReference = purchaseVerificationHandler.scheduler;
        if (weakReference != null) {
            weakReference.teardown();
        }
        if ((weakReference = this.packageQueue) != null) {
            weakReference.clear();
        }
        if ((weakReference = this.activityHandlerWeakRef) != null) {
            weakReference.clear();
        }
        PurchaseVerificationHandler purchaseVerificationHandler2 = this;
        purchaseVerificationHandler2.logger = null;
        purchaseVerificationHandler2.packageQueue = null;
        purchaseVerificationHandler2.backoffStrategy = null;
        purchaseVerificationHandler2.scheduler = null;
    }
}

