/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.os.Handler;
import android.os.HandlerThread;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IRequestHandler;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import javax.net.ssl.HttpsURLConnection;

public class RequestHandler
extends HandlerThread
implements IRequestHandler {
    private Handler internalHandler;
    private IPackageHandler packageHandler;
    private ILogger logger;

    public RequestHandler(IPackageHandler packageHandler) {
        super("Adjust", 1);
        this.setDaemon(true);
        this.start();
        this.logger = AdjustFactory.getLogger();
        this.internalHandler = new Handler(this.getLooper());
        this.init(packageHandler);
    }

    @Override
    public void init(IPackageHandler packageHandler) {
        this.packageHandler = packageHandler;
    }

    @Override
    public void sendPackage(final ActivityPackage activityPackage, final int queueSize) {
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                RequestHandler.this.sendInternal(activityPackage, queueSize);
            }
        });
    }

    private void sendInternal(ActivityPackage activityPackage, int queueSize) {
        String targetURL = "https://app.adjust.com" + activityPackage.getPath();
        try {
            HttpsURLConnection connection = Util.createPOSTHttpsURLConnection(targetURL, activityPackage.getClientSdk(), activityPackage.getParameters(), queueSize);
            ResponseData responseData = Util.readHttpResponse(connection, activityPackage);
            if (responseData.jsonResponse == null) {
                this.packageHandler.closeFirstPackage(responseData, activityPackage);
                return;
            }
            this.packageHandler.sendNextPackage(responseData);
        }
        catch (UnsupportedEncodingException e) {
            this.sendNextPackage(activityPackage, "Failed to encode parameters", e);
        }
        catch (SocketTimeoutException e) {
            this.closePackage(activityPackage, "Request timed out", e);
        }
        catch (IOException e) {
            this.closePackage(activityPackage, "Request failed", e);
        }
        catch (Throwable e) {
            this.sendNextPackage(activityPackage, "Runtime exception", e);
        }
    }

    private void closePackage(ActivityPackage activityPackage, String message, Throwable throwable) {
        String packageMessage = activityPackage.getFailureMessage();
        String reasonString = Util.getReasonString(message, throwable);
        String finalMessage = String.format("%s. (%s) Will retry later", packageMessage, reasonString);
        this.logger.error(finalMessage, new Object[0]);
        ResponseData responseData = ResponseData.buildResponseData(activityPackage);
        responseData.message = finalMessage;
        this.packageHandler.closeFirstPackage(responseData, activityPackage);
    }

    private void sendNextPackage(ActivityPackage activityPackage, String message, Throwable throwable) {
        String failureMessage = activityPackage.getFailureMessage();
        String reasonString = Util.getReasonString(message, throwable);
        String finalMessage = String.format("%s. (%s)", failureMessage, reasonString);
        this.logger.error(finalMessage, new Object[0]);
        ResponseData responseData = ResponseData.buildResponseData(activityPackage);
        responseData.message = finalMessage;
        this.packageHandler.sendNextPackage(responseData);
    }
}

