/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AttributionResponseData;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IAttributionHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SessionResponseData;
import com.adjust.sdk.TimerOnce;
import com.adjust.sdk.Util;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.json.JSONObject;

public class AttributionHandler
implements IAttributionHandler {
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private IActivityHandler activityHandler;
    private ILogger logger = AdjustFactory.getLogger();
    private ActivityPackage attributionPackage;
    private TimerOnce timer;
    private static final String ATTRIBUTION_TIMER_NAME = "Attribution timer";
    private boolean paused;
    private boolean hasListener;
    public URL lastUrlUsed;

    public AttributionHandler(IActivityHandler activityHandler, ActivityPackage attributionPackage, boolean startsSending, boolean hasListener) {
        if (this.scheduler != null) {
            this.timer = new TimerOnce(this.scheduler, new Runnable(){

                @Override
                public void run() {
                    AttributionHandler.this.getAttributionInternal();
                }
            }, ATTRIBUTION_TIMER_NAME);
        } else {
            this.logger.error("Timer not initialized, attribution handler is disabled", new Object[0]);
        }
        this.init(activityHandler, attributionPackage, startsSending, hasListener);
    }

    @Override
    public void init(IActivityHandler activityHandler, ActivityPackage attributionPackage, boolean startsSending, boolean hasListener) {
        this.activityHandler = activityHandler;
        this.attributionPackage = attributionPackage;
        this.paused = !startsSending;
        this.hasListener = hasListener;
    }

    @Override
    public void getAttribution() {
        this.getAttribution(0L);
    }

    @Override
    public void checkSessionResponse(final SessionResponseData sessionResponseData) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                AttributionHandler.this.checkSessionResponseInternal(sessionResponseData);
            }
        });
    }

    private void checkAttributionResponse(final AttributionResponseData attributionResponseData) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                AttributionHandler.this.checkAttributionResponseInternal(attributionResponseData);
            }
        });
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    private void getAttribution(long delayInMilliseconds) {
        if (this.timer.getFireIn() > delayInMilliseconds) {
            return;
        }
        if (delayInMilliseconds != 0L) {
            double waitTimeSeconds = (double)delayInMilliseconds / 1000.0;
            String secondsString = Util.SecondsDisplayFormat.format(waitTimeSeconds);
            this.logger.debug("Waiting to query attribution in %s seconds", secondsString);
        }
        this.timer.startIn(delayInMilliseconds);
    }

    private void checkAttributionInternal(ResponseData responseData) {
        if (responseData.jsonResponse == null) {
            return;
        }
        long timerMilliseconds = responseData.jsonResponse.optLong("ask_in", -1L);
        if (timerMilliseconds >= 0L) {
            this.activityHandler.setAskingAttribution(true);
            this.getAttribution(timerMilliseconds);
            return;
        }
        this.activityHandler.setAskingAttribution(false);
        JSONObject attributionJson = responseData.jsonResponse.optJSONObject("attribution");
        responseData.attribution = AdjustAttribution.fromJson(attributionJson);
    }

    private void checkSessionResponseInternal(SessionResponseData sessionResponseData) {
        this.checkAttributionInternal(sessionResponseData);
        this.activityHandler.launchSessionResponseTasks(sessionResponseData);
    }

    private void checkAttributionResponseInternal(AttributionResponseData attributionResponseData) {
        this.checkAttributionInternal(attributionResponseData);
        this.activityHandler.launchAttributionResponseTasks(attributionResponseData);
    }

    private void getAttributionInternal() {
        if (!this.hasListener) {
            return;
        }
        if (this.paused) {
            this.logger.debug("Attribution handler is paused", new Object[0]);
            return;
        }
        this.logger.verbose("%s", this.attributionPackage.getExtendedString());
        try {
            AdjustFactory.URLGetConnection urlGetConnection = Util.createGETHttpsURLConnection(this.buildUri(this.attributionPackage.getPath(), this.attributionPackage.getParameters()).toString(), this.attributionPackage.getClientSdk());
            ResponseData responseData = Util.readHttpResponse(urlGetConnection.httpsURLConnection, this.attributionPackage);
            this.lastUrlUsed = urlGetConnection.url;
            if (!(responseData instanceof AttributionResponseData)) {
                return;
            }
            this.checkAttributionResponse((AttributionResponseData)responseData);
        }
        catch (Exception e) {
            this.logger.error("Failed to get attribution (%s)", e.getMessage());
            return;
        }
    }

    private Uri buildUri(String path, Map<String, String> parameters) {
        Uri.Builder uriBuilder = new Uri.Builder();
        uriBuilder.scheme("https");
        uriBuilder.authority("app.adjust.com");
        uriBuilder.appendPath(path);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        long now = System.currentTimeMillis();
        String dateString = Util.dateFormat(now);
        uriBuilder.appendQueryParameter("sent_at", dateString);
        return uriBuilder.build();
    }
}

