/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Process;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AttributionResponseData;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.EventResponseData;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IAttributionHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.ISdkClickHandler;
import com.adjust.sdk.LogLevel;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SessionResponseData;
import com.adjust.sdk.TimerCycle;
import com.adjust.sdk.TimerOnce;
import com.adjust.sdk.Util;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class ActivityHandler
extends HandlerThread
implements IActivityHandler {
    private static long FOREGROUND_TIMER_INTERVAL;
    private static long FOREGROUND_TIMER_START;
    private static long BACKGROUND_TIMER_INTERVAL;
    private static long SESSION_INTERVAL;
    private static long SUBSESSION_INTERVAL;
    private static final String TIME_TRAVEL = "Time travel!";
    private static final String ADJUST_PREFIX = "adjust_";
    private static final String ACTIVITY_STATE_NAME = "Activity state";
    private static final String ATTRIBUTION_NAME = "Attribution";
    private static final String FOREGROUND_TIMER_NAME = "Foreground timer";
    private static final String BACKGROUND_TIMER_NAME = "Background timer";
    private Handler internalHandler;
    private IPackageHandler packageHandler;
    private ActivityState activityState;
    private ILogger logger;
    private TimerCycle foregroundTimer;
    private ScheduledExecutorService scheduler;
    private TimerOnce backgroundTimer;
    private InternalState internalState;
    private DeviceInfo deviceInfo;
    private AdjustConfig adjustConfig;
    private AdjustAttribution attribution;
    private IAttributionHandler attributionHandler;
    private ISdkClickHandler sdkClickHandler;

    private ActivityHandler(AdjustConfig adjustConfig) {
        super("Adjust", 1);
        this.setDaemon(true);
        this.start();
        this.init(adjustConfig);
        this.logger = AdjustFactory.getLogger();
        if ("production".equals(adjustConfig.environment)) {
            this.logger.setLogLevel(LogLevel.ASSERT);
        } else {
            this.logger.setLogLevel(adjustConfig.logLevel);
        }
        this.internalHandler = new Handler(this.getLooper());
        this.internalState = new InternalState();
        this.readAttribution(adjustConfig.context);
        this.readActivityState(adjustConfig.context);
        this.internalState.enabled = this.activityState == null ? true : this.activityState.enabled;
        this.internalState.offline = false;
        this.internalState.background = true;
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.initInternal();
            }
        });
        FOREGROUND_TIMER_INTERVAL = AdjustFactory.getTimerInterval();
        FOREGROUND_TIMER_START = AdjustFactory.getTimerStart();
        BACKGROUND_TIMER_INTERVAL = AdjustFactory.getTimerInterval();
        this.foregroundTimer = new TimerCycle(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.foregroundTimerFired();
            }
        }, FOREGROUND_TIMER_START, FOREGROUND_TIMER_INTERVAL, FOREGROUND_TIMER_NAME);
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.backgroundTimer = new TimerOnce(this.scheduler, new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.backgroundTimerFired();
            }
        }, BACKGROUND_TIMER_NAME);
    }

    @Override
    public void init(AdjustConfig adjustConfig) {
        this.adjustConfig = adjustConfig;
    }

    public static ActivityHandler getInstance(AdjustConfig adjustConfig) {
        if (adjustConfig == null) {
            AdjustFactory.getLogger().error("AdjustConfig missing", new Object[0]);
            return null;
        }
        if (!adjustConfig.isValid()) {
            AdjustFactory.getLogger().error("AdjustConfig not initialized correctly", new Object[0]);
            return null;
        }
        if (adjustConfig.processName != null) {
            int currentPid = Process.myPid();
            ActivityManager manager = (ActivityManager)adjustConfig.context.getSystemService("activity");
            if (manager == null) {
                return null;
            }
            for (ActivityManager.RunningAppProcessInfo processInfo : manager.getRunningAppProcesses()) {
                if (processInfo.pid != currentPid) continue;
                if (processInfo.processName.equalsIgnoreCase(adjustConfig.processName)) break;
                AdjustFactory.getLogger().info("Skipping initialization in background process (%s)", processInfo.processName);
                return null;
            }
        }
        ActivityHandler activityHandler = new ActivityHandler(adjustConfig);
        return activityHandler;
    }

    @Override
    public void onResume() {
        this.internalState.background = false;
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.stopBackgroundTimer();
                ActivityHandler.this.startForegroundTimer();
                ActivityHandler.this.logger.verbose("Subsession start", new Object[0]);
                ActivityHandler.this.startInternal();
            }
        });
    }

    @Override
    public void onPause() {
        this.internalState.background = true;
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.stopForegroundTimer();
                ActivityHandler.this.startBackgroundTimer();
                ActivityHandler.this.logger.verbose("Subsession end", new Object[0]);
                ActivityHandler.this.endInternal();
            }
        });
    }

    @Override
    public void trackEvent(final AdjustEvent event) {
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ActivityHandler.this.activityState == null) {
                    ActivityHandler.this.logger.warn("Event triggered before first application launch.\nThis will trigger the SDK start and an install without user interaction.\nPlease check https://github.com/adjust/android_sdk#can-i-trigger-an-event-at-application-launch for more information.", new Object[0]);
                    ActivityHandler.this.startInternal();
                }
                ActivityHandler.this.trackEventInternal(event);
            }
        });
    }

    @Override
    public void finishedTrackingActivity(ResponseData responseData) {
        if (responseData instanceof SessionResponseData) {
            this.attributionHandler.checkSessionResponse((SessionResponseData)responseData);
            return;
        }
        if (responseData instanceof EventResponseData) {
            this.launchEventResponseTasks((EventResponseData)responseData);
            return;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.hasChangedState(this.isEnabled(), enabled, "Adjust already enabled", "Adjust already disabled")) {
            return;
        }
        this.internalState.enabled = enabled;
        if (this.activityState == null) {
            this.updateStatus(!enabled, "Package handler and attribution handler will start as paused due to the SDK being disabled", "Package and attribution handler will still start as paused due to the SDK being offline", "Package handler and attribution handler will start as active due to the SDK being enabled");
            return;
        }
        this.activityState.enabled = enabled;
        this.writeActivityState();
        this.updateStatus(!enabled, "Pausing package handler and attribution handler due to SDK being disabled", "Package and attribution handler remain paused due to SDK being offline", "Resuming package handler and attribution handler due to SDK being enabled");
    }

    private void updateStatus(boolean pausingState, String pausingMessage, String remainsPausedMessage, String unPausingMessage) {
        if (pausingState) {
            this.logger.info(pausingMessage, new Object[0]);
            this.updateHandlersStatusAndSend();
            return;
        }
        if (this.paused()) {
            this.logger.info(remainsPausedMessage, new Object[0]);
        } else {
            this.logger.info(unPausingMessage, new Object[0]);
            this.updateHandlersStatusAndSend();
        }
    }

    private boolean hasChangedState(boolean previousState, boolean newState, String trueMessage, String falseMessage) {
        if (previousState != newState) {
            return true;
        }
        if (previousState) {
            this.logger.debug(trueMessage, new Object[0]);
        } else {
            this.logger.debug(falseMessage, new Object[0]);
        }
        return false;
    }

    @Override
    public void setOfflineMode(boolean offline) {
        if (!this.hasChangedState(this.internalState.isOffline(), offline, "Adjust already in offline mode", "Adjust already in online mode")) {
            return;
        }
        this.internalState.offline = offline;
        if (this.activityState == null) {
            this.updateStatus(offline, "Package handler and attribution handler will start paused due to SDK being offline", "Package and attribution handler will still start as paused due to SDK being disabled", "Package handler and attribution handler will start as active due to SDK being online");
            return;
        }
        this.updateStatus(offline, "Pausing package and attribution handler to put SDK offline mode", "Package and attribution handler remain paused due to SDK being disabled", "Resuming package handler and attribution handler to put SDK in online mode");
    }

    @Override
    public boolean isEnabled() {
        if (this.activityState != null) {
            return this.activityState.enabled;
        }
        return this.internalState.isEnabled();
    }

    @Override
    public void readOpenUrl(final Uri url, final long clickTime) {
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.readOpenUrlInternal(url, clickTime);
            }
        });
    }

    @Override
    public boolean updateAttribution(AdjustAttribution attribution) {
        if (attribution == null) {
            return false;
        }
        if (attribution.equals(this.attribution)) {
            return false;
        }
        this.saveAttribution(attribution);
        return true;
    }

    private void saveAttribution(AdjustAttribution attribution) {
        this.attribution = attribution;
        this.writeAttribution();
    }

    @Override
    public void setAskingAttribution(boolean askingAttribution) {
        this.activityState.askingAttribution = askingAttribution;
        this.writeActivityState();
    }

    @Override
    public void sendReferrer(final String referrer, final long clickTime) {
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.sendReferrerInternal(referrer, clickTime);
            }
        });
    }

    @Override
    public void launchEventResponseTasks(final EventResponseData eventResponseData) {
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.launchEventResponseTasksInternal(eventResponseData);
            }
        });
    }

    @Override
    public void launchSessionResponseTasks(final SessionResponseData sessionResponseData) {
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.launchSessionResponseTasksInternal(sessionResponseData);
            }
        });
    }

    @Override
    public void launchAttributionResponseTasks(final AttributionResponseData attributionResponseData) {
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.launchAttributionResponseTasksInternal(attributionResponseData);
            }
        });
    }

    public ActivityPackage getAttributionPackage() {
        long now = System.currentTimeMillis();
        PackageBuilder attributionBuilder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, now);
        return attributionBuilder.buildAttributionPackage();
    }

    public InternalState getInternalState() {
        return this.internalState;
    }

    private void updateHandlersStatusAndSend() {
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.updateHandlersStatusAndSendInternal();
            }
        });
    }

    private void foregroundTimerFired() {
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.foregroundTimerFiredInternal();
            }
        });
    }

    private void backgroundTimerFired() {
        this.internalHandler.post(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.backgroundTimerFiredInternal();
            }
        });
    }

    private void initInternal() {
        String playAdId;
        SESSION_INTERVAL = AdjustFactory.getSessionInterval();
        SUBSESSION_INTERVAL = AdjustFactory.getSubsessionInterval();
        this.deviceInfo = new DeviceInfo(this.adjustConfig.context, this.adjustConfig.sdkPrefix);
        if (this.adjustConfig.eventBufferingEnabled) {
            this.logger.info("Event buffering is enabled", new Object[0]);
        }
        if ((playAdId = Util.getPlayAdId(this.adjustConfig.context)) == null) {
            this.logger.warn("Unable to get Google Play Services Advertising ID at start time", new Object[0]);
            if (this.deviceInfo.macSha1 == null && this.deviceInfo.macShortMd5 == null && this.deviceInfo.androidId == null) {
                this.logger.error("Unable to get any device id's. Please check if Proguard is correctly set with Adjust SDK", new Object[0]);
            }
        } else {
            this.logger.info("Google Play Services Advertising ID read correctly at start time", new Object[0]);
        }
        if (this.adjustConfig.defaultTracker != null) {
            this.logger.info("Default tracker: '%s'", this.adjustConfig.defaultTracker);
        }
        if (this.adjustConfig.referrer != null) {
            this.sendReferrer(this.adjustConfig.referrer, this.adjustConfig.referrerClickTime);
        }
        this.packageHandler = AdjustFactory.getPackageHandler(this, this.adjustConfig.context, this.toSend());
        ActivityPackage attributionPackage = this.getAttributionPackage();
        this.attributionHandler = AdjustFactory.getAttributionHandler(this, attributionPackage, this.toSend(), this.adjustConfig.hasAttributionChangedListener());
        this.sdkClickHandler = AdjustFactory.getSdkClickHandler(this.toSend());
    }

    private void startInternal() {
        if (this.activityState != null && !this.activityState.enabled) {
            return;
        }
        this.updateHandlersStatusAndSendInternal();
        this.processSession();
        this.checkAttributionState();
    }

    private void processSession() {
        long now = System.currentTimeMillis();
        if (this.activityState == null) {
            this.activityState = new ActivityState();
            this.activityState.sessionCount = 1;
            this.transferSessionPackage(now);
            this.activityState.resetSessionAttributes(now);
            this.activityState.enabled = this.internalState.isEnabled();
            this.writeActivityState();
            return;
        }
        long lastInterval = now - this.activityState.lastActivity;
        if (lastInterval < 0L) {
            this.logger.error(TIME_TRAVEL, new Object[0]);
            this.activityState.lastActivity = now;
            this.writeActivityState();
            return;
        }
        if (lastInterval > SESSION_INTERVAL) {
            ++this.activityState.sessionCount;
            this.activityState.lastInterval = lastInterval;
            this.transferSessionPackage(now);
            this.activityState.resetSessionAttributes(now);
            this.writeActivityState();
            return;
        }
        if (lastInterval > SUBSESSION_INTERVAL) {
            ++this.activityState.subsessionCount;
            this.activityState.sessionLength += lastInterval;
            this.activityState.lastActivity = now;
            this.logger.verbose("Started subsession %d of session %d", this.activityState.subsessionCount, this.activityState.sessionCount);
            this.writeActivityState();
            return;
        }
        this.logger.verbose("Time span since last activity too short for a new subsession", new Object[0]);
    }

    private void checkAttributionState() {
        if (!this.checkActivityState(this.activityState)) {
            return;
        }
        if (this.activityState.subsessionCount <= 1) {
            return;
        }
        if (this.attribution != null && !this.activityState.askingAttribution) {
            return;
        }
        this.attributionHandler.getAttribution();
    }

    private void endInternal() {
        if (!this.toSend()) {
            this.pauseSending();
        }
        if (this.updateActivityState(System.currentTimeMillis())) {
            this.writeActivityState();
        }
    }

    private void trackEventInternal(AdjustEvent event) {
        if (!this.checkActivityState(this.activityState)) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.checkEvent(event)) {
            return;
        }
        long now = System.currentTimeMillis();
        ++this.activityState.eventCount;
        this.updateActivityState(now);
        PackageBuilder eventBuilder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, now);
        ActivityPackage eventPackage = eventBuilder.buildEventPackage(event);
        this.packageHandler.addPackage(eventPackage);
        if (this.adjustConfig.eventBufferingEnabled) {
            this.logger.info("Buffered event %s", eventPackage.getSuffix());
        } else {
            this.packageHandler.sendFirstPackage();
        }
        if (this.adjustConfig.sendInBackground && this.internalState.isBackground()) {
            this.startBackgroundTimer();
        }
        this.writeActivityState();
    }

    private void launchEventResponseTasksInternal(final EventResponseData eventResponseData) {
        Handler handler = new Handler(this.adjustConfig.context.getMainLooper());
        if (eventResponseData.success && this.adjustConfig.onEventTrackingSucceededListener != null) {
            this.logger.debug("Launching success event tracking listener", new Object[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingSucceededListener.onFinishedEventTrackingSucceeded(eventResponseData.getSuccessResponseData());
                }
            };
            handler.post(runnable);
            return;
        }
        if (!eventResponseData.success && this.adjustConfig.onEventTrackingFailedListener != null) {
            this.logger.debug("Launching failed event tracking listener", new Object[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingFailedListener.onFinishedEventTrackingFailed(eventResponseData.getFailureResponseData());
                }
            };
            handler.post(runnable);
            return;
        }
    }

    private void launchSessionResponseTasksInternal(SessionResponseData sessionResponseData) {
        Handler handler = new Handler(this.adjustConfig.context.getMainLooper());
        boolean attributionUpdated = this.updateAttribution(sessionResponseData.attribution);
        if (attributionUpdated) {
            this.launchAttributionListener(handler);
        }
        this.launchSessionResponseListener(sessionResponseData, handler);
        this.prepareDeeplink(sessionResponseData, handler);
    }

    private void launchSessionResponseListener(final SessionResponseData sessionResponseData, Handler handler) {
        if (sessionResponseData.success && this.adjustConfig.onSessionTrackingSucceededListener != null) {
            this.logger.debug("Launching success session tracking listener", new Object[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingSucceededListener.onFinishedSessionTrackingSucceeded(sessionResponseData.getSuccessResponseData());
                }
            };
            handler.post(runnable);
            return;
        }
        if (!sessionResponseData.success && this.adjustConfig.onSessionTrackingFailedListener != null) {
            this.logger.debug("Launching failed session tracking listener", new Object[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingFailedListener.onFinishedSessionTrackingFailed(sessionResponseData.getFailureResponseData());
                }
            };
            handler.post(runnable);
            return;
        }
    }

    private void launchAttributionResponseTasksInternal(AttributionResponseData responseData) {
        Handler handler = new Handler(this.adjustConfig.context.getMainLooper());
        boolean attributionUpdated = this.updateAttribution(responseData.attribution);
        if (attributionUpdated) {
            this.launchAttributionListener(handler);
        }
    }

    private void launchAttributionListener(Handler handler) {
        if (this.adjustConfig.onAttributionChangedListener == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ((ActivityHandler)ActivityHandler.this).adjustConfig.onAttributionChangedListener.onAttributionChanged(ActivityHandler.this.attribution);
            }
        };
        handler.post(runnable);
    }

    private void prepareDeeplink(ResponseData responseData, Handler handler) {
        if (responseData.jsonResponse == null) {
            return;
        }
        final String deeplink = responseData.jsonResponse.optString("deeplink", null);
        if (deeplink == null) {
            return;
        }
        final Uri location = Uri.parse((String)deeplink);
        final Intent deeplinkIntent = this.createDeeplinkIntent(location);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean toLaunchDeeplink = true;
                if (((ActivityHandler)ActivityHandler.this).adjustConfig.onDeeplinkResponseListener != null) {
                    toLaunchDeeplink = ((ActivityHandler)ActivityHandler.this).adjustConfig.onDeeplinkResponseListener.launchReceivedDeeplink(location);
                }
                if (toLaunchDeeplink) {
                    ActivityHandler.this.launchDeeplinkMain(deeplinkIntent, deeplink);
                }
            }
        };
        handler.post(runnable);
    }

    private Intent createDeeplinkIntent(Uri location) {
        Intent mapIntent = this.adjustConfig.deepLinkComponent == null ? new Intent("android.intent.action.VIEW", location) : new Intent("android.intent.action.VIEW", location, this.adjustConfig.context, this.adjustConfig.deepLinkComponent);
        mapIntent.setFlags(0x10000000);
        mapIntent.setPackage(this.adjustConfig.context.getPackageName());
        return mapIntent;
    }

    private void launchDeeplinkMain(Intent deeplinkIntent, String deeplink) {
        boolean isIntentSafe;
        PackageManager packageManager = this.adjustConfig.context.getPackageManager();
        List activities = packageManager.queryIntentActivities(deeplinkIntent, 0);
        boolean bl = isIntentSafe = activities.size() > 0;
        if (!isIntentSafe) {
            this.logger.error("Unable to open deep link (%s)", deeplink);
            return;
        }
        this.logger.info("Open deep link (%s)", deeplink);
        this.adjustConfig.context.startActivity(deeplinkIntent);
    }

    private void sendReferrerInternal(String referrer, long clickTime) {
        if (referrer == null || referrer.length() == 0) {
            return;
        }
        PackageBuilder clickPackageBuilder = this.queryStringClickPackageBuilder(referrer);
        if (clickPackageBuilder == null) {
            return;
        }
        clickPackageBuilder.referrer = referrer;
        ActivityPackage clickPackage = clickPackageBuilder.buildClickPackage("reftag", clickTime);
        this.sdkClickHandler.sendSdkClick(clickPackage);
    }

    private void readOpenUrlInternal(Uri url, long clickTime) {
        PackageBuilder clickPackageBuilder;
        if (url == null) {
            return;
        }
        String queryString = url.getQuery();
        if (queryString == null && url.toString().length() > 0) {
            queryString = "";
        }
        if ((clickPackageBuilder = this.queryStringClickPackageBuilder(queryString)) == null) {
            return;
        }
        clickPackageBuilder.deeplink = url.toString();
        ActivityPackage clickPackage = clickPackageBuilder.buildClickPackage("deeplink", clickTime);
        this.sdkClickHandler.sendSdkClick(clickPackage);
    }

    private PackageBuilder queryStringClickPackageBuilder(String queryString) {
        String[] queryPairs;
        if (queryString == null) {
            return null;
        }
        LinkedHashMap<String, String> queryStringParameters = new LinkedHashMap<String, String>();
        AdjustAttribution queryStringAttribution = new AdjustAttribution();
        this.logger.verbose("Reading query string (%s)", queryString);
        for (String pair : queryPairs = queryString.split("&")) {
            this.readQueryString(pair, queryStringParameters, queryStringAttribution);
        }
        String reftag = (String)queryStringParameters.remove("reftag");
        long now = System.currentTimeMillis();
        PackageBuilder builder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, now);
        builder.extraParameters = queryStringParameters;
        builder.attribution = queryStringAttribution;
        builder.reftag = reftag;
        return builder;
    }

    private boolean readQueryString(String queryString, Map<String, String> extraParameters, AdjustAttribution queryStringAttribution) {
        String[] pairComponents = queryString.split("=");
        if (pairComponents.length != 2) {
            return false;
        }
        String key = pairComponents[0];
        if (!key.startsWith(ADJUST_PREFIX)) {
            return false;
        }
        String value = pairComponents[1];
        if (value.length() == 0) {
            return false;
        }
        String keyWOutPrefix = key.substring(ADJUST_PREFIX.length());
        if (keyWOutPrefix.length() == 0) {
            return false;
        }
        if (!this.trySetAttribution(queryStringAttribution, keyWOutPrefix, value)) {
            extraParameters.put(keyWOutPrefix, value);
        }
        return true;
    }

    private boolean trySetAttribution(AdjustAttribution queryStringAttribution, String key, String value) {
        if (key.equals("tracker")) {
            queryStringAttribution.trackerName = value;
            return true;
        }
        if (key.equals("campaign")) {
            queryStringAttribution.campaign = value;
            return true;
        }
        if (key.equals("adgroup")) {
            queryStringAttribution.adgroup = value;
            return true;
        }
        if (key.equals("creative")) {
            queryStringAttribution.creative = value;
            return true;
        }
        return false;
    }

    private void updateHandlersStatusAndSendInternal() {
        if (!this.toSend()) {
            this.pauseSending();
            return;
        }
        this.resumeSending();
        if (!this.adjustConfig.eventBufferingEnabled) {
            this.packageHandler.sendFirstPackage();
        }
    }

    private void pauseSending() {
        this.attributionHandler.pauseSending();
        this.packageHandler.pauseSending();
        this.sdkClickHandler.pauseSending();
    }

    private void resumeSending() {
        this.attributionHandler.resumeSending();
        this.packageHandler.resumeSending();
        this.sdkClickHandler.resumeSending();
    }

    private boolean updateActivityState(long now) {
        if (!this.checkActivityState(this.activityState)) {
            return false;
        }
        long lastInterval = now - this.activityState.lastActivity;
        if (lastInterval > SESSION_INTERVAL) {
            return false;
        }
        this.activityState.lastActivity = now;
        if (lastInterval < 0L) {
            this.logger.error(TIME_TRAVEL, new Object[0]);
        } else {
            this.activityState.sessionLength += lastInterval;
            this.activityState.timeSpent += lastInterval;
        }
        return true;
    }

    public static boolean deleteActivityState(Context context) {
        return context.deleteFile("AdjustIoActivityState");
    }

    public static boolean deleteAttribution(Context context) {
        return context.deleteFile("AdjustAttribution");
    }

    private void transferSessionPackage(long now) {
        PackageBuilder builder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, now);
        ActivityPackage sessionPackage = builder.buildSessionPackage();
        this.packageHandler.addPackage(sessionPackage);
        this.packageHandler.sendFirstPackage();
    }

    private void startForegroundTimer() {
        if (this.paused()) {
            return;
        }
        this.foregroundTimer.start();
    }

    private void stopForegroundTimer() {
        this.foregroundTimer.suspend();
    }

    private void foregroundTimerFiredInternal() {
        if (this.paused()) {
            this.stopForegroundTimer();
            return;
        }
        this.packageHandler.sendFirstPackage();
        if (this.updateActivityState(System.currentTimeMillis())) {
            this.writeActivityState();
        }
    }

    private void startBackgroundTimer() {
        if (!this.toSend()) {
            return;
        }
        if (this.backgroundTimer.getFireIn() > 0L) {
            return;
        }
        this.backgroundTimer.startIn(BACKGROUND_TIMER_INTERVAL);
    }

    private void stopBackgroundTimer() {
        this.backgroundTimer.cancel();
    }

    private void backgroundTimerFiredInternal() {
        this.packageHandler.sendFirstPackage();
    }

    private void readActivityState(Context context) {
        try {
            this.activityState = Util.readObject(context, "AdjustIoActivityState", ACTIVITY_STATE_NAME, ActivityState.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to read %s file (%s)", ACTIVITY_STATE_NAME, e.getMessage());
            this.activityState = null;
        }
    }

    private void readAttribution(Context context) {
        try {
            this.attribution = Util.readObject(context, "AdjustAttribution", ATTRIBUTION_NAME, AdjustAttribution.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to read %s file (%s)", ATTRIBUTION_NAME, e.getMessage());
            this.attribution = null;
        }
    }

    private synchronized void writeActivityState() {
        Util.writeObject(this.activityState, this.adjustConfig.context, "AdjustIoActivityState", ACTIVITY_STATE_NAME);
    }

    private void writeAttribution() {
        Util.writeObject(this.attribution, this.adjustConfig.context, "AdjustAttribution", ATTRIBUTION_NAME);
    }

    private boolean checkEvent(AdjustEvent event) {
        if (event == null) {
            this.logger.error("Event missing", new Object[0]);
            return false;
        }
        if (!event.isValid()) {
            this.logger.error("Event not initialized correctly", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkActivityState(ActivityState activityState) {
        if (activityState == null) {
            this.logger.error("Missing activity state", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean paused() {
        return this.internalState.isOffline() || !this.isEnabled();
    }

    private boolean toSend() {
        if (this.paused()) {
            return false;
        }
        if (this.adjustConfig.sendInBackground) {
            return true;
        }
        return this.internalState.isForeground();
    }

    public class InternalState {
        boolean enabled;
        boolean offline;
        boolean background;

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDisabled() {
            return !this.enabled;
        }

        public boolean isOffline() {
            return this.offline;
        }

        public boolean isOnline() {
            return !this.offline;
        }

        public boolean isBackground() {
            return this.background;
        }

        public boolean isForeground() {
            return !this.background;
        }
    }
}

