/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IRequestHandler;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.Util;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class PackageHandler
extends HandlerThread
implements IPackageHandler {
    private static final String PACKAGE_QUEUE_FILENAME = "AdjustIoPackageQueue";
    private static final String PACKAGE_QUEUE_NAME = "Package queue";
    private final InternalHandler internalHandler;
    private IRequestHandler requestHandler;
    private IActivityHandler activityHandler;
    private List<ActivityPackage> packageQueue;
    private AtomicBoolean isSending;
    private boolean paused;
    private Context context;
    private ILogger logger;

    public PackageHandler(IActivityHandler activityHandler, Context context, boolean startPaused) {
        super("Adjust", 1);
        this.setDaemon(true);
        this.start();
        this.internalHandler = new InternalHandler(this.getLooper(), this);
        this.logger = AdjustFactory.getLogger();
        this.init(activityHandler, context, startPaused);
        Message message = Message.obtain();
        message.arg1 = 1;
        this.internalHandler.sendMessage(message);
    }

    @Override
    public void init(IActivityHandler activityHandler, Context context, boolean startPaused) {
        this.activityHandler = activityHandler;
        this.context = context;
        this.paused = startPaused;
    }

    @Override
    public void addPackage(ActivityPackage pack) {
        Message message = Message.obtain();
        message.arg1 = 2;
        message.obj = pack;
        this.internalHandler.sendMessage(message);
    }

    @Override
    public void sendFirstPackage() {
        Message message = Message.obtain();
        message.arg1 = 4;
        this.internalHandler.sendMessage(message);
    }

    @Override
    public void sendNextPackage(ResponseData responseData) {
        Message message = Message.obtain();
        message.arg1 = 3;
        this.internalHandler.sendMessage(message);
        this.activityHandler.finishedTrackingActivity(responseData);
    }

    @Override
    public void closeFirstPackage(ResponseData responseData) {
        this.isSending.set(false);
        responseData.willRetry = true;
        this.activityHandler.finishedTrackingActivity(responseData);
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    private void initInternal() {
        this.requestHandler = AdjustFactory.getRequestHandler(this);
        this.isSending = new AtomicBoolean();
        this.readPackageQueue();
    }

    private void addInternal(ActivityPackage newPackage) {
        if (newPackage.getActivityKind().equals((Object)ActivityKind.CLICK) && !this.packageQueue.isEmpty()) {
            this.packageQueue.add(1, newPackage);
        } else {
            this.packageQueue.add(newPackage);
        }
        this.logger.debug("Added package %d (%s)", this.packageQueue.size(), newPackage);
        this.logger.verbose("%s", newPackage.getExtendedString());
        this.writePackageQueue();
    }

    private void sendFirstInternal() {
        if (this.packageQueue.isEmpty()) {
            return;
        }
        if (this.paused) {
            this.logger.debug("Package handler is paused", new Object[0]);
            return;
        }
        if (this.isSending.getAndSet(true)) {
            this.logger.verbose("Package handler is already sending", new Object[0]);
            return;
        }
        ActivityPackage firstPackage = this.packageQueue.get(0);
        this.requestHandler.sendPackage(firstPackage);
    }

    private void sendNextInternal() {
        this.packageQueue.remove(0);
        this.writePackageQueue();
        this.isSending.set(false);
        this.sendFirstInternal();
    }

    private void readPackageQueue() {
        try {
            this.packageQueue = Util.readObject(this.context, PACKAGE_QUEUE_FILENAME, PACKAGE_QUEUE_NAME, List.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to read %s file (%s)", PACKAGE_QUEUE_NAME, e.getMessage());
            this.packageQueue = null;
        }
        if (this.packageQueue != null) {
            this.logger.debug("Package handler read %d packages", this.packageQueue.size());
        } else {
            this.packageQueue = new ArrayList<ActivityPackage>();
        }
    }

    private void writePackageQueue() {
        Util.writeObject(this.packageQueue, this.context, PACKAGE_QUEUE_FILENAME, PACKAGE_QUEUE_NAME);
        this.logger.debug("Package handler wrote %d packages", this.packageQueue.size());
    }

    public static Boolean deletePackageQueue(Context context) {
        return context.deleteFile(PACKAGE_QUEUE_FILENAME);
    }

    private static final class InternalHandler
    extends Handler {
        private static final int INIT = 1;
        private static final int ADD = 2;
        private static final int SEND_NEXT = 3;
        private static final int SEND_FIRST = 4;
        private final WeakReference<PackageHandler> packageHandlerReference;

        protected InternalHandler(Looper looper, PackageHandler packageHandler) {
            super(looper);
            this.packageHandlerReference = new WeakReference<PackageHandler>(packageHandler);
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            PackageHandler packageHandler = (PackageHandler)this.packageHandlerReference.get();
            if (packageHandler == null) {
                return;
            }
            switch (message.arg1) {
                case 1: {
                    packageHandler.initInternal();
                    break;
                }
                case 2: {
                    ActivityPackage activityPackage = (ActivityPackage)message.obj;
                    packageHandler.addInternal(activityPackage);
                    break;
                }
                case 4: {
                    packageHandler.sendFirstInternal();
                    break;
                }
                case 3: {
                    packageHandler.sendNextInternal();
                }
            }
        }
    }
}

