/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.LocaleList;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AndroidIdUtil;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.GooglePlayServicesClient;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.OnDeviceIdsRead;
import com.adjust.sdk.ReferrerDetails;
import com.adjust.sdk.Reflection;
import com.adjust.sdk.scheduler.AsyncTaskExecutor;
import com.adjust.sdk.scheduler.SingleThreadFutureScheduler;
import java.io.BufferedOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;

public class Util {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'Z";
    private static final String fieldReadErrorMessage = "Unable to read '%s' field in migration device with message (%s)";
    public static final DecimalFormat SecondsDisplayFormat = Util.newLocalDecimalFormat();
    public static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'Z", Locale.US);
    private static volatile SingleThreadFutureScheduler playAdIdScheduler = null;

    private static ILogger getLogger() {
        return AdjustFactory.getLogger();
    }

    public static String createUuid() {
        return UUID.randomUUID().toString();
    }

    private static DecimalFormat newLocalDecimalFormat() {
        DecimalFormatSymbols decimalFormatSymbols;
        DecimalFormatSymbols decimalFormatSymbols2 = decimalFormatSymbols;
        decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
        return new DecimalFormat("0.0", decimalFormatSymbols2);
    }

    public static String quote(String string) {
        if (string == null) {
            return null;
        }
        if (!Pattern.compile("\\s").matcher(string).find()) {
            return string;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        return Util.formatString("'%s'", objectArray2);
    }

    public static Object getAdvertisingInfoObject(final Context context, long l2) {
        return Util.runSyncInPlayAdIdSchedulerWithTimeout(context, new Callable<Object>(){

            @Override
            public final Object call() {
                try {
                    return Reflection.getAdvertisingInfoObject(context);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }, l2);
    }

    public static String getPlayAdId(final Context context, final Object object, long l2) {
        return Util.runSyncInPlayAdIdSchedulerWithTimeout(context, new Callable<String>(){

            @Override
            public final Object call() {
                return Reflection.getPlayAdId(context, object);
            }
        }, l2);
    }

    public static Boolean isPlayTrackingEnabled(final Context context, final Object object, long l2) {
        return Util.runSyncInPlayAdIdSchedulerWithTimeout(context, new Callable<Boolean>(){

            @Override
            public final Object call() {
                return Reflection.isPlayTrackingEnabled(context, object);
            }
        }, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static <R> R runSyncInPlayAdIdSchedulerWithTimeout(Context object, Callable<R> callable, long l2) {
        if (playAdIdScheduler == null) {
            Class<Util> clazz = Util.class;
            // MONITORENTER : com.adjust.sdk.Util.class
            if (playAdIdScheduler == null) {
                playAdIdScheduler = new SingleThreadFutureScheduler("PlayAdIdLibrary", true);
            }
            // MONITOREXIT : clazz
        }
        try {
            void var2_3;
            void var1_2;
            return (R)playAdIdScheduler.scheduleFutureWithReturn(var1_2, 0L).get((long)var2_3, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (ExecutionException executionException) {}
        return null;
    }

    public static void getGoogleAdId(Context context, OnDeviceIdsRead contextArray) {
        AsyncTaskExecutor<Context, String> asyncTaskExecutor = new AsyncTaskExecutor<Context, String>((OnDeviceIdsRead)contextArray){
            public final /* synthetic */ OnDeviceIdsRead a;
            {
                this.a = onDeviceIdsRead;
            }

            @Override
            public final void onPostExecute(Object object) {
                d d2 = string;
                String string = (String)object;
                object = d2.a;
                if (object != null) {
                    object.onGoogleAdIdRead(string);
                }
            }

            @Override
            public final Object doInBackground(Object[] object) {
                ILogger iLogger = AdjustFactory.getLogger();
                object = Util.getGoogleAdId(((Context[])object)[0]);
                iLogger.debug("GoogleAdId read " + (String)object, new Object[0]);
                return object;
            }
        };
        Context[] contextArray2 = new Context[1];
        contextArray = contextArray2;
        contextArray2[0] = context;
        asyncTaskExecutor.execute(contextArray);
    }

    private static String getGoogleAdId(Context context) {
        Object object;
        String string;
        block4: {
            string = null;
            try {
                object = GooglePlayServicesClient.getGooglePlayServicesInfo(context, 11000L);
                if (object == null) break block4;
            }
            catch (Exception exception) {}
            string = ((GooglePlayServicesClient.GooglePlayServicesInfo)object).getGpsAdid();
        }
        if (string == null && (object = Util.getAdvertisingInfoObject(context, 11000L)) != null) {
            string = Util.getPlayAdId(context, object, 1000L);
        }
        return string;
    }

    public static String getAndroidId(Context context) {
        return AndroidIdUtil.getAndroidId(context);
    }

    /*
     * Exception decompiling
     */
    public static <T> T readObject(Context var0, String var1_3, String var2_4, Class<T> var3_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public static <T> void writeObject(T t2, Context objectArray, String objectArray2, String string) {
        block13: {
            ObjectOutputStream objectOutputStream;
            BufferedOutputStream bufferedOutputStream;
            Context context = objectArray;
            objectArray = null;
            objectArray = context.openFileOutput((String)objectArray2, 0);
            objectArray2 = bufferedOutputStream;
            bufferedOutputStream = new BufferedOutputStream((OutputStream)objectArray);
            objectArray = objectOutputStream;
            T t3 = t2;
            objectArray((OutputStream)objectArray2);
            try {
                objectOutputStream.writeObject(t3);
                Util.getLogger().debug("Wrote %s: %s", string, t2);
                break block13;
            }
            catch (NotSerializableException notSerializableException) {
                Util.getLogger().error("Failed to serialize %s", string);
                break block13;
            }
            catch (Exception exception) {
                objectArray = objectArray2;
            }
            {
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Object[] objectArray3 = new Object[2];
            objectArray2 = objectArray3;
            objectArray3[0] = string;
            objectArray3[1] = t2;
            Util.getLogger().error("Failed to open %s for writing (%s)", objectArray2);
        }
        if (objectArray != null) {
            try {
                objectArray.close();
            }
            catch (Exception exception) {
                Object[] objectArray4 = new Object[2];
                objectArray = objectArray4;
                objectArray4[0] = string;
                objectArray4[1] = exception;
                Util.getLogger().error("Failed to close %s file for writing (%s)", objectArray);
            }
        }
    }

    public static boolean checkPermission(Context context, String string) {
        try {
            return context.checkCallingOrSelfPermission(string) == 0;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = string;
            objectArray[1] = exception.getMessage();
            Util.getLogger().debug("Unable to check permission '%s' with message (%s)", objectArray2);
            return false;
        }
    }

    public static String readStringField(ObjectInputStream.GetField getField, String string, String string2) {
        return Util.readObjectField(getField, string, string2);
    }

    public static <T> T readObjectField(ObjectInputStream.GetField getField, String string, T object) {
        try {
            return (T)getField.get(string, object);
        }
        catch (Exception exception) {
            T t2 = object;
            Object[] objectArray = new Object[2];
            object = objectArray;
            object[0] = string;
            objectArray[1] = exception.getMessage();
            Util.getLogger().debug(fieldReadErrorMessage, object);
            return t2;
        }
    }

    public static boolean readBooleanField(ObjectInputStream.GetField getField, String string, boolean bl) {
        try {
            return getField.get(string, bl);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = string;
            objectArray[1] = exception.getMessage();
            Util.getLogger().debug(fieldReadErrorMessage, objectArray2);
            return bl;
        }
    }

    public static int readIntField(ObjectInputStream.GetField getField, String string, int n2) {
        try {
            return getField.get(string, n2);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = string;
            objectArray[1] = exception.getMessage();
            Util.getLogger().debug(fieldReadErrorMessage, objectArray2);
            return n2;
        }
    }

    public static long readLongField(ObjectInputStream.GetField getField, String string, long l2) {
        try {
            return getField.get(string, l2);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = string;
            objectArray[1] = exception.getMessage();
            Util.getLogger().debug(fieldReadErrorMessage, objectArray2);
            return l2;
        }
    }

    public static boolean equalObject(Object object, Object object2) {
        if (object != null && object2 != null) {
            return object.equals(object2);
        }
        return object == null && object2 == null;
    }

    public static boolean equalsDouble(Double d2, Double d3) {
        if (d2 != null && d3 != null) {
            return Double.doubleToLongBits(d2) == Double.doubleToLongBits(d3);
        }
        return d2 == null && d3 == null;
    }

    public static boolean equalString(String string, String string2) {
        return Util.equalObject(string, string2);
    }

    public static boolean equalEnum(Enum enum_, Enum enum_2) {
        return Util.equalObject(enum_, enum_2);
    }

    public static boolean equalLong(Long l2, Long l3) {
        return Util.equalObject(l2, l3);
    }

    public static boolean equalInt(Integer n2, Integer n3) {
        return Util.equalObject(n2, n3);
    }

    public static boolean equalBoolean(Boolean bl, Boolean bl2) {
        return Util.equalObject(bl, bl2);
    }

    public static int hashBoolean(Boolean bl, int n2) {
        if (bl == null) {
            return n2 * 37;
        }
        int n3 = n2 * 37;
        return bl.hashCode() + n3;
    }

    public static int hashLong(Long l2, int n2) {
        if (l2 == null) {
            return n2 * 37;
        }
        int n3 = n2 * 37;
        return l2.hashCode() + n3;
    }

    public static int hashDouble(Double d2, int n2) {
        if (d2 == null) {
            return n2 * 37;
        }
        int n3 = n2 * 37;
        return d2.hashCode() + n3;
    }

    public static int hashString(String string, int n2) {
        if (string == null) {
            return n2 * 37;
        }
        int n3 = n2 * 37;
        return string.hashCode() + n3;
    }

    public static int hashEnum(Enum enum_, int n2) {
        if (enum_ == null) {
            return n2 * 37;
        }
        int n3 = n2 * 37;
        return enum_.hashCode() + n3;
    }

    public static int hashObject(Object object, int n2) {
        if (object == null) {
            return n2 * 37;
        }
        int n3 = n2 * 37;
        return object.hashCode() + n3;
    }

    public static String sha256(String string) {
        return Util.hash(string, "SHA-256");
    }

    public static String hash(String string, String object) {
        String string2 = object;
        String string3 = string;
        string = null;
        try {
            object = string3.getBytes("UTF-8");
        }
        catch (Exception exception) {}
        MessageDigest messageDigest = MessageDigest.getInstance(string2);
        Object object2 = object;
        int n2 = 0;
        messageDigest.update((byte[])object2, n2, ((Object)object2).length);
        string = Util.convertToHex(messageDigest.digest());
        return string;
    }

    public static String convertToHex(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = bigInteger;
        bigInteger = new BigInteger(1, byArray);
        return Util.formatString("%0" + (byArray.length << 1) + "x", bigInteger2);
    }

    public static String[] getSupportedAbis() {
        if (Build.VERSION.SDK_INT >= 21) {
            return Build.SUPPORTED_ABIS;
        }
        return null;
    }

    public static String getCpuAbi() {
        if (Build.VERSION.SDK_INT < 21) {
            return Build.CPU_ABI;
        }
        return null;
    }

    public static String getReasonString(String string, Throwable objectArray) {
        if (objectArray != null) {
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = string;
            objectArray2[1] = objectArray;
            return Util.formatString("%s: %s", objectArray3);
        }
        Object[] objectArray4 = new Object[1];
        objectArray = objectArray4;
        objectArray4[0] = string;
        return Util.formatString("%s", objectArray);
    }

    public static long getWaitingTime(int n2, BackoffStrategy backoffStrategy) {
        int n3 = backoffStrategy.minRetries;
        if (n2 < n3) {
            return 0L;
        }
        double d2 = n2 - n3;
        double d3 = Util.randomInRange(backoffStrategy.minRange, backoffStrategy.maxRange);
        return (long)((double)Math.min((long)Math.pow(2.0, d2) * backoffStrategy.milliSecondMultiplier, backoffStrategy.maxWait) * d3);
    }

    private static double randomInRange(double d2, double d3) {
        Random random;
        Random random2 = random;
        random = new Random();
        double d4 = d3 - d2;
        return random2.nextDouble() * d4 + d2;
    }

    public static boolean isValidParameter(String objectArray, String string, String string2) {
        if (objectArray == null) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray2[0] = string2;
            objectArray2[1] = string;
            Util.getLogger().error("%s parameter %s is missing", objectArray);
            return false;
        }
        if (objectArray.equals("")) {
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray3[0] = string2;
            objectArray3[1] = string;
            Util.getLogger().error("%s parameter %s is empty", objectArray);
            return false;
        }
        return true;
    }

    public static boolean isAdjustUninstallDetectionPayload(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        return map.size() == 1 && Objects.equals(map.get("adjust_purpose"), "uninstall detection");
    }

    public static Map<String, String> mergeParameters(Map<String, String> object, Map<String, String> hashMap, String string) {
        HashMap<String, String> hashMap2;
        if (object == null) {
            return hashMap;
        }
        if (hashMap == null) {
            return object;
        }
        HashMap<String, String> hashMap3 = hashMap;
        hashMap = hashMap2;
        hashMap2 = new HashMap<String, String>((Map<String, String>)object);
        object = Util.getLogger();
        for (Map.Entry entry : hashMap3.entrySet()) {
            Object[] objectArray;
            String string2 = hashMap.put((String)entry.getKey(), (String)entry.getValue());
            if (string2 == null) continue;
            Object[] objectArray2 = new Object[4];
            Object[] objectArray3 = objectArray = objectArray2;
            objectArray3[0] = entry.getKey();
            objectArray3[1] = string2;
            objectArray[2] = string;
            objectArray2[3] = entry.getValue();
            object.warn("Key %s with value %s from %s parameter was replaced by value %s", objectArray);
        }
        return hashMap;
    }

    public static Locale getLocale(Configuration configuration) {
        LocaleList localeList;
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 24 && (localeList = configuration.getLocales()) != null && !localeList.isEmpty()) {
            return localeList.get(0);
        }
        if (n2 < 24) {
            return configuration.locale;
        }
        return null;
    }

    public static String formatString(String string, Object ... objectArray) {
        return String.format(Locale.US, string, objectArray);
    }

    public static boolean hasRootCause(Exception object) {
        StringWriter stringWriter;
        Exception exception = object;
        object = stringWriter;
        stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter((Writer)object));
        return ((StringWriter)object).toString().contains("Caused by:");
    }

    public static String getRootCause(Exception exception) {
        StringWriter stringWriter;
        if (!Util.hasRootCause(exception)) {
            return null;
        }
        StringWriter stringWriter2 = stringWriter;
        stringWriter2();
        exception.printStackTrace(new PrintWriter(stringWriter2));
        String string = stringWriter.toString();
        int n2 = string.indexOf("Caused by:");
        return string.substring(n2, string.indexOf("\n", n2));
    }

    private static String getSdkPrefix(String stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (!stringArray.contains("@")) {
            return null;
        }
        if ((stringArray = stringArray.split("@")) == null) {
            return null;
        }
        if (stringArray.length != 2) {
            return null;
        }
        return stringArray[0];
    }

    public static String getSdkPrefixPlatform(String stringArray) {
        if ((stringArray = Util.getSdkPrefix((String)stringArray)) == null) {
            return null;
        }
        if ((stringArray = stringArray.split("\\d+", 2)) == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    public static boolean isUrlFilteredOut(Uri object) {
        if (object == null) {
            return true;
        }
        if ((object = object.toString()) != null && ((String)object).length() != 0) {
            return ((String)object).matches("^(fb|vk)[0-9]{5,}[^:]*://authorize.*access_token=.*");
        }
        return true;
    }

    public static String getSdkVersion() {
        return "android4.38.1";
    }

    public static boolean resolveContentProvider(Context context, String string) {
        try {
            return context.getPackageManager().resolveContentProvider(string, 0) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isEqualReferrerDetails(ReferrerDetails referrerDetails, String string, ActivityState activityState) {
        if (string.equals("google")) {
            return Util.isEqualGoogleReferrerDetails(referrerDetails, activityState);
        }
        if (string.equals("huawei_ads")) {
            return Util.isEqualHuaweiReferrerAdsDetails(referrerDetails, activityState);
        }
        if (string.equals("huawei_app_gallery")) {
            return Util.isEqualHuaweiReferrerAppGalleryDetails(referrerDetails, activityState);
        }
        if (string.equals("samsung")) {
            return Util.isEqualSamsungReferrerDetails(referrerDetails, activityState);
        }
        if (string.equals("xiaomi")) {
            return Util.isEqualXiaomiReferrerDetails(referrerDetails, activityState);
        }
        if (string.equals("vivo")) {
            return Util.isEqualVivoReferrerDetails(referrerDetails, activityState);
        }
        if (string.equals("meta")) {
            return Util.isEqualMetaReferrerDetails(referrerDetails, activityState);
        }
        return false;
    }

    public static boolean canReadPlayIds(AdjustConfig adjustConfig) {
        if (adjustConfig.playStoreKidsAppEnabled) {
            return false;
        }
        return !adjustConfig.coppaCompliantEnabled;
    }

    public static boolean canReadNonPlayIds(AdjustConfig adjustConfig) {
        if (adjustConfig.playStoreKidsAppEnabled) {
            return false;
        }
        return !adjustConfig.coppaCompliantEnabled;
    }

    public static boolean isGooglePlayGamesForPC(Context context) {
        return context.getPackageManager().hasSystemFeature("com.google.android.play.feature.HPE_EXPERIENCE");
    }

    private static boolean isEqualGoogleReferrerDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTime && referrerDetails.installBeginTimestampSeconds == activityState.installBegin && referrerDetails.referrerClickTimestampServerSeconds == activityState.clickTimeServer && referrerDetails.installBeginTimestampServerSeconds == activityState.installBeginServer && Util.equalString(referrerDetails.installReferrer, activityState.installReferrer) && Util.equalString(referrerDetails.installVersion, activityState.installVersion) && Util.equalBoolean(referrerDetails.googlePlayInstant, activityState.googlePlayInstant);
    }

    private static boolean isEqualHuaweiReferrerAdsDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTimeHuawei && referrerDetails.installBeginTimestampSeconds == activityState.installBeginHuawei && Util.equalString(referrerDetails.installReferrer, activityState.installReferrerHuawei);
    }

    private static boolean isEqualHuaweiReferrerAppGalleryDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTimeHuawei && referrerDetails.installBeginTimestampSeconds == activityState.installBeginHuawei && Util.equalString(referrerDetails.installReferrer, activityState.installReferrerHuaweiAppGallery);
    }

    private static boolean isEqualSamsungReferrerDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTimeSamsung && referrerDetails.installBeginTimestampSeconds == activityState.installBeginSamsung && Util.equalString(referrerDetails.installReferrer, activityState.installReferrerSamsung);
    }

    private static boolean isEqualXiaomiReferrerDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTimeXiaomi && referrerDetails.installBeginTimestampSeconds == activityState.installBeginXiaomi && referrerDetails.referrerClickTimestampServerSeconds == activityState.clickTimeServerXiaomi && referrerDetails.installBeginTimestampServerSeconds == activityState.installBeginServerXiaomi && Util.equalString(referrerDetails.installReferrer, activityState.installReferrerXiaomi) && Util.equalString(referrerDetails.installVersion, activityState.installVersionXiaomi);
    }

    private static boolean isEqualVivoReferrerDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTimeVivo && referrerDetails.installBeginTimestampSeconds == activityState.installBeginVivo && Util.equalString(referrerDetails.installReferrer, activityState.installReferrerVivo) && Util.equalString(referrerDetails.installVersion, activityState.installVersionVivo);
    }

    private static boolean isEqualMetaReferrerDetails(ReferrerDetails referrerDetails, ActivityState activityState) {
        return referrerDetails.referrerClickTimestampSeconds == activityState.clickTimeMeta && Util.equalString(referrerDetails.installReferrer, activityState.installReferrerMeta) && Util.equalBoolean(referrerDetails.isClick, activityState.isClickMeta);
    }
}

