/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import android.net.UrlQuerySanitizer;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.ReferrerDetails;
import com.adjust.sdk.SessionParameters;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PackageFactory {
    private static final String ADJUST_PREFIX = "adjust_";

    public static ActivityPackage buildReftagSdkClickPackage(String string, long l2, ActivityState object, AdjustConfig adjustConfig, DeviceInfo deviceInfo, SessionParameters sessionParameters) {
        if (string != null && string.length() != 0) {
            Object[] objectArray;
            Object[] objectArray2;
            try {
                objectArray2 = URLDecoder.decode(string, "UTF-8");
            }
            catch (Exception exception) {
                objectArray = "malformed";
                Object[] objectArray3 = new Object[1];
                Object[] objectArray4 = objectArray3;
                objectArray3[0] = exception.getMessage();
                AdjustFactory.getLogger().error("Referrer decoding failed. Message: (%s)", objectArray4);
                objectArray2 = objectArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                objectArray = "malformed";
                Object[] objectArray5 = new Object[1];
                Object[] objectArray6 = objectArray5;
                objectArray5[0] = illegalArgumentException.getMessage();
                AdjustFactory.getLogger().error("Referrer decoding failed due to IllegalArgumentException. Message: (%s)", objectArray6);
                objectArray2 = objectArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                objectArray = "malformed";
                Object[] objectArray7 = new Object[1];
                Object[] objectArray8 = objectArray7;
                objectArray7[0] = unsupportedEncodingException.getMessage();
                AdjustFactory.getLogger().error("Referrer decoding failed due to UnsupportedEncodingException. Message: (%s)", objectArray8);
                objectArray2 = objectArray;
            }
            Object[] objectArray9 = new Object[1];
            objectArray = objectArray9;
            objectArray9[0] = objectArray2;
            AdjustFactory.getLogger().verbose("Referrer to parse (%s)", objectArray);
            UrlQuerySanitizer urlQuerySanitizer = new UrlQuerySanitizer();
            urlQuerySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
            urlQuerySanitizer.setAllowUnregisteredParamaters(true);
            urlQuerySanitizer.parseQuery((String)objectArray2);
            object = PackageFactory.queryStringClickPackageBuilder(urlQuerySanitizer.getParameterList(), (ActivityState)object, adjustConfig, deviceInfo, sessionParameters);
            if (object == null) {
                return null;
            }
            ((PackageBuilder)object).referrer = objectArray2;
            ((PackageBuilder)object).clickTimeInMilliseconds = l2;
            ((PackageBuilder)object).rawReferrer = string;
            return ((PackageBuilder)object).buildClickPackage("reftag");
        }
        return null;
    }

    public static ActivityPackage buildDeeplinkSdkClickPackage(Uri uri, long l2, ActivityState object, AdjustConfig adjustConfig, DeviceInfo deviceInfo, SessionParameters sessionParameters) {
        if (uri == null) {
            return null;
        }
        String string = uri.toString();
        if (string != null && string.length() != 0) {
            try {
                string = URLDecoder.decode(string, "UTF-8");
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = exception.getMessage();
                AdjustFactory.getLogger().error("Deeplink url decoding failed. Message: (%s)", objectArray2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray3 = objectArray;
                objectArray[0] = illegalArgumentException.getMessage();
                AdjustFactory.getLogger().error("Deeplink url decoding failed due to IllegalArgumentException. Message: (%s)", objectArray3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray4 = objectArray;
                objectArray[0] = unsupportedEncodingException.getMessage();
                AdjustFactory.getLogger().error("Deeplink url decoding failed due to UnsupportedEncodingException. Message: (%s)", objectArray4);
            }
            Object[] objectArray = new Object[1];
            Object[] objectArray5 = objectArray;
            objectArray[0] = string;
            AdjustFactory.getLogger().verbose("Url to parse (%s)", objectArray5);
            UrlQuerySanitizer urlQuerySanitizer = new UrlQuerySanitizer();
            urlQuerySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
            urlQuerySanitizer.setAllowUnregisteredParamaters(true);
            urlQuerySanitizer.parseUrl(string);
            object = PackageFactory.queryStringClickPackageBuilder(urlQuerySanitizer.getParameterList(), (ActivityState)object, adjustConfig, deviceInfo, sessionParameters);
            if (object == null) {
                return null;
            }
            ((PackageBuilder)object).deeplink = uri.toString();
            ((PackageBuilder)object).clickTimeInMilliseconds = l2;
            return ((PackageBuilder)object).buildClickPackage("deeplink");
        }
        return null;
    }

    public static ActivityPackage buildInstallReferrerSdkClickPackage(ReferrerDetails referrerDetails, String string, ActivityState activityState, AdjustConfig adjustConfig, DeviceInfo deviceInfo, SessionParameters sessionParameters) {
        PackageBuilder packageBuilder;
        long l2 = System.currentTimeMillis();
        PackageBuilder packageBuilder2 = packageBuilder;
        packageBuilder2(adjustConfig, deviceInfo, activityState, sessionParameters, l2);
        packageBuilder2.referrer = referrerDetails.installReferrer;
        packageBuilder2.clickTimeInSeconds = referrerDetails.referrerClickTimestampSeconds;
        packageBuilder2.installBeginTimeInSeconds = referrerDetails.installBeginTimestampSeconds;
        packageBuilder2.clickTimeServerInSeconds = referrerDetails.referrerClickTimestampServerSeconds;
        packageBuilder2.installBeginTimeServerInSeconds = referrerDetails.installBeginTimestampServerSeconds;
        packageBuilder2.installVersion = referrerDetails.installVersion;
        packageBuilder2.googlePlayInstant = referrerDetails.googlePlayInstant;
        packageBuilder.referrerApi = string;
        return packageBuilder.buildClickPackage("install_referrer");
    }

    public static ActivityPackage buildPreinstallSdkClickPackage(String string, String string2, ActivityState activityState, AdjustConfig adjustConfig, DeviceInfo deviceInfo, SessionParameters sessionParameters) {
        if (string != null && string.length() != 0) {
            PackageBuilder packageBuilder;
            long l2 = System.currentTimeMillis();
            PackageBuilder packageBuilder2 = packageBuilder;
            packageBuilder2(adjustConfig, deviceInfo, activityState, sessionParameters, l2);
            packageBuilder2.preinstallPayload = string;
            packageBuilder.preinstallLocation = string2;
            return packageBuilder.buildClickPackage("preinstall");
        }
        return null;
    }

    private static PackageBuilder queryStringClickPackageBuilder(List<UrlQuerySanitizer.ParameterValuePair> object, ActivityState activityState, AdjustConfig adjustConfig, DeviceInfo deviceInfo, SessionParameters sessionParameters) {
        AdjustAttribution adjustAttribution;
        LinkedHashMap linkedHashMap;
        if (object == null) {
            return null;
        }
        List<UrlQuerySanitizer.ParameterValuePair> list = object;
        object = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        AdjustAttribution adjustAttribution2 = adjustAttribution;
        adjustAttribution = new AdjustAttribution();
        for (UrlQuerySanitizer.ParameterValuePair parameterValuePair : list) {
            PackageFactory.readQueryString(parameterValuePair.mParameter, parameterValuePair.mValue, (Map<String, String>)object, adjustAttribution2);
        }
        long l2 = System.currentTimeMillis();
        String string = (String)object.remove("reftag");
        if (activityState != null) {
            activityState.lastInterval = l2 - activityState.lastActivity;
        }
        new PackageBuilder(adjustConfig, deviceInfo, activityState, sessionParameters, l2).extraParameters = object;
        new PackageBuilder(adjustConfig, deviceInfo, activityState, sessionParameters, l2).attribution = adjustAttribution2;
        new PackageBuilder(adjustConfig, deviceInfo, activityState, sessionParameters, l2).reftag = string;
        return new PackageBuilder(adjustConfig, deviceInfo, activityState, sessionParameters, l2);
    }

    private static boolean readQueryString(String string, String string2, Map<String, String> map, AdjustAttribution adjustAttribution) {
        if (string != null && string2 != null) {
            if (!string.startsWith(ADJUST_PREFIX)) {
                return false;
            }
            if ((string = string.substring(7)).length() == 0) {
                return false;
            }
            if (string2.length() == 0) {
                return false;
            }
            if (!PackageFactory.tryToSetAttribution(adjustAttribution, string, string2)) {
                map.put(string, string2);
            }
            return true;
        }
        return false;
    }

    private static boolean tryToSetAttribution(AdjustAttribution adjustAttribution, String string, String string2) {
        if (string.equals("tracker")) {
            adjustAttribution.trackerName = string2;
            return true;
        }
        if (string.equals("campaign")) {
            adjustAttribution.campaign = string2;
            return true;
        }
        if (string.equals("adgroup")) {
            adjustAttribution.adgroup = string2;
            return true;
        }
        if (string.equals("creative")) {
            adjustAttribution.creative = string2;
            return true;
        }
        return false;
    }
}

