/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.GooglePlayServicesClient;
import com.adjust.sdk.Reflection;
import com.adjust.sdk.Util;
import java.util.Date;
import java.util.Locale;

class DeviceInfo {
    private static final String OFFICIAL_FACEBOOK_SIGNATURE = "30820268308201d102044a9c4610300d06092a864886f70d0101040500307a310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f31183016060355040a130f46616365626f6f6b204d6f62696c653111300f060355040b130846616365626f6f6b311d301b0603550403131446616365626f6f6b20436f72706f726174696f6e3020170d3039303833313231353231365a180f32303530303932353231353231365a307a310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f31183016060355040a130f46616365626f6f6b204d6f62696c653111300f060355040b130846616365626f6f6b311d301b0603550403131446616365626f6f6b20436f72706f726174696f6e30819f300d06092a864886f70d010101050003818d0030818902818100c207d51df8eb8c97d93ba0c8c1002c928fab00dc1b42fca5e66e99cc3023ed2d214d822bc59e8e35ddcf5f44c7ae8ade50d7e0c434f500e6c131f4a2834f987fc46406115de2018ebbb0d5a3c261bd97581ccfef76afc7135a6d59e8855ecd7eacc8f8737e794c60a761c536b72b11fac8e603f5da1a2d54aa103b8a13c0dbc10203010001300d06092a864886f70d0101040500038181005ee9be8bcbb250648d3b741290a82a1c9dc2e76a0af2f2228f1d9f9c4007529c446a70175c5a900d5141812866db46be6559e2141616483998211f4a673149fb2232a10d247663b26a9031e15f84bc1c74d141ff98a02d76f85b2c8ab2571b6469b232d8e768a7f7ca04f7abe4a775615916c07940656b58717457b42bd928a2";
    String playAdId;
    String playAdIdSource;
    int playAdIdAttempt;
    Boolean isTrackingEnabled;
    private boolean nonGoogleIdsReadOnce;
    String androidId;
    String fbAttributionId;
    String clientSdk;
    String packageName;
    String appVersion;
    String deviceType;
    String deviceName;
    String deviceManufacturer;
    String osName;
    String osVersion;
    String apiLevel;
    String language;
    String country;
    String screenSize;
    String screenFormat;
    String screenDensity;
    String displayWidth;
    String displayHeight;
    String hardwareName;
    String abi;
    String buildName;
    String appInstallTime;
    String appUpdateTime;
    int uiMode;
    String appSetId;

    public DeviceInfo(AdjustConfig adjustConfig) {
        AdjustConfig adjustConfig2 = adjustConfig;
        this.playAdIdAttempt = -1;
        this.nonGoogleIdsReadOnce = false;
        adjustConfig = adjustConfig2.context;
        Resources resources = adjustConfig.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Configuration configuration = resources.getConfiguration();
        Locale locale = Util.getLocale(configuration);
        int n2 = configuration.screenLayout;
        this.packageName = this.getPackageName((Context)adjustConfig);
        this.appVersion = this.getAppVersion((Context)adjustConfig);
        this.deviceType = this.getDeviceType(configuration);
        this.deviceName = this.getDeviceName();
        this.deviceManufacturer = this.getDeviceManufacturer();
        this.osName = this.getOsName();
        this.osVersion = this.getOsVersion();
        this.apiLevel = this.getApiLevel();
        this.language = this.getLanguage(locale);
        this.country = this.getCountry(locale);
        this.screenSize = this.getScreenSize(n2);
        this.screenFormat = this.getScreenFormat(n2);
        this.screenDensity = this.getScreenDensity(displayMetrics);
        this.displayWidth = this.getDisplayWidth(displayMetrics);
        this.displayHeight = this.getDisplayHeight(displayMetrics);
        this.clientSdk = this.getClientSdk(adjustConfig2.sdkPrefix);
        this.fbAttributionId = this.getFacebookAttributionId((Context)adjustConfig);
        this.hardwareName = this.getHardwareName();
        this.abi = this.getABI();
        this.buildName = this.getBuildName();
        this.appInstallTime = this.getAppInstallTime((Context)adjustConfig);
        this.appUpdateTime = this.getAppUpdateTime((Context)adjustConfig);
        this.uiMode = this.getDeviceUiMode(configuration);
        if (Util.canReadPlayIds(adjustConfig2)) {
            this.appSetId = Reflection.getAppSetId((Context)adjustConfig);
        }
    }

    private String getPackageName(Context context) {
        return context.getPackageName();
    }

    private String getAppVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getDeviceType(Configuration configuration) {
        if ((configuration.uiMode & 0xF) == 4) {
            return "tv";
        }
        switch (configuration.screenLayout & 0xF) {
            default: {
                return null;
            }
            case 3: 
            case 4: {
                return "tablet";
            }
            case 1: 
            case 2: 
        }
        return "phone";
    }

    private int getDeviceUiMode(Configuration configuration) {
        return configuration.uiMode & 0xF;
    }

    private String getDeviceName() {
        return Build.MODEL;
    }

    private String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    private String getOsName() {
        return "android";
    }

    private String getOsVersion() {
        return Build.VERSION.RELEASE;
    }

    private String getApiLevel() {
        return "" + Build.VERSION.SDK_INT;
    }

    private String getLanguage(Locale locale) {
        return locale.getLanguage();
    }

    private String getCountry(Locale locale) {
        return locale.getCountry();
    }

    private String getBuildName() {
        return Build.ID;
    }

    private String getHardwareName() {
        return Build.DISPLAY;
    }

    private String getScreenSize(int n2) {
        switch (n2 & 0xF) {
            default: {
                return null;
            }
            case 4: {
                return "xlarge";
            }
            case 3: {
                return "large";
            }
            case 2: {
                return "normal";
            }
            case 1: 
        }
        return "small";
    }

    private String getScreenFormat(int n2) {
        int n3 = n2 & 0x30;
        if (n3 != 16) {
            if (n3 != 32) {
                return null;
            }
            return "long";
        }
        return "normal";
    }

    private String getScreenDensity(DisplayMetrics displayMetrics) {
        int n2 = displayMetrics.densityDpi;
        int n3 = 140;
        int n4 = 200;
        if (n2 == 0) {
            return null;
        }
        if (n2 < n3) {
            return "low";
        }
        if (n2 > n4) {
            return "high";
        }
        return "medium";
    }

    private String getDisplayWidth(DisplayMetrics displayMetrics) {
        return String.valueOf(displayMetrics.widthPixels);
    }

    private String getDisplayHeight(DisplayMetrics displayMetrics) {
        return String.valueOf(displayMetrics.heightPixels);
    }

    private String getClientSdk(String string) {
        if (string == null) {
            return "android4.35.1";
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        objectArray[1] = "android4.35.1";
        return Util.formatString("%s@%s", objectArray2);
    }

    private String getFacebookAttributionId(Context context) {
        block9: {
            block12: {
                block11: {
                    Cursor cursor;
                    block10: {
                        try {
                            cursor = context.getPackageManager().getPackageInfo((String)"com.facebook.katana", (int)64).signatures;
                            if (cursor == null) break block9;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                        if (((Signature[])cursor).length != 1) break block9;
                        if (OFFICIAL_FACEBOOK_SIGNATURE.equals(cursor[0].toCharsString())) break block10;
                        return null;
                    }
                    ContentResolver contentResolver = context.getContentResolver();
                    Uri uri = Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider");
                    String[] stringArray = new String[1];
                    stringArray[0] = "aid";
                    cursor = contentResolver.query(uri, stringArray, null, null, null);
                    if (cursor != null) break block11;
                    return null;
                }
                if (cursor.moveToFirst()) break block12;
                cursor.close();
                return null;
            }
            Cursor cursor = cursor;
            String string = cursor.getString(cursor.getColumnIndex("aid"));
            cursor.close();
            return string;
        }
        return null;
    }

    private String getABI() {
        String[] stringArray = Util.getSupportedAbis();
        if (stringArray != null && stringArray.length != 0) {
            return stringArray[0];
        }
        return Util.getCpuAbi();
    }

    private String getAppInstallTime(Context context) {
        try {
            DeviceInfo deviceInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
        }
        catch (Exception exception) {
            return null;
        }
        return Util.dateFormatter.format(new Date(((PackageInfo)deviceInfo).firstInstallTime));
    }

    private String getAppUpdateTime(Context context) {
        try {
            DeviceInfo deviceInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
        }
        catch (Exception exception) {
            return null;
        }
        return Util.dateFormatter.format(new Date(((PackageInfo)deviceInfo).lastUpdateTime));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reloadPlayIds(AdjustConfig adjustConfig) {
        Object object;
        int n2;
        if (!Util.canReadPlayIds(adjustConfig)) {
            return;
        }
        adjustConfig = adjustConfig.context;
        String string = this.playAdId;
        Boolean bl = this.isTrackingEnabled;
        this.playAdId = null;
        this.isTrackingEnabled = null;
        this.playAdIdSource = null;
        this.playAdIdAttempt = -1;
        for (n2 = 1; n2 <= 3; ++n2) {
            try {
                object = GooglePlayServicesClient.getGooglePlayServicesInfo((Context)adjustConfig, n2 * 3000);
                if (this.playAdId == null) {
                    this.playAdId = ((GooglePlayServicesClient.GooglePlayServicesInfo)object).getGpsAdid();
                }
                if (this.isTrackingEnabled == null) {
                    this.isTrackingEnabled = ((GooglePlayServicesClient.GooglePlayServicesInfo)object).isTrackingEnabled();
                }
                if (this.playAdId == null || this.isTrackingEnabled == null) continue;
                this.playAdIdSource = "service";
                this.playAdIdAttempt = n2;
                return;
            }
            catch (Exception exception) {}
        }
        for (n2 = 1; n2 <= 3; ++n2) {
            object = Util.getAdvertisingInfoObject((Context)adjustConfig, 11000L);
            if (object == null) continue;
            if (this.playAdId == null) {
                this.playAdId = Util.getPlayAdId((Context)adjustConfig, object, 1000L);
            }
            if (this.isTrackingEnabled == null) {
                this.isTrackingEnabled = Util.isPlayTrackingEnabled((Context)adjustConfig, object, 1000L);
            }
            if (this.playAdId == null || this.isTrackingEnabled == null) continue;
            this.playAdIdSource = "library";
            this.playAdIdAttempt = n2;
            return;
        }
        if (this.playAdId == null) {
            this.playAdId = string;
        }
        if (this.isTrackingEnabled == null) {
            this.isTrackingEnabled = bl;
        }
    }

    public void reloadNonPlayIds(AdjustConfig adjustConfig) {
        if (!Util.canReadNonPlayIds(adjustConfig)) {
            return;
        }
        if (this.nonGoogleIdsReadOnce) {
            return;
        }
        DeviceInfo deviceInfo = this;
        deviceInfo.androidId = Util.getAndroidId(adjustConfig.context);
        deviceInfo.nonGoogleIdsReadOnce = true;
    }
}

