/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.util.Log;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.LogLevel;
import com.adjust.sdk.Util;
import java.util.Arrays;
import java.util.Locale;

public class Logger
implements ILogger {
    private LogLevel logLevel;
    private boolean logLevelLocked = false;
    private boolean isProductionEnvironment = false;
    private static String formatErrorMessage = "Error formating log message: %s, with params: %s";

    public Logger() {
        this.setLogLevel(LogLevel.INFO, this.isProductionEnvironment);
    }

    @Override
    public void setLogLevel(LogLevel logLevel, boolean isProductionEnvironment) {
        if (this.logLevelLocked) {
            return;
        }
        this.logLevel = logLevel;
        this.isProductionEnvironment = isProductionEnvironment;
    }

    @Override
    public void setLogLevelString(String logLevelString, boolean isProductionEnvironment) {
        if (null != logLevelString) {
            try {
                this.setLogLevel(LogLevel.valueOf(logLevelString.toUpperCase(Locale.US)), isProductionEnvironment);
            }
            catch (IllegalArgumentException iae) {
                this.error("Malformed logLevel '%s', falling back to 'info'", logLevelString);
            }
        }
    }

    @Override
    public void verbose(String message, Object ... parameters) {
        if (this.isProductionEnvironment) {
            return;
        }
        if (this.logLevel.androidLogLevel <= 2) {
            try {
                Log.v((String)"Adjust", (String)Util.formatString(message, parameters));
            }
            catch (Exception e) {
                Log.e((String)"Adjust", (String)Util.formatString(formatErrorMessage, message, Arrays.toString(parameters)));
            }
        }
    }

    @Override
    public void debug(String message, Object ... parameters) {
        if (this.isProductionEnvironment) {
            return;
        }
        if (this.logLevel.androidLogLevel <= 3) {
            try {
                Log.d((String)"Adjust", (String)Util.formatString(message, parameters));
            }
            catch (Exception e) {
                Log.e((String)"Adjust", (String)Util.formatString(formatErrorMessage, message, Arrays.toString(parameters)));
            }
        }
    }

    @Override
    public void info(String message, Object ... parameters) {
        if (this.isProductionEnvironment) {
            return;
        }
        if (this.logLevel.androidLogLevel <= 4) {
            try {
                Log.i((String)"Adjust", (String)Util.formatString(message, parameters));
            }
            catch (Exception e) {
                Log.e((String)"Adjust", (String)Util.formatString(formatErrorMessage, message, Arrays.toString(parameters)));
            }
        }
    }

    @Override
    public void warn(String message, Object ... parameters) {
        if (this.isProductionEnvironment) {
            return;
        }
        if (this.logLevel.androidLogLevel <= 5) {
            try {
                Log.w((String)"Adjust", (String)Util.formatString(message, parameters));
            }
            catch (Exception e) {
                Log.e((String)"Adjust", (String)Util.formatString(formatErrorMessage, message, Arrays.toString(parameters)));
            }
        }
    }

    @Override
    public void warnInProduction(String message, Object ... parameters) {
        if (this.logLevel.androidLogLevel <= 5) {
            try {
                Log.w((String)"Adjust", (String)Util.formatString(message, parameters));
            }
            catch (Exception e) {
                Log.e((String)"Adjust", (String)Util.formatString(formatErrorMessage, message, Arrays.toString(parameters)));
            }
        }
    }

    @Override
    public void error(String message, Object ... parameters) {
        if (this.isProductionEnvironment) {
            return;
        }
        if (this.logLevel.androidLogLevel <= 6) {
            try {
                Log.e((String)"Adjust", (String)Util.formatString(message, parameters));
            }
            catch (Exception e) {
                Log.e((String)"Adjust", (String)Util.formatString(formatErrorMessage, message, Arrays.toString(parameters)));
            }
        }
    }

    @Override
    public void Assert(String message, Object ... parameters) {
        if (this.isProductionEnvironment) {
            return;
        }
        if (this.logLevel.androidLogLevel <= 7) {
            try {
                Log.println((int)7, (String)"Adjust", (String)Util.formatString(message, parameters));
            }
            catch (Exception e) {
                Log.e((String)"Adjust", (String)Util.formatString(formatErrorMessage, message, Arrays.toString(parameters)));
            }
        }
    }

    @Override
    public void lockLogLevel() {
        this.logLevelLocked = true;
    }
}

