/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.GooglePlayServicesClient;
import com.adjust.sdk.Util;
import java.util.Date;
import java.util.Locale;

class DeviceInfo {
    private static final String OFFICIAL_FACEBOOK_SIGNATURE = "30820268308201d102044a9c4610300d06092a864886f70d0101040500307a310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f31183016060355040a130f46616365626f6f6b204d6f62696c653111300f060355040b130846616365626f6f6b311d301b0603550403131446616365626f6f6b20436f72706f726174696f6e3020170d3039303833313231353231365a180f32303530303932353231353231365a307a310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f31183016060355040a130f46616365626f6f6b204d6f62696c653111300f060355040b130846616365626f6f6b311d301b0603550403131446616365626f6f6b20436f72706f726174696f6e30819f300d06092a864886f70d010101050003818d0030818902818100c207d51df8eb8c97d93ba0c8c1002c928fab00dc1b42fca5e66e99cc3023ed2d214d822bc59e8e35ddcf5f44c7ae8ade50d7e0c434f500e6c131f4a2834f987fc46406115de2018ebbb0d5a3c261bd97581ccfef76afc7135a6d59e8855ecd7eacc8f8737e794c60a761c536b72b11fac8e603f5da1a2d54aa103b8a13c0dbc10203010001300d06092a864886f70d0101040500038181005ee9be8bcbb250648d3b741290a82a1c9dc2e76a0af2f2228f1d9f9c4007529c446a70175c5a900d5141812866db46be6559e2141616483998211f4a673149fb2232a10d247663b26a9031e15f84bc1c74d141ff98a02d76f85b2c8ab2571b6469b232d8e768a7f7ca04f7abe4a775615916c07940656b58717457b42bd928a2";
    String playAdId;
    String playAdIdSource;
    int playAdIdAttempt;
    Boolean isTrackingEnabled;
    private boolean nonGoogleIdsReadOnce = false;
    String macSha1;
    String macShortMd5;
    String androidId;
    String fbAttributionId;
    String clientSdk;
    String packageName;
    String appVersion;
    String deviceType;
    String deviceName;
    String deviceManufacturer;
    String osName;
    String osVersion;
    String apiLevel;
    String language;
    String country;
    String screenSize;
    String screenFormat;
    String screenDensity;
    String displayWidth;
    String displayHeight;
    String hardwareName;
    String abi;
    String buildName;
    String appInstallTime;
    String appUpdateTime;
    int uiMode;

    DeviceInfo(Context context, String sdkPrefix) {
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Configuration configuration = resources.getConfiguration();
        Locale locale = Util.getLocale(configuration);
        int screenLayout = configuration.screenLayout;
        this.packageName = this.getPackageName(context);
        this.appVersion = this.getAppVersion(context);
        this.deviceType = this.getDeviceType(configuration);
        this.deviceName = this.getDeviceName();
        this.deviceManufacturer = this.getDeviceManufacturer();
        this.osName = this.getOsName();
        this.osVersion = this.getOsVersion();
        this.apiLevel = this.getApiLevel();
        this.language = this.getLanguage(locale);
        this.country = this.getCountry(locale);
        this.screenSize = this.getScreenSize(screenLayout);
        this.screenFormat = this.getScreenFormat(screenLayout);
        this.screenDensity = this.getScreenDensity(displayMetrics);
        this.displayWidth = this.getDisplayWidth(displayMetrics);
        this.displayHeight = this.getDisplayHeight(displayMetrics);
        this.clientSdk = this.getClientSdk(sdkPrefix);
        this.fbAttributionId = this.getFacebookAttributionId(context);
        this.hardwareName = this.getHardwareName();
        this.abi = this.getABI();
        this.buildName = this.getBuildName();
        this.appInstallTime = this.getAppInstallTime(context);
        this.appUpdateTime = this.getAppUpdateTime(context);
        this.uiMode = this.getDeviceUiMode(configuration);
    }

    void reloadPlayIds(Context context) {
        String previousPlayAdId = this.playAdId;
        Boolean previousIsTrackingEnabled = this.isTrackingEnabled;
        this.playAdId = null;
        this.isTrackingEnabled = null;
        this.playAdIdSource = null;
        this.playAdIdAttempt = -1;
        for (int serviceAttempt = 1; serviceAttempt <= 3; ++serviceAttempt) {
            try {
                long timeoutServiceMilli = 3000 * serviceAttempt;
                GooglePlayServicesClient.GooglePlayServicesInfo gpsInfo = GooglePlayServicesClient.getGooglePlayServicesInfo(context, timeoutServiceMilli);
                if (this.playAdId == null) {
                    this.playAdId = gpsInfo.getGpsAdid();
                }
                if (this.isTrackingEnabled == null) {
                    this.isTrackingEnabled = gpsInfo.isTrackingEnabled();
                }
                if (this.playAdId == null || this.isTrackingEnabled == null) continue;
                this.playAdIdSource = "service";
                this.playAdIdAttempt = serviceAttempt;
                return;
            }
            catch (Exception timeoutServiceMilli) {
                // empty catch block
            }
        }
        for (int libAttempt = 1; libAttempt <= 3; ++libAttempt) {
            Object advertisingInfoObject = Util.getAdvertisingInfoObject(context, 11000L);
            if (advertisingInfoObject == null) continue;
            if (this.playAdId == null) {
                this.playAdId = Util.getPlayAdId(context, advertisingInfoObject, 1000L);
            }
            if (this.isTrackingEnabled == null) {
                this.isTrackingEnabled = Util.isPlayTrackingEnabled(context, advertisingInfoObject, 1000L);
            }
            if (this.playAdId == null || this.isTrackingEnabled == null) continue;
            this.playAdIdSource = "library";
            this.playAdIdAttempt = libAttempt;
            return;
        }
        if (this.playAdId == null) {
            this.playAdId = previousPlayAdId;
        }
        if (this.isTrackingEnabled == null) {
            this.isTrackingEnabled = previousIsTrackingEnabled;
        }
    }

    void reloadNonPlayIds(Context context) {
        if (this.nonGoogleIdsReadOnce) {
            return;
        }
        if (!Util.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
            AdjustFactory.getLogger().warn("Missing permission: ACCESS_WIFI_STATE", new Object[0]);
        }
        String macAddress = Util.getMacAddress(context);
        this.macSha1 = this.getMacSha1(macAddress);
        this.macShortMd5 = this.getMacShortMd5(macAddress);
        this.androidId = Util.getAndroidId(context);
        this.nonGoogleIdsReadOnce = true;
    }

    private String getMacAddress(Context context, boolean isGooglePlayServicesAvailable) {
        if (!isGooglePlayServicesAvailable) {
            if (!Util.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
                AdjustFactory.getLogger().warn("Missing permission: ACCESS_WIFI_STATE", new Object[0]);
            }
            return Util.getMacAddress(context);
        }
        return null;
    }

    private String getPackageName(Context context) {
        return context.getPackageName();
    }

    private String getAppVersion(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            String name = context.getPackageName();
            PackageInfo info = packageManager.getPackageInfo(name, 0);
            return info.versionName;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getDeviceType(Configuration configuration) {
        int uiMode = configuration.uiMode & 0xF;
        if (uiMode == 4) {
            return "tv";
        }
        int screenSize = configuration.screenLayout & 0xF;
        switch (screenSize) {
            case 1: 
            case 2: {
                return "phone";
            }
            case 3: 
            case 4: {
                return "tablet";
            }
        }
        return null;
    }

    private int getDeviceUiMode(Configuration configuration) {
        return configuration.uiMode & 0xF;
    }

    private String getDeviceName() {
        return Build.MODEL;
    }

    private String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    private String getOsName() {
        return "android";
    }

    private String getOsVersion() {
        return Build.VERSION.RELEASE;
    }

    private String getApiLevel() {
        return "" + Build.VERSION.SDK_INT;
    }

    private String getLanguage(Locale locale) {
        return locale.getLanguage();
    }

    private String getCountry(Locale locale) {
        return locale.getCountry();
    }

    private String getBuildName() {
        return Build.ID;
    }

    private String getHardwareName() {
        return Build.DISPLAY;
    }

    private String getScreenSize(int screenLayout) {
        int screenSize = screenLayout & 0xF;
        switch (screenSize) {
            case 1: {
                return "small";
            }
            case 2: {
                return "normal";
            }
            case 3: {
                return "large";
            }
            case 4: {
                return "xlarge";
            }
        }
        return null;
    }

    private String getScreenFormat(int screenLayout) {
        int screenFormat = screenLayout & 0x30;
        switch (screenFormat) {
            case 32: {
                return "long";
            }
            case 16: {
                return "normal";
            }
        }
        return null;
    }

    private String getScreenDensity(DisplayMetrics displayMetrics) {
        int density = displayMetrics.densityDpi;
        int low = 140;
        int high = 200;
        if (density == 0) {
            return null;
        }
        if (density < low) {
            return "low";
        }
        if (density > high) {
            return "high";
        }
        return "medium";
    }

    private String getDisplayWidth(DisplayMetrics displayMetrics) {
        return String.valueOf(displayMetrics.widthPixels);
    }

    private String getDisplayHeight(DisplayMetrics displayMetrics) {
        return String.valueOf(displayMetrics.heightPixels);
    }

    private String getClientSdk(String sdkPrefix) {
        if (sdkPrefix == null) {
            return "android4.28.4";
        }
        return Util.formatString("%s@%s", sdkPrefix, "android4.28.4");
    }

    private String getMacSha1(String macAddress) {
        if (macAddress == null) {
            return null;
        }
        String macSha1 = Util.sha1(macAddress);
        return macSha1;
    }

    private String getMacShortMd5(String macAddress) {
        if (macAddress == null) {
            return null;
        }
        String macShort = macAddress.replaceAll(":", "");
        String macShortMd5 = Util.md5(macShort);
        return macShortMd5;
    }

    private String getFacebookAttributionId(Context context) {
        try {
            Signature[] signatures = context.getPackageManager().getPackageInfo((String)"com.facebook.katana", (int)64).signatures;
            if (signatures == null || signatures.length != 1) {
                return null;
            }
            Signature facebookApkSignature = signatures[0];
            if (!OFFICIAL_FACEBOOK_SIGNATURE.equals(facebookApkSignature.toCharsString())) {
                return null;
            }
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider");
            String columnName = "aid";
            String[] projection = new String[]{"aid"};
            Cursor cursor = contentResolver.query(uri, projection, null, null, null);
            if (cursor == null) {
                return null;
            }
            if (!cursor.moveToFirst()) {
                cursor.close();
                return null;
            }
            String attributionId = cursor.getString(cursor.getColumnIndex("aid"));
            cursor.close();
            return attributionId;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getABI() {
        String[] SupportedABIS = Util.getSupportedAbis();
        if (SupportedABIS == null || SupportedABIS.length == 0) {
            return Util.getCpuAbi();
        }
        return SupportedABIS[0];
    }

    private String getAppInstallTime(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 4096);
            String appInstallTime = Util.dateFormatter.format(new Date(packageInfo.firstInstallTime));
            return appInstallTime;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String getAppUpdateTime(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 4096);
            String appInstallTime = Util.dateFormatter.format(new Date(packageInfo.lastUpdateTime));
            return appInstallTime;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

