/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.network;

import com.adjust.sdk.ActivityKind;
import java.util.Arrays;
import java.util.List;

public class UrlStrategy {
    private static final String BASE_URL_INDIA = "https://app.adjust.net.in";
    private static final String GDPR_URL_INDIA = "https://gdpr.adjust.net.in";
    private static final String SUBSCRIPTION_URL_INDIA = "https://subscription.adjust.net.in";
    private static final String BASE_URL_CHINA = "https://app.adjust.world";
    private static final String GDPR_URL_CHINA = "https://gdpr.adjust.world";
    private static final String SUBSCRIPTION_URL_CHINA = "https://subscription.adjust.world";
    private final String baseUrlOverwrite;
    private final String gdprUrlOverwrite;
    private final String subscriptionUrlOverwrite;
    final List<String> baseUrlChoicesList;
    final List<String> gdprUrlChoicesList;
    final List<String> subscriptionUrlChoicesList;
    boolean wasLastAttemptSuccess;
    int choiceIndex;
    int startingChoiceIndex;
    boolean wasLastAttemptWithOverwrittenUrl;

    public UrlStrategy(String baseUrlOverwrite, String gdprUrlOverwrite, String subscriptionUrlOverwrite, String adjustUrlStrategy) {
        this.baseUrlOverwrite = baseUrlOverwrite;
        this.gdprUrlOverwrite = gdprUrlOverwrite;
        this.subscriptionUrlOverwrite = subscriptionUrlOverwrite;
        this.baseUrlChoicesList = UrlStrategy.baseUrlChoices(adjustUrlStrategy);
        this.gdprUrlChoicesList = UrlStrategy.gdprUrlChoices(adjustUrlStrategy);
        this.subscriptionUrlChoicesList = UrlStrategy.subscriptionUrlChoices(adjustUrlStrategy);
        this.wasLastAttemptSuccess = false;
        this.choiceIndex = 0;
        this.startingChoiceIndex = 0;
        this.wasLastAttemptWithOverwrittenUrl = false;
    }

    public void resetAfterSuccess() {
        this.startingChoiceIndex = this.choiceIndex;
        this.wasLastAttemptSuccess = true;
    }

    public boolean shouldRetryAfterFailure() {
        int nextChoiceIndex;
        this.wasLastAttemptSuccess = false;
        if (this.wasLastAttemptWithOverwrittenUrl) {
            return false;
        }
        this.choiceIndex = nextChoiceIndex = (this.choiceIndex + 1) % this.baseUrlChoicesList.size();
        boolean nextChoiceHasNotReturnedToStartingChoice = this.choiceIndex != this.startingChoiceIndex;
        return nextChoiceHasNotReturnedToStartingChoice;
    }

    public String targetUrlByActivityKind(ActivityKind activityKind) {
        if (activityKind == ActivityKind.GDPR) {
            if (this.gdprUrlOverwrite != null) {
                this.wasLastAttemptWithOverwrittenUrl = true;
                return this.gdprUrlOverwrite;
            }
            this.wasLastAttemptWithOverwrittenUrl = false;
            return this.gdprUrlChoicesList.get(this.choiceIndex);
        }
        if (activityKind == ActivityKind.SUBSCRIPTION) {
            if (this.subscriptionUrlOverwrite != null) {
                this.wasLastAttemptWithOverwrittenUrl = true;
                return this.subscriptionUrlOverwrite;
            }
            this.wasLastAttemptWithOverwrittenUrl = false;
            return this.subscriptionUrlChoicesList.get(this.choiceIndex);
        }
        if (this.baseUrlOverwrite != null) {
            this.wasLastAttemptWithOverwrittenUrl = true;
            return this.baseUrlOverwrite;
        }
        this.wasLastAttemptWithOverwrittenUrl = false;
        return this.baseUrlChoicesList.get(this.choiceIndex);
    }

    private static List<String> baseUrlChoices(String urlStrategy) {
        if ("url_strategy_india".equals(urlStrategy)) {
            return Arrays.asList(BASE_URL_INDIA, "https://app.adjust.com");
        }
        if ("url_strategy_china".equals(urlStrategy)) {
            return Arrays.asList(BASE_URL_CHINA, "https://app.adjust.com");
        }
        return Arrays.asList("https://app.adjust.com", BASE_URL_INDIA, BASE_URL_CHINA);
    }

    private static List<String> gdprUrlChoices(String urlStrategy) {
        if ("url_strategy_india".equals(urlStrategy)) {
            return Arrays.asList(GDPR_URL_INDIA, "https://gdpr.adjust.com");
        }
        if ("url_strategy_china".equals(urlStrategy)) {
            return Arrays.asList(GDPR_URL_CHINA, "https://gdpr.adjust.com");
        }
        return Arrays.asList("https://gdpr.adjust.com", GDPR_URL_INDIA, GDPR_URL_CHINA);
    }

    private static List<String> subscriptionUrlChoices(String urlStrategy) {
        if ("url_strategy_india".equals(urlStrategy)) {
            return Arrays.asList(SUBSCRIPTION_URL_INDIA, "https://subscription.adjust.com");
        }
        if ("url_strategy_china".equals(urlStrategy)) {
            return Arrays.asList(SUBSCRIPTION_URL_CHINA, "https://subscription.adjust.com");
        }
        return Arrays.asList("https://subscription.adjust.com", SUBSCRIPTION_URL_INDIA, SUBSCRIPTION_URL_CHINA);
    }
}

