/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IRequestHandler;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.UrlFactory;
import com.adjust.sdk.Util;
import com.adjust.sdk.UtilNetworking;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadExecutor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.SocketTimeoutException;
import java.util.List;

public class RequestHandler
implements IRequestHandler {
    private ThreadExecutor executor;
    private WeakReference<IPackageHandler> packageHandlerWeakRef;
    private WeakReference<IActivityHandler> activityHandlerWeakRef;
    private ILogger logger = AdjustFactory.getLogger();
    private String basePath;
    private String gdprPath;
    private String subscriptionPath;

    public RequestHandler(IActivityHandler activityHandler, IPackageHandler packageHandler) {
        this.executor = new SingleThreadCachedScheduler("RequestHandler");
        this.init(activityHandler, packageHandler);
        this.basePath = packageHandler.getBasePath();
        this.gdprPath = packageHandler.getGdprPath();
        this.subscriptionPath = packageHandler.getSubscriptionPath();
    }

    @Override
    public void init(IActivityHandler activityHandler, IPackageHandler packageHandler) {
        this.packageHandlerWeakRef = new WeakReference<IPackageHandler>(packageHandler);
        this.activityHandlerWeakRef = new WeakReference<IActivityHandler>(activityHandler);
    }

    @Override
    public void sendPackage(final ActivityPackage activityPackage, final int queueSize) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                boolean requestProcessed = false;
                if (activityPackage.getActivityKind() == ActivityKind.GDPR) {
                    List<String> urls = UrlFactory.getGdprUrls();
                    for (int i = 0; i < urls.size() && !requestProcessed; ++i) {
                        boolean isLastUrl;
                        String gdprUrl = urls.get(i);
                        if (RequestHandler.this.gdprPath != null) {
                            gdprUrl = gdprUrl + RequestHandler.this.gdprPath;
                        }
                        if (!(requestProcessed = RequestHandler.this.sendI(activityPackage, queueSize, gdprUrl = gdprUrl + activityPackage.getPath(), isLastUrl = i == urls.size() - 1)) || i <= 0) continue;
                        UrlFactory.prioritiseGdprUrl(urls.get(i));
                    }
                } else if (activityPackage.getActivityKind() == ActivityKind.SUBSCRIPTION) {
                    List<String> urls = UrlFactory.getSubscriptionUrls();
                    for (int i = 0; i < urls.size() && !requestProcessed; ++i) {
                        boolean isLastUrl;
                        String subscriptionUrl = urls.get(i);
                        if (RequestHandler.this.subscriptionPath != null) {
                            subscriptionUrl = subscriptionUrl + RequestHandler.this.subscriptionPath;
                        }
                        if (!(requestProcessed = RequestHandler.this.sendI(activityPackage, queueSize, subscriptionUrl = subscriptionUrl + activityPackage.getPath(), isLastUrl = i == urls.size() - 1)) || i <= 0) continue;
                        UrlFactory.prioritiseSubscriptionUrl(urls.get(i));
                    }
                } else {
                    List<String> urls = UrlFactory.getBaseUrls();
                    for (int i = 0; i < urls.size() && !requestProcessed; ++i) {
                        boolean isLastUrl;
                        String baseUrl = urls.get(i);
                        if (RequestHandler.this.basePath != null) {
                            baseUrl = baseUrl + RequestHandler.this.basePath;
                        }
                        if (!(requestProcessed = RequestHandler.this.sendI(activityPackage, queueSize, baseUrl = baseUrl + activityPackage.getPath(), isLastUrl = i == urls.size() - 1)) || i <= 0) continue;
                        UrlFactory.prioritiseBaseUrl(urls.get(i));
                    }
                }
            }
        });
    }

    @Override
    public void teardown() {
        this.logger.verbose("RequestHandler teardown", new Object[0]);
        if (this.executor != null) {
            this.executor.teardown();
        }
        if (this.packageHandlerWeakRef != null) {
            this.packageHandlerWeakRef.clear();
        }
        if (this.activityHandlerWeakRef != null) {
            this.activityHandlerWeakRef.clear();
        }
        this.executor = null;
        this.packageHandlerWeakRef = null;
        this.activityHandlerWeakRef = null;
        this.logger = null;
    }

    private boolean sendI(ActivityPackage activityPackage, int queueSize, String targetURL, boolean isLastUrl) {
        try {
            ResponseData responseData = UtilNetworking.createPOSTHttpsURLConnection(targetURL, activityPackage, queueSize);
            IPackageHandler packageHandler = (IPackageHandler)this.packageHandlerWeakRef.get();
            if (packageHandler == null) {
                return true;
            }
            IActivityHandler activityHandler = (IActivityHandler)this.activityHandlerWeakRef.get();
            if (activityHandler == null) {
                return true;
            }
            if (responseData.trackingState == TrackingState.OPTED_OUT) {
                activityHandler.gotOptOutResponse();
                return true;
            }
            if (responseData.jsonResponse == null) {
                packageHandler.closeFirstPackage(responseData, activityPackage);
                return true;
            }
            packageHandler.sendNextPackage(responseData);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            this.sendNextPackageI(activityPackage, "Failed to encode parameters", e);
            return true;
        }
        catch (SocketTimeoutException e) {
            if (isLastUrl) {
                this.closePackageI(activityPackage, "Request timed out", e);
            }
            return false;
        }
        catch (IOException e) {
            if (isLastUrl) {
                this.closePackageI(activityPackage, "Request failed", e);
            }
            return false;
        }
        catch (Throwable e) {
            this.sendNextPackageI(activityPackage, "Runtime exception", e);
            return true;
        }
    }

    private void closePackageI(ActivityPackage activityPackage, String message, Throwable throwable) {
        String packageMessage = activityPackage.getFailureMessage();
        String reasonString = Util.getReasonString(message, throwable);
        String finalMessage = Util.formatString("%s. (%s) Will retry later", packageMessage, reasonString);
        this.logger.error(finalMessage, new Object[0]);
        ResponseData responseData = ResponseData.buildResponseData(activityPackage);
        responseData.message = finalMessage;
        IPackageHandler packageHandler = (IPackageHandler)this.packageHandlerWeakRef.get();
        if (packageHandler == null) {
            return;
        }
        packageHandler.closeFirstPackage(responseData, activityPackage);
    }

    private void sendNextPackageI(ActivityPackage activityPackage, String message, Throwable throwable) {
        String failureMessage = activityPackage.getFailureMessage();
        String reasonString = Util.getReasonString(message, throwable);
        String finalMessage = Util.formatString("%s. (%s)", failureMessage, reasonString);
        this.logger.error(finalMessage, new Object[0]);
        ResponseData responseData = ResponseData.buildResponseData(activityPackage);
        responseData.message = finalMessage;
        IPackageHandler packageHandler = (IPackageHandler)this.packageHandlerWeakRef.get();
        if (packageHandler == null) {
            return;
        }
        packageHandler.sendNextPackage(responseData);
    }
}

