/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AttributionResponseData;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IAttributionHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SdkClickResponseData;
import com.adjust.sdk.SessionResponseData;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.UrlFactory;
import com.adjust.sdk.Util;
import com.adjust.sdk.UtilNetworking;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadScheduler;
import com.adjust.sdk.scheduler.TimerOnce;
import java.lang.ref.WeakReference;
import java.util.List;
import org.json.JSONObject;

public class AttributionHandler
implements IAttributionHandler {
    private static final String ATTRIBUTION_TIMER_NAME = "Attribution timer";
    private boolean paused;
    private String basePath;
    private String clientSdk;
    private String lastInitiatedBy;
    private ILogger logger = AdjustFactory.getLogger();
    private TimerOnce timer;
    private ThreadScheduler scheduler = new SingleThreadCachedScheduler("AttributionHandler");
    private WeakReference<IActivityHandler> activityHandlerWeakRef;

    @Override
    public void teardown() {
        this.logger.verbose("AttributionHandler teardown", new Object[0]);
        if (this.timer != null) {
            this.timer.teardown();
        }
        if (this.scheduler != null) {
            this.scheduler.teardown();
        }
        if (this.activityHandlerWeakRef != null) {
            this.activityHandlerWeakRef.clear();
        }
        this.timer = null;
        this.logger = null;
        this.scheduler = null;
        this.activityHandlerWeakRef = null;
    }

    public AttributionHandler(IActivityHandler activityHandler, boolean startsSending) {
        this.timer = new TimerOnce(new Runnable(){

            @Override
            public void run() {
                AttributionHandler.this.sendAttributionRequest();
            }
        }, ATTRIBUTION_TIMER_NAME);
        this.basePath = activityHandler.getBasePath();
        this.clientSdk = activityHandler.getDeviceInfo().clientSdk;
        this.init(activityHandler, startsSending);
    }

    @Override
    public void init(IActivityHandler activityHandler, boolean startsSending) {
        this.activityHandlerWeakRef = new WeakReference<IActivityHandler>(activityHandler);
        this.paused = !startsSending;
    }

    @Override
    public void getAttribution() {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                AttributionHandler.this.lastInitiatedBy = "sdk";
                AttributionHandler.this.getAttributionI(0L);
            }
        });
    }

    @Override
    public void checkSessionResponse(final SessionResponseData sessionResponseData) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                IActivityHandler activityHandler = (IActivityHandler)AttributionHandler.this.activityHandlerWeakRef.get();
                if (activityHandler == null) {
                    return;
                }
                AttributionHandler.this.checkSessionResponseI(activityHandler, sessionResponseData);
            }
        });
    }

    @Override
    public void checkSdkClickResponse(final SdkClickResponseData sdkClickResponseData) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                IActivityHandler activityHandler = (IActivityHandler)AttributionHandler.this.activityHandlerWeakRef.get();
                if (activityHandler == null) {
                    return;
                }
                AttributionHandler.this.checkSdkClickResponseI(activityHandler, sdkClickResponseData);
            }
        });
    }

    public void checkAttributionResponse(final AttributionResponseData attributionResponseData) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                IActivityHandler activityHandler = (IActivityHandler)AttributionHandler.this.activityHandlerWeakRef.get();
                if (activityHandler == null) {
                    return;
                }
                AttributionHandler.this.checkAttributionResponseI(activityHandler, attributionResponseData);
            }
        });
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    private void sendAttributionRequest() {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                List<String> urls = UrlFactory.getBaseUrls();
                boolean requestProcessed = false;
                for (int i = 0; i < urls.size() && !requestProcessed; ++i) {
                    requestProcessed = AttributionHandler.this.sendAttributionRequestI(urls.get(i));
                    if (!requestProcessed || i <= 0) continue;
                    UrlFactory.prioritiseBaseUrl(urls.get(i));
                }
            }
        });
    }

    private void getAttributionI(long delayInMilliseconds) {
        if (this.timer.getFireIn() > delayInMilliseconds) {
            return;
        }
        if (delayInMilliseconds != 0L) {
            double waitTimeSeconds = (double)delayInMilliseconds / 1000.0;
            String secondsString = Util.SecondsDisplayFormat.format(waitTimeSeconds);
            this.logger.debug("Waiting to query attribution in %s seconds", secondsString);
        }
        this.timer.startIn(delayInMilliseconds);
    }

    private void checkAttributionI(IActivityHandler activityHandler, ResponseData responseData) {
        if (responseData.jsonResponse == null) {
            return;
        }
        long timerMilliseconds = responseData.jsonResponse.optLong("ask_in", -1L);
        if (timerMilliseconds >= 0L) {
            activityHandler.setAskingAttribution(true);
            this.lastInitiatedBy = "backend";
            this.getAttributionI(timerMilliseconds);
            return;
        }
        activityHandler.setAskingAttribution(false);
        JSONObject attributionJson = responseData.jsonResponse.optJSONObject("attribution");
        responseData.attribution = AdjustAttribution.fromJson(attributionJson, responseData.adid, Util.getSdkPrefixPlatform(this.clientSdk));
    }

    private void checkSessionResponseI(IActivityHandler activityHandler, SessionResponseData sessionResponseData) {
        this.checkAttributionI(activityHandler, sessionResponseData);
        activityHandler.launchSessionResponseTasks(sessionResponseData);
    }

    private void checkSdkClickResponseI(IActivityHandler activityHandler, SdkClickResponseData sdkClickResponseData) {
        this.checkAttributionI(activityHandler, sdkClickResponseData);
        activityHandler.launchSdkClickResponseTasks(sdkClickResponseData);
    }

    private void checkAttributionResponseI(IActivityHandler activityHandler, AttributionResponseData attributionResponseData) {
        this.checkAttributionI(activityHandler, attributionResponseData);
        this.checkDeeplinkI(attributionResponseData);
        activityHandler.launchAttributionResponseTasks(attributionResponseData);
    }

    private void checkDeeplinkI(AttributionResponseData attributionResponseData) {
        if (attributionResponseData.jsonResponse == null) {
            return;
        }
        JSONObject attributionJson = attributionResponseData.jsonResponse.optJSONObject("attribution");
        if (attributionJson == null) {
            return;
        }
        String deeplinkString = attributionJson.optString("deeplink", null);
        if (deeplinkString == null) {
            return;
        }
        attributionResponseData.deeplink = Uri.parse((String)deeplinkString);
    }

    private boolean sendAttributionRequestI(String baseUrl) {
        if (((IActivityHandler)this.activityHandlerWeakRef.get()).getActivityState().isGdprForgotten) {
            return true;
        }
        if (this.paused) {
            this.logger.debug("Attribution handler is paused", new Object[0]);
            return true;
        }
        ActivityPackage attributionPackage = this.buildAndGetAttributionPackage();
        this.logger.verbose("%s", attributionPackage.getExtendedString());
        try {
            ResponseData responseData = UtilNetworking.createGETHttpsURLConnection(attributionPackage, this.basePath, baseUrl);
            if (!(responseData instanceof AttributionResponseData)) {
                return true;
            }
            if (responseData.trackingState == TrackingState.OPTED_OUT) {
                ((IActivityHandler)this.activityHandlerWeakRef.get()).gotOptOutResponse();
                return true;
            }
            this.checkAttributionResponse((AttributionResponseData)responseData);
            return true;
        }
        catch (Exception e) {
            this.logger.error("Failed to get attribution (%s)", e.getMessage());
            return false;
        }
    }

    private ActivityPackage buildAndGetAttributionPackage() {
        long now = System.currentTimeMillis();
        IActivityHandler activityHandler = (IActivityHandler)this.activityHandlerWeakRef.get();
        PackageBuilder packageBuilder = new PackageBuilder(activityHandler.getAdjustConfig(), activityHandler.getDeviceInfo(), activityHandler.getActivityState(), activityHandler.getSessionParameters(), now);
        ActivityPackage activityPackage = packageBuilder.buildAttributionPackage(this.lastInitiatedBy);
        this.lastInitiatedBy = null;
        return activityPackage;
    }
}

