/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IRequestHandler;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SessionParameters;
import com.adjust.sdk.Util;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadScheduler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class PackageHandler
implements IPackageHandler {
    private static final String PACKAGE_QUEUE_FILENAME = "AdjustIoPackageQueue";
    private static final String PACKAGE_QUEUE_NAME = "Package queue";
    private ThreadScheduler scheduler = new SingleThreadCachedScheduler("PackageHandler");
    private IRequestHandler requestHandler;
    private WeakReference<IActivityHandler> activityHandlerWeakRef;
    private List<ActivityPackage> packageQueue;
    private AtomicBoolean isSending;
    private boolean paused;
    private Context context;
    private ILogger logger = AdjustFactory.getLogger();
    private BackoffStrategy backoffStrategy = AdjustFactory.getPackageHandlerBackoffStrategy();
    private String basePath;
    private String gdprPath;

    @Override
    public void teardown() {
        this.logger.verbose("PackageHandler teardown", new Object[0]);
        if (this.scheduler != null) {
            this.scheduler.teardown();
        }
        if (this.activityHandlerWeakRef != null) {
            this.activityHandlerWeakRef.clear();
        }
        if (this.requestHandler != null) {
            this.requestHandler.teardown();
        }
        if (this.packageQueue != null) {
            this.packageQueue.clear();
        }
        this.scheduler = null;
        this.requestHandler = null;
        this.activityHandlerWeakRef = null;
        this.packageQueue = null;
        this.isSending = null;
        this.context = null;
        this.logger = null;
        this.backoffStrategy = null;
    }

    static void deleteState(Context context) {
        PackageHandler.deletePackageQueue(context);
    }

    public PackageHandler(IActivityHandler activityHandler, Context context, boolean startsSending) {
        this.init(activityHandler, context, startsSending);
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.initI();
            }
        });
    }

    @Override
    public void init(IActivityHandler activityHandler, Context context, boolean startsSending) {
        this.activityHandlerWeakRef = new WeakReference<IActivityHandler>(activityHandler);
        this.context = context;
        this.paused = !startsSending;
        this.basePath = activityHandler.getBasePath();
        this.gdprPath = activityHandler.getGdprPath();
    }

    @Override
    public void addPackage(final ActivityPackage activityPackage) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.addI(activityPackage);
            }
        });
    }

    @Override
    public void sendFirstPackage() {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.sendFirstI();
            }
        });
    }

    @Override
    public void sendNextPackage(ResponseData responseData) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.sendNextI();
            }
        });
        IActivityHandler activityHandler = (IActivityHandler)this.activityHandlerWeakRef.get();
        if (activityHandler != null) {
            activityHandler.finishedTrackingActivity(responseData);
        }
    }

    @Override
    public void closeFirstPackage(ResponseData responseData, ActivityPackage activityPackage) {
        responseData.willRetry = true;
        IActivityHandler activityHandler = (IActivityHandler)this.activityHandlerWeakRef.get();
        if (activityHandler != null) {
            activityHandler.finishedTrackingActivity(responseData);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.logger.verbose("Package handler can send", new Object[0]);
                PackageHandler.this.isSending.set(false);
                PackageHandler.this.sendFirstPackage();
            }
        };
        if (activityPackage == null) {
            runnable.run();
            return;
        }
        int retries = activityPackage.increaseRetries();
        long waitTimeMilliSeconds = Util.getWaitingTime(retries, this.backoffStrategy);
        double waitTimeSeconds = (double)waitTimeMilliSeconds / 1000.0;
        String secondsString = Util.SecondsDisplayFormat.format(waitTimeSeconds);
        this.logger.verbose("Waiting for %s seconds before retrying the %d time", secondsString, retries);
        this.scheduler.schedule(runnable, waitTimeMilliSeconds);
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    @Override
    public void updatePackages(SessionParameters sessionParameters) {
        final SessionParameters sessionParametersCopy = sessionParameters != null ? sessionParameters.deepCopy() : null;
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.updatePackagesI(sessionParametersCopy);
            }
        });
    }

    @Override
    public void flush() {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                PackageHandler.this.flushI();
            }
        });
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public String getGdprPath() {
        return this.gdprPath;
    }

    private void initI() {
        this.requestHandler = AdjustFactory.getRequestHandler((IActivityHandler)this.activityHandlerWeakRef.get(), this);
        this.isSending = new AtomicBoolean();
        this.readPackageQueueI();
    }

    private void addI(ActivityPackage newPackage) {
        this.packageQueue.add(newPackage);
        this.logger.debug("Added package %d (%s)", this.packageQueue.size(), newPackage);
        this.logger.verbose("%s", newPackage.getExtendedString());
        this.writePackageQueueI();
    }

    private void sendFirstI() {
        if (this.packageQueue.isEmpty()) {
            return;
        }
        if (this.paused) {
            this.logger.debug("Package handler is paused", new Object[0]);
            return;
        }
        if (this.isSending.getAndSet(true)) {
            this.logger.verbose("Package handler is already sending", new Object[0]);
            return;
        }
        ActivityPackage firstPackage = this.packageQueue.get(0);
        this.requestHandler.sendPackage(firstPackage, this.packageQueue.size() - 1);
    }

    private void sendNextI() {
        if (this.packageQueue.isEmpty()) {
            return;
        }
        this.packageQueue.remove(0);
        this.writePackageQueueI();
        this.isSending.set(false);
        this.logger.verbose("Package handler can send", new Object[0]);
        this.sendFirstI();
    }

    public void updatePackagesI(SessionParameters sessionParameters) {
        if (sessionParameters == null) {
            return;
        }
        this.logger.debug("Updating package handler queue", new Object[0]);
        this.logger.verbose("Session callback parameters: %s", sessionParameters.callbackParameters);
        this.logger.verbose("Session partner parameters: %s", sessionParameters.partnerParameters);
        for (ActivityPackage activityPackage : this.packageQueue) {
            Map<String, String> parameters = activityPackage.getParameters();
            Map<String, String> mergedCallbackParameters = Util.mergeParameters(sessionParameters.callbackParameters, activityPackage.getCallbackParameters(), "Callback");
            PackageBuilder.addMapJson(parameters, "callback_params", mergedCallbackParameters);
            Map<String, String> mergedPartnerParameters = Util.mergeParameters(sessionParameters.partnerParameters, activityPackage.getPartnerParameters(), "Partner");
            PackageBuilder.addMapJson(parameters, "partner_params", mergedPartnerParameters);
        }
        this.writePackageQueueI();
    }

    private void flushI() {
        this.packageQueue.clear();
        this.writePackageQueueI();
    }

    private void readPackageQueueI() {
        try {
            this.packageQueue = Util.readObject(this.context, PACKAGE_QUEUE_FILENAME, PACKAGE_QUEUE_NAME, List.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to read %s file (%s)", PACKAGE_QUEUE_NAME, e.getMessage());
            this.packageQueue = null;
        }
        if (this.packageQueue != null) {
            this.logger.debug("Package handler read %d packages", this.packageQueue.size());
        } else {
            this.packageQueue = new ArrayList<ActivityPackage>();
        }
    }

    private void writePackageQueueI() {
        Util.writeObject(this.packageQueue, this.context, PACKAGE_QUEUE_FILENAME, PACKAGE_QUEUE_NAME);
        this.logger.debug("Package handler wrote %d packages", this.packageQueue.size());
    }

    public static Boolean deletePackageQueue(Context context) {
        return context.deleteFile(PACKAGE_QUEUE_FILENAME);
    }
}

