/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.scheduler;

import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Util;
import com.adjust.sdk.scheduler.FutureScheduler;
import com.adjust.sdk.scheduler.SingleThreadFutureScheduler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TimerOnce {
    private FutureScheduler scheduler;
    private ScheduledFuture waitingTask;
    private String name;
    private Runnable command;
    private ILogger logger;

    public TimerOnce(Runnable command, String name) {
        this.name = name;
        this.scheduler = new SingleThreadFutureScheduler(name, true);
        this.command = command;
        this.logger = AdjustFactory.getLogger();
    }

    public void startIn(long fireIn) {
        this.cancel(false);
        String fireInSeconds = Util.SecondsDisplayFormat.format((double)fireIn / 1000.0);
        this.logger.verbose("%s starting. Launching in %s seconds", this.name, fireInSeconds);
        this.waitingTask = this.scheduler.scheduleFuture(new Runnable(){

            @Override
            public void run() {
                TimerOnce.this.logger.verbose("%s fired", TimerOnce.this.name);
                TimerOnce.this.command.run();
                TimerOnce.this.waitingTask = null;
            }
        }, fireIn);
    }

    public long getFireIn() {
        if (this.waitingTask == null) {
            return 0L;
        }
        return this.waitingTask.getDelay(TimeUnit.MILLISECONDS);
    }

    private void cancel(boolean mayInterruptIfRunning) {
        if (this.waitingTask != null) {
            this.waitingTask.cancel(mayInterruptIfRunning);
        }
        this.waitingTask = null;
        this.logger.verbose("%s canceled", this.name);
    }

    public void cancel() {
        this.cancel(false);
    }

    public void teardown() {
        this.cancel(true);
        if (this.scheduler != null) {
            this.scheduler.teardown();
        }
        this.scheduler = null;
    }
}

