/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.AdjustFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class CustomScheduledExecutor
extends ScheduledThreadPoolExecutor {
    public CustomScheduledExecutor(final String source, boolean doKeepAlive) {
        super(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setPriority(1);
                thread.setName("Adjust-" + thread.getName() + "-" + source);
                thread.setDaemon(true);
                thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread th, Throwable tr) {
                        AdjustFactory.getLogger().error("Thread [%s] with error [%s]", th.getName(), tr.getMessage());
                    }
                });
                return thread;
            }
        }, new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
                AdjustFactory.getLogger().warn("Runnable [%s] rejected from [%s] ", runnable.toString(), source);
            }
        });
        if (!doKeepAlive) {
            this.setKeepAliveTime(10L, TimeUnit.MILLISECONDS);
            this.allowCoreThreadTimeOut(true);
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        return super.submit(new RunnableWrapper(task));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay(new RunnableWrapper(command), initialDelay, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return super.schedule(new RunnableWrapper(command), delay, unit);
    }

    private static class RunnableWrapper
    implements Runnable {
        private Runnable runnable;

        RunnableWrapper(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                AdjustFactory.getLogger().error("Runnable error [%s] of type [%s]", t.getMessage(), t.getClass().getCanonicalName());
            }
        }
    }
}

