/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Process;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AttributionResponseData;
import com.adjust.sdk.CustomScheduledExecutor;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.EventResponseData;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IAttributionHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IRunActivityHandler;
import com.adjust.sdk.ISdkClickHandler;
import com.adjust.sdk.InstallReferrer;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.PackageFactory;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SdkClickResponseData;
import com.adjust.sdk.SessionParameters;
import com.adjust.sdk.SessionResponseData;
import com.adjust.sdk.SharedPreferencesManager;
import com.adjust.sdk.TimerCycle;
import com.adjust.sdk.TimerOnce;
import com.adjust.sdk.Util;
import com.adjust.sdk.UtilNetworking;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.json.JSONArray;

public class ActivityHandler
implements IActivityHandler {
    private static long FOREGROUND_TIMER_INTERVAL;
    private static long FOREGROUND_TIMER_START;
    private static long BACKGROUND_TIMER_INTERVAL;
    private static long SESSION_INTERVAL;
    private static long SUBSESSION_INTERVAL;
    private static final String TIME_TRAVEL = "Time travel!";
    private static final String ACTIVITY_STATE_NAME = "Activity state";
    private static final String ATTRIBUTION_NAME = "Attribution";
    private static final String FOREGROUND_TIMER_NAME = "Foreground timer";
    private static final String BACKGROUND_TIMER_NAME = "Background timer";
    private static final String DELAY_START_TIMER_NAME = "Delay Start timer";
    private static final String SESSION_CALLBACK_PARAMETERS_NAME = "Session Callback parameters";
    private static final String SESSION_PARTNER_PARAMETERS_NAME = "Session Partner parameters";
    private static final String SESSION_PARAMETERS_NAME = "Session parameters";
    private CustomScheduledExecutor scheduledExecutor;
    private IPackageHandler packageHandler;
    private ActivityState activityState;
    private ILogger logger;
    private TimerCycle foregroundTimer;
    private TimerOnce backgroundTimer;
    private TimerOnce delayStartTimer;
    private InternalState internalState;
    private String basePath;
    private String gdprPath;
    private DeviceInfo deviceInfo;
    private AdjustConfig adjustConfig;
    private AdjustAttribution attribution;
    private IAttributionHandler attributionHandler;
    private ISdkClickHandler sdkClickHandler;
    private SessionParameters sessionParameters;
    private InstallReferrer installReferrer;

    @Override
    public void teardown() {
        if (this.backgroundTimer != null) {
            this.backgroundTimer.teardown();
        }
        if (this.foregroundTimer != null) {
            this.foregroundTimer.teardown();
        }
        if (this.delayStartTimer != null) {
            this.delayStartTimer.teardown();
        }
        if (this.scheduledExecutor != null) {
            try {
                this.scheduledExecutor.shutdownNow();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.packageHandler != null) {
            this.packageHandler.teardown();
        }
        if (this.attributionHandler != null) {
            this.attributionHandler.teardown();
        }
        if (this.sdkClickHandler != null) {
            this.sdkClickHandler.teardown();
        }
        if (this.sessionParameters != null) {
            if (this.sessionParameters.callbackParameters != null) {
                this.sessionParameters.callbackParameters.clear();
            }
            if (this.sessionParameters.partnerParameters != null) {
                this.sessionParameters.partnerParameters.clear();
            }
        }
        this.teardownActivityStateS();
        this.teardownAttributionS();
        this.teardownAllSessionParametersS();
        this.packageHandler = null;
        this.logger = null;
        this.foregroundTimer = null;
        this.scheduledExecutor = null;
        this.backgroundTimer = null;
        this.delayStartTimer = null;
        this.internalState = null;
        this.deviceInfo = null;
        this.adjustConfig = null;
        this.attributionHandler = null;
        this.sdkClickHandler = null;
        this.sessionParameters = null;
    }

    static void deleteState(Context context) {
        ActivityHandler.deleteActivityState(context);
        ActivityHandler.deleteAttribution(context);
        ActivityHandler.deleteSessionCallbackParameters(context);
        ActivityHandler.deleteSessionPartnerParameters(context);
        SharedPreferencesManager sharedPreferencesManager = new SharedPreferencesManager(context);
        sharedPreferencesManager.clear();
    }

    private ActivityHandler(AdjustConfig adjustConfig) {
        this.init(adjustConfig);
        this.logger = AdjustFactory.getLogger();
        this.logger.lockLogLevel();
        this.scheduledExecutor = new CustomScheduledExecutor("ActivityHandler", false);
        this.internalState = new InternalState();
        this.internalState.enabled = adjustConfig.startEnabled != null ? adjustConfig.startEnabled : true;
        this.internalState.offline = adjustConfig.startOffline;
        this.internalState.background = true;
        this.internalState.delayStart = false;
        this.internalState.updatePackages = false;
        this.internalState.sessionResponseProcessed = false;
        this.internalState.firstSdkStart = false;
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.initI();
            }
        });
    }

    @Override
    public AdjustConfig getAdjustConfig() {
        return this.adjustConfig;
    }

    @Override
    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    @Override
    public ActivityState getActivityState() {
        return this.activityState;
    }

    @Override
    public SessionParameters getSessionParameters() {
        return this.sessionParameters;
    }

    @Override
    public void init(AdjustConfig adjustConfig) {
        this.adjustConfig = adjustConfig;
    }

    public static ActivityHandler getInstance(AdjustConfig adjustConfig) {
        if (adjustConfig == null) {
            AdjustFactory.getLogger().error("AdjustConfig missing", new Object[0]);
            return null;
        }
        if (!adjustConfig.isValid()) {
            AdjustFactory.getLogger().error("AdjustConfig not initialized correctly", new Object[0]);
            return null;
        }
        if (adjustConfig.processName != null) {
            int currentPid = Process.myPid();
            ActivityManager manager = (ActivityManager)adjustConfig.context.getSystemService("activity");
            if (manager == null) {
                return null;
            }
            for (ActivityManager.RunningAppProcessInfo processInfo : manager.getRunningAppProcesses()) {
                if (processInfo.pid != currentPid) continue;
                if (processInfo.processName.equalsIgnoreCase(adjustConfig.processName)) break;
                AdjustFactory.getLogger().info("Skipping initialization in background process (%s)", processInfo.processName);
                return null;
            }
        }
        ActivityHandler activityHandler = new ActivityHandler(adjustConfig);
        return activityHandler;
    }

    @Override
    public void onResume() {
        this.internalState.background = false;
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.delayStartI();
                ActivityHandler.this.stopBackgroundTimerI();
                ActivityHandler.this.startForegroundTimerI();
                ActivityHandler.this.logger.verbose("Subsession start", new Object[0]);
                ActivityHandler.this.startI();
            }
        });
    }

    @Override
    public void onPause() {
        this.internalState.background = true;
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.stopForegroundTimerI();
                ActivityHandler.this.startBackgroundTimerI();
                ActivityHandler.this.logger.verbose("Subsession end", new Object[0]);
                ActivityHandler.this.endI();
            }
        });
    }

    @Override
    public void trackEvent(final AdjustEvent event) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                if (ActivityHandler.this.internalState.hasFirstSdkStartNotOcurred()) {
                    ActivityHandler.this.logger.warn("Event tracked before first activity resumed.\nIf it was triggered in the Application class, it might timestamp or even send an install long before the user opens the app.\nPlease check https://github.com/adjust/android_sdk#can-i-trigger-an-event-at-application-launch for more information.", new Object[0]);
                    ActivityHandler.this.startI();
                }
                ActivityHandler.this.trackEventI(event);
            }
        });
    }

    @Override
    public void finishedTrackingActivity(ResponseData responseData) {
        if (responseData instanceof SessionResponseData) {
            this.attributionHandler.checkSessionResponse((SessionResponseData)responseData);
            return;
        }
        if (responseData instanceof SdkClickResponseData) {
            this.checkForInstallReferrerInfo((SdkClickResponseData)responseData);
            this.attributionHandler.checkSdkClickResponse((SdkClickResponseData)responseData);
            return;
        }
        if (responseData instanceof EventResponseData) {
            this.launchEventResponseTasks((EventResponseData)responseData);
            return;
        }
    }

    @Override
    public void setEnabled(final boolean enabled) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.setEnabledI(enabled);
            }
        });
    }

    @Override
    public void setOfflineMode(final boolean offline) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.setOfflineModeI(offline);
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabledI();
    }

    private boolean isEnabledI() {
        if (this.activityState != null) {
            return this.activityState.enabled;
        }
        return this.internalState.isEnabled();
    }

    @Override
    public void readOpenUrl(final Uri url, final long clickTime) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.readOpenUrlI(url, clickTime);
            }
        });
    }

    private void updateAdidI(String adid) {
        if (adid == null) {
            return;
        }
        if (adid.equals(this.activityState.adid)) {
            return;
        }
        this.activityState.adid = adid;
        this.writeActivityStateI();
    }

    @Override
    public boolean updateAttributionI(AdjustAttribution attribution) {
        if (attribution == null) {
            return false;
        }
        if (attribution.equals(this.attribution)) {
            return false;
        }
        this.attribution = attribution;
        this.writeAttributionI();
        return true;
    }

    @Override
    public void setAskingAttribution(final boolean askingAttribution) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.setAskingAttributionI(askingAttribution);
            }
        });
    }

    @Override
    public void sendReftagReferrer() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.sendReftagReferrerI();
            }
        });
    }

    @Override
    public void sendInstallReferrer(final long clickTime, final long installBegin, final String installReferrer) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.sendInstallReferrerI(clickTime, installBegin, installReferrer);
            }
        });
    }

    @Override
    public void launchEventResponseTasks(final EventResponseData eventResponseData) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.launchEventResponseTasksI(eventResponseData);
            }
        });
    }

    @Override
    public void launchSdkClickResponseTasks(final SdkClickResponseData sdkClickResponseData) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.launchSdkClickResponseTasksI(sdkClickResponseData);
            }
        });
    }

    @Override
    public void launchSessionResponseTasks(final SessionResponseData sessionResponseData) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.launchSessionResponseTasksI(sessionResponseData);
            }
        });
    }

    @Override
    public void launchAttributionResponseTasks(final AttributionResponseData attributionResponseData) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.launchAttributionResponseTasksI(attributionResponseData);
            }
        });
    }

    @Override
    public void sendFirstPackages() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.sendFirstPackagesI();
            }
        });
    }

    @Override
    public void addSessionCallbackParameter(final String key, final String value) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.addSessionCallbackParameterI(key, value);
            }
        });
    }

    @Override
    public void addSessionPartnerParameter(final String key, final String value) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.addSessionPartnerParameterI(key, value);
            }
        });
    }

    @Override
    public void removeSessionCallbackParameter(final String key) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.removeSessionCallbackParameterI(key);
            }
        });
    }

    @Override
    public void removeSessionPartnerParameter(final String key) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.removeSessionPartnerParameterI(key);
            }
        });
    }

    @Override
    public void resetSessionCallbackParameters() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.resetSessionCallbackParametersI();
            }
        });
    }

    @Override
    public void resetSessionPartnerParameters() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.resetSessionPartnerParametersI();
            }
        });
    }

    @Override
    public void setPushToken(final String token, final boolean preSaved) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                if (!preSaved) {
                    SharedPreferencesManager sharedPreferencesManager = new SharedPreferencesManager(ActivityHandler.this.getContext());
                    sharedPreferencesManager.savePushToken(token);
                }
                if (ActivityHandler.this.internalState.hasFirstSdkStartNotOcurred()) {
                    return;
                }
                ActivityHandler.this.setPushTokenI(token);
            }
        });
    }

    @Override
    public void gdprForgetMe() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.gdprForgetMeI();
            }
        });
    }

    @Override
    public void gotOptOutResponse() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.gotOptOutResponseI();
            }
        });
    }

    @Override
    public Context getContext() {
        return this.adjustConfig.context;
    }

    public void foregroundTimerFired() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.foregroundTimerFiredI();
            }
        });
    }

    public void backgroundTimerFired() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.backgroundTimerFiredI();
            }
        });
    }

    @Override
    public String getAdid() {
        if (this.activityState == null) {
            return null;
        }
        return this.activityState.adid;
    }

    @Override
    public AdjustAttribution getAttribution() {
        return this.attribution;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public String getGdprPath() {
        return this.gdprPath;
    }

    public ActivityPackage getAttributionPackageI() {
        long now = System.currentTimeMillis();
        PackageBuilder attributionBuilder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, this.sessionParameters, now);
        return attributionBuilder.buildAttributionPackage();
    }

    public InternalState getInternalState() {
        return this.internalState;
    }

    private void initI() {
        SharedPreferencesManager sharedPreferencesManager;
        SESSION_INTERVAL = AdjustFactory.getSessionInterval();
        SUBSESSION_INTERVAL = AdjustFactory.getSubsessionInterval();
        FOREGROUND_TIMER_INTERVAL = AdjustFactory.getTimerInterval();
        FOREGROUND_TIMER_START = AdjustFactory.getTimerStart();
        BACKGROUND_TIMER_INTERVAL = AdjustFactory.getTimerInterval();
        this.readAttributionI(this.adjustConfig.context);
        this.readActivityStateI(this.adjustConfig.context);
        this.sessionParameters = new SessionParameters();
        this.readSessionCallbackParametersI(this.adjustConfig.context);
        this.readSessionPartnerParametersI(this.adjustConfig.context);
        if (this.adjustConfig.startEnabled != null) {
            if (this.adjustConfig.preLaunchActionsArray == null) {
                this.adjustConfig.preLaunchActionsArray = new ArrayList<IRunActivityHandler>();
            }
            this.adjustConfig.preLaunchActionsArray.add(new IRunActivityHandler(){

                @Override
                public void run(ActivityHandler activityHandler) {
                    activityHandler.setEnabledI(((ActivityHandler)ActivityHandler.this).adjustConfig.startEnabled);
                }
            });
        }
        if (this.internalState.hasFirstSdkStartOcurred()) {
            this.internalState.enabled = this.activityState.enabled;
            this.internalState.updatePackages = this.activityState.updatePackages;
            this.internalState.firstLaunch = false;
        } else {
            this.internalState.firstLaunch = true;
        }
        this.readConfigFile(this.adjustConfig.context);
        this.deviceInfo = new DeviceInfo(this.adjustConfig.context, this.adjustConfig.sdkPrefix);
        if (this.adjustConfig.eventBufferingEnabled) {
            this.logger.info("Event buffering is enabled", new Object[0]);
        }
        if (this.deviceInfo.playAdId == null) {
            this.logger.warn("Unable to get Google Play Services Advertising ID at start time", new Object[0]);
            if (this.deviceInfo.macSha1 == null && this.deviceInfo.macShortMd5 == null && this.deviceInfo.androidId == null) {
                this.logger.error("Unable to get any device id's. Please check if Proguard is correctly set with Adjust SDK", new Object[0]);
            }
        } else {
            this.logger.info("Google Play Services Advertising ID read correctly at start time", new Object[0]);
        }
        if (this.adjustConfig.defaultTracker != null) {
            this.logger.info("Default tracker: '%s'", this.adjustConfig.defaultTracker);
        }
        if (this.adjustConfig.pushToken != null) {
            this.logger.info("Push token: '%s'", this.adjustConfig.pushToken);
            if (this.internalState.hasFirstSdkStartOcurred()) {
                this.setPushToken(this.adjustConfig.pushToken, false);
            } else {
                sharedPreferencesManager = new SharedPreferencesManager(this.getContext());
                sharedPreferencesManager.savePushToken(this.adjustConfig.pushToken);
            }
        } else if (this.internalState.hasFirstSdkStartOcurred()) {
            sharedPreferencesManager = new SharedPreferencesManager(this.getContext());
            String savedPushToken = sharedPreferencesManager.getPushToken();
            this.setPushToken(savedPushToken, true);
        }
        if (this.internalState.hasFirstSdkStartOcurred() && (sharedPreferencesManager = new SharedPreferencesManager(this.getContext())).getGdprForgetMe()) {
            this.gdprForgetMe();
        }
        this.foregroundTimer = new TimerCycle(new Runnable(){

            @Override
            public void run() {
                ActivityHandler.this.foregroundTimerFired();
            }
        }, FOREGROUND_TIMER_START, FOREGROUND_TIMER_INTERVAL, FOREGROUND_TIMER_NAME);
        if (this.adjustConfig.sendInBackground) {
            this.logger.info("Send in background configured", new Object[0]);
            this.backgroundTimer = new TimerOnce(new Runnable(){

                @Override
                public void run() {
                    ActivityHandler.this.backgroundTimerFired();
                }
            }, BACKGROUND_TIMER_NAME);
        }
        if (this.internalState.hasFirstSdkStartNotOcurred() && this.adjustConfig.delayStart != null && this.adjustConfig.delayStart > 0.0) {
            this.logger.info("Delay start configured", new Object[0]);
            this.internalState.delayStart = true;
            this.delayStartTimer = new TimerOnce(new Runnable(){

                @Override
                public void run() {
                    ActivityHandler.this.sendFirstPackages();
                }
            }, DELAY_START_TIMER_NAME);
        }
        UtilNetworking.setUserAgent(this.adjustConfig.userAgent);
        this.basePath = this.adjustConfig.basePath;
        this.gdprPath = this.adjustConfig.gdprPath;
        this.packageHandler = AdjustFactory.getPackageHandler(this, this.adjustConfig.context, this.toSendI(false));
        ActivityPackage attributionPackage = this.getAttributionPackageI();
        this.attributionHandler = AdjustFactory.getAttributionHandler(this, attributionPackage, this.toSendI(false));
        this.sdkClickHandler = AdjustFactory.getSdkClickHandler(this, this.toSendI(true));
        if (this.isToUpdatePackagesI()) {
            this.updatePackagesI();
        }
        this.installReferrer = new InstallReferrer(this.adjustConfig.context, this);
        this.preLaunchActionsI(this.adjustConfig.preLaunchActionsArray);
        this.sendReftagReferrerI();
    }

    private void readConfigFile(Context context) {
        Properties properties;
        try {
            InputStream inputStream = context.getAssets().open("adjust_config.properties");
            properties = new Properties();
            properties.load(inputStream);
        }
        catch (Exception e) {
            this.logger.debug("%s file not found in this app", e.getMessage());
            return;
        }
        this.logger.verbose("adjust_config.properties file read and loaded", new Object[0]);
        String defaultTracker = properties.getProperty("defaultTracker");
        if (defaultTracker != null) {
            this.adjustConfig.defaultTracker = defaultTracker;
        }
    }

    private void preLaunchActionsI(List<IRunActivityHandler> preLaunchActionsArray) {
        if (preLaunchActionsArray == null) {
            return;
        }
        for (IRunActivityHandler preLaunchAction : preLaunchActionsArray) {
            preLaunchAction.run(this);
        }
    }

    private void startI() {
        if (this.internalState.hasFirstSdkStartNotOcurred()) {
            this.startFirstSessionI();
            return;
        }
        if (!this.activityState.enabled) {
            return;
        }
        this.updateHandlersStatusAndSendI();
        this.processSessionI();
        this.checkAttributionStateI();
        this.processCachedDeeplinkI();
    }

    private void startFirstSessionI() {
        this.updateHandlersStatusAndSendI();
        this.activityState = new ActivityState();
        this.internalState.firstSdkStart = true;
        long now = System.currentTimeMillis();
        SharedPreferencesManager sharedPreferencesManager = new SharedPreferencesManager(this.getContext());
        this.activityState.pushToken = sharedPreferencesManager.getPushToken();
        if (this.internalState.isEnabled()) {
            if (!sharedPreferencesManager.getGdprForgetMe()) {
                this.activityState.sessionCount = 1;
                this.transferSessionPackageI(now);
                this.checkAfterNewStartI(sharedPreferencesManager);
            } else {
                this.gdprForgetMeI();
            }
        }
        this.activityState.resetSessionAttributes(now);
        this.activityState.enabled = this.internalState.isEnabled();
        this.activityState.updatePackages = this.internalState.itHasToUpdatePackages();
        this.writeActivityStateI();
        sharedPreferencesManager.removePushToken();
        sharedPreferencesManager.removeGdprForgetMe();
        this.processCachedDeeplinkI();
    }

    private void processSessionI() {
        if (this.activityState.isGdprForgotten) {
            return;
        }
        long now = System.currentTimeMillis();
        long lastInterval = now - this.activityState.lastActivity;
        if (lastInterval < 0L) {
            this.logger.error(TIME_TRAVEL, new Object[0]);
            this.activityState.lastActivity = now;
            this.writeActivityStateI();
            return;
        }
        if (lastInterval > SESSION_INTERVAL) {
            this.trackNewSessionI(now);
            this.checkAfterNewStartI();
            return;
        }
        if (lastInterval > SUBSESSION_INTERVAL) {
            ++this.activityState.subsessionCount;
            this.activityState.sessionLength += lastInterval;
            this.activityState.lastActivity = now;
            this.logger.verbose("Started subsession %d of session %d", this.activityState.subsessionCount, this.activityState.sessionCount);
            this.writeActivityStateI();
            this.installReferrer.startConnection();
            return;
        }
        this.logger.verbose("Time span since last activity too short for a new subsession", new Object[0]);
    }

    private void trackNewSessionI(long now) {
        long lastInterval = now - this.activityState.lastActivity;
        ++this.activityState.sessionCount;
        this.activityState.lastInterval = lastInterval;
        this.transferSessionPackageI(now);
        this.activityState.resetSessionAttributes(now);
        this.writeActivityStateI();
    }

    private void checkAttributionStateI() {
        if (!this.checkActivityStateI(this.activityState)) {
            return;
        }
        if (this.internalState.isFirstLaunch() && this.internalState.hasSessionResponseNotBeenProcessed()) {
            return;
        }
        if (this.attribution != null && !this.activityState.askingAttribution) {
            return;
        }
        this.attributionHandler.getAttribution();
    }

    private void processCachedDeeplinkI() {
        if (!this.checkActivityStateI(this.activityState)) {
            return;
        }
        SharedPreferencesManager sharedPreferencesManager = new SharedPreferencesManager(this.getContext());
        String cachedDeeplinkUrl = sharedPreferencesManager.getDeeplinkUrl();
        long cachedDeeplinkClickTime = sharedPreferencesManager.getDeeplinkClickTime();
        if (cachedDeeplinkUrl == null) {
            return;
        }
        if (cachedDeeplinkClickTime == -1L) {
            return;
        }
        this.readOpenUrl(Uri.parse((String)cachedDeeplinkUrl), cachedDeeplinkClickTime);
        sharedPreferencesManager.removeDeeplink();
    }

    private void endI() {
        if (!this.toSendI()) {
            this.pauseSendingI();
        }
        if (this.updateActivityStateI(System.currentTimeMillis())) {
            this.writeActivityStateI();
        }
    }

    private void trackEventI(AdjustEvent event) {
        if (!this.checkActivityStateI(this.activityState)) {
            return;
        }
        if (!this.isEnabledI()) {
            return;
        }
        if (!this.checkEventI(event)) {
            return;
        }
        if (!this.checkOrderIdI(event.orderId)) {
            return;
        }
        if (this.activityState.isGdprForgotten) {
            return;
        }
        long now = System.currentTimeMillis();
        ++this.activityState.eventCount;
        this.updateActivityStateI(now);
        PackageBuilder eventBuilder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, this.sessionParameters, now);
        ActivityPackage eventPackage = eventBuilder.buildEventPackage(event, this.internalState.isInDelayedStart());
        this.packageHandler.addPackage(eventPackage);
        if (this.adjustConfig.eventBufferingEnabled) {
            this.logger.info("Buffered event %s", eventPackage.getSuffix());
        } else {
            this.packageHandler.sendFirstPackage();
        }
        if (this.adjustConfig.sendInBackground && this.internalState.isInBackground()) {
            this.startBackgroundTimerI();
        }
        this.writeActivityStateI();
    }

    private void launchEventResponseTasksI(final EventResponseData eventResponseData) {
        this.updateAdidI(eventResponseData.adid);
        Handler handler = new Handler(this.adjustConfig.context.getMainLooper());
        if (eventResponseData.success && this.adjustConfig.onEventTrackingSucceededListener != null) {
            this.logger.debug("Launching success event tracking listener", new Object[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (ActivityHandler.this.adjustConfig == null) {
                        return;
                    }
                    if (((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingSucceededListener == null) {
                        return;
                    }
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingSucceededListener.onFinishedEventTrackingSucceeded(eventResponseData.getSuccessResponseData());
                }
            };
            handler.post(runnable);
            return;
        }
        if (!eventResponseData.success && this.adjustConfig.onEventTrackingFailedListener != null) {
            this.logger.debug("Launching failed event tracking listener", new Object[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (ActivityHandler.this.adjustConfig == null) {
                        return;
                    }
                    if (((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingFailedListener == null) {
                        return;
                    }
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingFailedListener.onFinishedEventTrackingFailed(eventResponseData.getFailureResponseData());
                }
            };
            handler.post(runnable);
            return;
        }
    }

    private void launchSdkClickResponseTasksI(SdkClickResponseData sdkClickResponseData) {
        this.updateAdidI(sdkClickResponseData.adid);
        Handler handler = new Handler(this.adjustConfig.context.getMainLooper());
        boolean attributionUpdated = this.updateAttributionI(sdkClickResponseData.attribution);
        if (attributionUpdated) {
            this.launchAttributionListenerI(handler);
        }
    }

    private void launchSessionResponseTasksI(SessionResponseData sessionResponseData) {
        this.updateAdidI(sessionResponseData.adid);
        Handler handler = new Handler(this.adjustConfig.context.getMainLooper());
        boolean attributionUpdated = this.updateAttributionI(sessionResponseData.attribution);
        if (attributionUpdated) {
            this.launchAttributionListenerI(handler);
        }
        if (sessionResponseData.success) {
            SharedPreferencesManager sharedPreferencesManager = new SharedPreferencesManager(this.getContext());
            sharedPreferencesManager.setInstallTracked();
        }
        this.launchSessionResponseListenerI(sessionResponseData, handler);
        this.internalState.sessionResponseProcessed = true;
    }

    private void launchSessionResponseListenerI(final SessionResponseData sessionResponseData, Handler handler) {
        if (sessionResponseData.success && this.adjustConfig.onSessionTrackingSucceededListener != null) {
            this.logger.debug("Launching success session tracking listener", new Object[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (ActivityHandler.this.adjustConfig == null) {
                        return;
                    }
                    if (((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingSucceededListener == null) {
                        return;
                    }
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingSucceededListener.onFinishedSessionTrackingSucceeded(sessionResponseData.getSuccessResponseData());
                }
            };
            handler.post(runnable);
            return;
        }
        if (!sessionResponseData.success && this.adjustConfig.onSessionTrackingFailedListener != null) {
            this.logger.debug("Launching failed session tracking listener", new Object[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (ActivityHandler.this.adjustConfig == null) {
                        return;
                    }
                    if (((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingFailedListener == null) {
                        return;
                    }
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingFailedListener.onFinishedSessionTrackingFailed(sessionResponseData.getFailureResponseData());
                }
            };
            handler.post(runnable);
            return;
        }
    }

    private void launchAttributionResponseTasksI(AttributionResponseData attributionResponseData) {
        this.updateAdidI(attributionResponseData.adid);
        Handler handler = new Handler(this.adjustConfig.context.getMainLooper());
        boolean attributionUpdated = this.updateAttributionI(attributionResponseData.attribution);
        if (attributionUpdated) {
            this.launchAttributionListenerI(handler);
        }
        this.prepareDeeplinkI(attributionResponseData.deeplink, handler);
    }

    private void launchAttributionListenerI(Handler handler) {
        if (this.adjustConfig.onAttributionChangedListener == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (ActivityHandler.this.adjustConfig == null) {
                    return;
                }
                if (((ActivityHandler)ActivityHandler.this).adjustConfig.onAttributionChangedListener == null) {
                    return;
                }
                ((ActivityHandler)ActivityHandler.this).adjustConfig.onAttributionChangedListener.onAttributionChanged(ActivityHandler.this.attribution);
            }
        };
        handler.post(runnable);
    }

    private void prepareDeeplinkI(final Uri deeplink, Handler handler) {
        if (deeplink == null) {
            return;
        }
        this.logger.info("Deferred deeplink received (%s)", deeplink);
        final Intent deeplinkIntent = this.createDeeplinkIntentI(deeplink);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (ActivityHandler.this.adjustConfig == null) {
                    return;
                }
                boolean toLaunchDeeplink = true;
                if (((ActivityHandler)ActivityHandler.this).adjustConfig.onDeeplinkResponseListener != null) {
                    toLaunchDeeplink = ((ActivityHandler)ActivityHandler.this).adjustConfig.onDeeplinkResponseListener.launchReceivedDeeplink(deeplink);
                }
                if (toLaunchDeeplink) {
                    ActivityHandler.this.launchDeeplinkMain(deeplinkIntent, deeplink);
                }
            }
        };
        handler.post(runnable);
    }

    private Intent createDeeplinkIntentI(Uri deeplink) {
        Intent mapIntent = this.adjustConfig.deepLinkComponent == null ? new Intent("android.intent.action.VIEW", deeplink) : new Intent("android.intent.action.VIEW", deeplink, this.adjustConfig.context, this.adjustConfig.deepLinkComponent);
        mapIntent.setFlags(0x10000000);
        mapIntent.setPackage(this.adjustConfig.context.getPackageName());
        return mapIntent;
    }

    private void launchDeeplinkMain(Intent deeplinkIntent, Uri deeplink) {
        boolean isIntentSafe;
        PackageManager packageManager = this.adjustConfig.context.getPackageManager();
        List activities = packageManager.queryIntentActivities(deeplinkIntent, 0);
        boolean bl = isIntentSafe = activities.size() > 0;
        if (!isIntentSafe) {
            this.logger.error("Unable to open deferred deep link (%s)", deeplink);
            return;
        }
        this.logger.info("Open deferred deep link (%s)", deeplink);
        this.adjustConfig.context.startActivity(deeplinkIntent);
    }

    private void setEnabledI(boolean enabled) {
        if (!this.hasChangedStateI(this.isEnabledI(), enabled, "Adjust already enabled", "Adjust already disabled")) {
            return;
        }
        if (enabled && this.activityState.isGdprForgotten) {
            this.logger.error("Re-enabling SDK not possible for forgotten user", new Object[0]);
            return;
        }
        this.internalState.enabled = enabled;
        if (this.internalState.hasFirstSdkStartNotOcurred()) {
            this.updateStatusI(!enabled, "Handlers will start as paused due to the SDK being disabled", "Handlers will still start as paused", "Handlers will start as active due to the SDK being enabled");
            return;
        }
        this.activityState.enabled = enabled;
        this.writeActivityStateI();
        if (enabled) {
            SharedPreferencesManager sharedPreferencesManager = new SharedPreferencesManager(this.getContext());
            if (sharedPreferencesManager.getGdprForgetMe()) {
                this.gdprForgetMeI();
            }
            if (!sharedPreferencesManager.getInstallTracked()) {
                long now = System.currentTimeMillis();
                this.trackNewSessionI(now);
            }
            this.checkAfterNewStartI(sharedPreferencesManager);
        }
        this.updateStatusI(!enabled, "Pausing handlers due to SDK being disabled", "Handlers remain paused", "Resuming handlers due to SDK being enabled");
    }

    private void checkAfterNewStartI() {
        SharedPreferencesManager sharedPreferencesManager = new SharedPreferencesManager(this.getContext());
        this.checkAfterNewStartI(sharedPreferencesManager);
    }

    private void checkAfterNewStartI(SharedPreferencesManager sharedPreferencesManager) {
        JSONArray referrers;
        String pushToken = sharedPreferencesManager.getPushToken();
        if (pushToken != null && !pushToken.equals(this.activityState.pushToken)) {
            this.setPushToken(pushToken, true);
        }
        if ((referrers = sharedPreferencesManager.getRawReferrerArray()) != null) {
            this.sendReftagReferrer();
        }
        this.installReferrer.startConnection();
    }

    private void setOfflineModeI(boolean offline) {
        if (!this.hasChangedStateI(this.internalState.isOffline(), offline, "Adjust already in offline mode", "Adjust already in online mode")) {
            return;
        }
        this.internalState.offline = offline;
        if (this.internalState.hasFirstSdkStartNotOcurred()) {
            this.updateStatusI(offline, "Handlers will start paused due to SDK being offline", "Handlers will still start as paused", "Handlers will start as active due to SDK being online");
            return;
        }
        this.updateStatusI(offline, "Pausing handlers to put SDK offline mode", "Handlers remain paused", "Resuming handlers to put SDK in online mode");
    }

    private boolean hasChangedStateI(boolean previousState, boolean newState, String trueMessage, String falseMessage) {
        if (previousState != newState) {
            return true;
        }
        if (previousState) {
            this.logger.debug(trueMessage, new Object[0]);
        } else {
            this.logger.debug(falseMessage, new Object[0]);
        }
        return false;
    }

    private void updateStatusI(boolean pausingState, String pausingMessage, String remainsPausedMessage, String unPausingMessage) {
        if (pausingState) {
            this.logger.info(pausingMessage, new Object[0]);
        } else if (this.pausedI(false)) {
            if (this.pausedI(true)) {
                this.logger.info(remainsPausedMessage, new Object[0]);
            } else {
                this.logger.info(remainsPausedMessage + ", except the Sdk Click Handler", new Object[0]);
            }
        } else {
            this.logger.info(unPausingMessage, new Object[0]);
        }
        this.updateHandlersStatusAndSendI();
    }

    private void setAskingAttributionI(boolean askingAttribution) {
        this.activityState.askingAttribution = askingAttribution;
        this.writeActivityStateI();
    }

    private void sendReftagReferrerI() {
        if (!this.isEnabledI()) {
            return;
        }
        if (this.internalState.hasFirstSdkStartNotOcurred()) {
            return;
        }
        this.sdkClickHandler.sendReftagReferrers();
    }

    private void sendInstallReferrerI(long clickTime, long installBegin, String installReferrer) {
        if (!this.isEnabledI()) {
            return;
        }
        if (installReferrer == null) {
            return;
        }
        if (clickTime == this.activityState.clickTime && installBegin == this.activityState.installBegin && installReferrer.equals(this.activityState.installReferrer)) {
            return;
        }
        ActivityPackage sdkClickPackage = PackageFactory.buildInstallReferrerSdkClickPackage(installReferrer, clickTime, installBegin, this.activityState, this.adjustConfig, this.deviceInfo, this.sessionParameters);
        this.sdkClickHandler.sendSdkClick(sdkClickPackage);
    }

    private void readOpenUrlI(Uri url, long clickTime) {
        if (!this.isEnabledI()) {
            return;
        }
        ActivityPackage sdkClickPackage = PackageFactory.buildDeeplinkSdkClickPackage(url, clickTime, this.activityState, this.adjustConfig, this.deviceInfo, this.sessionParameters);
        if (sdkClickPackage == null) {
            return;
        }
        this.sdkClickHandler.sendSdkClick(sdkClickPackage);
    }

    private void updateHandlersStatusAndSendI() {
        if (!this.toSendI()) {
            this.pauseSendingI();
            return;
        }
        this.resumeSendingI();
        if (!this.adjustConfig.eventBufferingEnabled || this.internalState.isFirstLaunch() && this.internalState.hasSessionResponseNotBeenProcessed()) {
            this.packageHandler.sendFirstPackage();
        }
    }

    private void pauseSendingI() {
        this.attributionHandler.pauseSending();
        this.packageHandler.pauseSending();
        if (!this.toSendI(true)) {
            this.sdkClickHandler.pauseSending();
        } else {
            this.sdkClickHandler.resumeSending();
        }
    }

    private void resumeSendingI() {
        this.attributionHandler.resumeSending();
        this.packageHandler.resumeSending();
        this.sdkClickHandler.resumeSending();
    }

    private boolean updateActivityStateI(long now) {
        if (!this.checkActivityStateI(this.activityState)) {
            return false;
        }
        long lastInterval = now - this.activityState.lastActivity;
        if (lastInterval > SESSION_INTERVAL) {
            return false;
        }
        this.activityState.lastActivity = now;
        if (lastInterval < 0L) {
            this.logger.error(TIME_TRAVEL, new Object[0]);
        } else {
            this.activityState.sessionLength += lastInterval;
            this.activityState.timeSpent += lastInterval;
        }
        return true;
    }

    public static boolean deleteActivityState(Context context) {
        return context.deleteFile("AdjustIoActivityState");
    }

    public static boolean deleteAttribution(Context context) {
        return context.deleteFile("AdjustAttribution");
    }

    public static boolean deleteSessionCallbackParameters(Context context) {
        return context.deleteFile("AdjustSessionCallbackParameters");
    }

    public static boolean deleteSessionPartnerParameters(Context context) {
        return context.deleteFile("AdjustSessionPartnerParameters");
    }

    private void transferSessionPackageI(long now) {
        PackageBuilder builder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, this.sessionParameters, now);
        ActivityPackage sessionPackage = builder.buildSessionPackage(this.internalState.isInDelayedStart());
        this.packageHandler.addPackage(sessionPackage);
        this.packageHandler.sendFirstPackage();
    }

    private void startForegroundTimerI() {
        if (!this.isEnabledI()) {
            return;
        }
        this.foregroundTimer.start();
    }

    private void stopForegroundTimerI() {
        this.foregroundTimer.suspend();
    }

    private void foregroundTimerFiredI() {
        if (!this.isEnabledI()) {
            this.stopForegroundTimerI();
            return;
        }
        if (this.toSendI()) {
            this.packageHandler.sendFirstPackage();
        }
        if (this.updateActivityStateI(System.currentTimeMillis())) {
            this.writeActivityStateI();
        }
    }

    private void startBackgroundTimerI() {
        if (this.backgroundTimer == null) {
            return;
        }
        if (!this.toSendI()) {
            return;
        }
        if (this.backgroundTimer.getFireIn() > 0L) {
            return;
        }
        this.backgroundTimer.startIn(BACKGROUND_TIMER_INTERVAL);
    }

    private void stopBackgroundTimerI() {
        if (this.backgroundTimer == null) {
            return;
        }
        this.backgroundTimer.cancel();
    }

    private void backgroundTimerFiredI() {
        if (this.toSendI()) {
            this.packageHandler.sendFirstPackage();
        }
    }

    private void delayStartI() {
        long maxDelayStartMilli;
        if (this.internalState.isNotInDelayedStart()) {
            return;
        }
        if (this.isToUpdatePackagesI()) {
            return;
        }
        double delayStartSeconds = this.adjustConfig.delayStart != null ? this.adjustConfig.delayStart : 0.0;
        long delayStartMilli = (long)(delayStartSeconds * 1000.0);
        if (delayStartMilli > (maxDelayStartMilli = AdjustFactory.getMaxDelayStart())) {
            double maxDelayStartSeconds = maxDelayStartMilli / 1000L;
            String delayStartFormatted = Util.SecondsDisplayFormat.format(delayStartSeconds);
            String maxDelayStartFormatted = Util.SecondsDisplayFormat.format(maxDelayStartSeconds);
            this.logger.warn("Delay start of %s seconds bigger than max allowed value of %s seconds", delayStartFormatted, maxDelayStartFormatted);
            delayStartMilli = maxDelayStartMilli;
            delayStartSeconds = maxDelayStartSeconds;
        }
        String delayStartFormatted = Util.SecondsDisplayFormat.format(delayStartSeconds);
        this.logger.info("Waiting %s seconds before starting first session", delayStartFormatted);
        this.delayStartTimer.startIn(delayStartMilli);
        this.internalState.updatePackages = true;
        if (this.activityState != null) {
            this.activityState.updatePackages = true;
            this.writeActivityStateI();
        }
    }

    private void sendFirstPackagesI() {
        if (this.internalState.isNotInDelayedStart()) {
            this.logger.info("Start delay expired or never configured", new Object[0]);
            return;
        }
        this.updatePackagesI();
        this.internalState.delayStart = false;
        this.delayStartTimer.cancel();
        this.delayStartTimer = null;
        this.updateHandlersStatusAndSendI();
    }

    private void updatePackagesI() {
        this.packageHandler.updatePackages(this.sessionParameters);
        this.internalState.updatePackages = false;
        if (this.activityState != null) {
            this.activityState.updatePackages = false;
            this.writeActivityStateI();
        }
    }

    private boolean isToUpdatePackagesI() {
        if (this.activityState != null) {
            return this.activityState.updatePackages;
        }
        return this.internalState.itHasToUpdatePackages();
    }

    public void addSessionCallbackParameterI(String key, String value) {
        String oldValue;
        if (!Util.isValidParameter(key, "key", "Session Callback")) {
            return;
        }
        if (!Util.isValidParameter(value, "value", "Session Callback")) {
            return;
        }
        if (this.sessionParameters.callbackParameters == null) {
            this.sessionParameters.callbackParameters = new LinkedHashMap<String, String>();
        }
        if (value.equals(oldValue = this.sessionParameters.callbackParameters.get(key))) {
            this.logger.verbose("Key %s already present with the same value", key);
            return;
        }
        if (oldValue != null) {
            this.logger.warn("Key %s will be overwritten", key);
        }
        this.sessionParameters.callbackParameters.put(key, value);
        this.writeSessionCallbackParametersI();
    }

    public void addSessionPartnerParameterI(String key, String value) {
        String oldValue;
        if (!Util.isValidParameter(key, "key", "Session Partner")) {
            return;
        }
        if (!Util.isValidParameter(value, "value", "Session Partner")) {
            return;
        }
        if (this.sessionParameters.partnerParameters == null) {
            this.sessionParameters.partnerParameters = new LinkedHashMap<String, String>();
        }
        if (value.equals(oldValue = this.sessionParameters.partnerParameters.get(key))) {
            this.logger.verbose("Key %s already present with the same value", key);
            return;
        }
        if (oldValue != null) {
            this.logger.warn("Key %s will be overwritten", key);
        }
        this.sessionParameters.partnerParameters.put(key, value);
        this.writeSessionPartnerParametersI();
    }

    public void removeSessionCallbackParameterI(String key) {
        if (!Util.isValidParameter(key, "key", "Session Callback")) {
            return;
        }
        if (this.sessionParameters.callbackParameters == null) {
            this.logger.warn("Session Callback parameters are not set", new Object[0]);
            return;
        }
        String oldValue = this.sessionParameters.callbackParameters.remove(key);
        if (oldValue == null) {
            this.logger.warn("Key %s does not exist", key);
            return;
        }
        this.logger.debug("Key %s will be removed", key);
        this.writeSessionCallbackParametersI();
    }

    public void removeSessionPartnerParameterI(String key) {
        if (!Util.isValidParameter(key, "key", "Session Partner")) {
            return;
        }
        if (this.sessionParameters.partnerParameters == null) {
            this.logger.warn("Session Partner parameters are not set", new Object[0]);
            return;
        }
        String oldValue = this.sessionParameters.partnerParameters.remove(key);
        if (oldValue == null) {
            this.logger.warn("Key %s does not exist", key);
            return;
        }
        this.logger.debug("Key %s will be removed", key);
        this.writeSessionPartnerParametersI();
    }

    public void resetSessionCallbackParametersI() {
        if (this.sessionParameters.callbackParameters == null) {
            this.logger.warn("Session Callback parameters are not set", new Object[0]);
        }
        this.sessionParameters.callbackParameters = null;
        this.writeSessionCallbackParametersI();
    }

    public void resetSessionPartnerParametersI() {
        if (this.sessionParameters.partnerParameters == null) {
            this.logger.warn("Session Partner parameters are not set", new Object[0]);
        }
        this.sessionParameters.partnerParameters = null;
        this.writeSessionPartnerParametersI();
    }

    private void setPushTokenI(String token) {
        if (!this.checkActivityStateI(this.activityState)) {
            return;
        }
        if (!this.isEnabledI()) {
            return;
        }
        if (this.activityState.isGdprForgotten) {
            return;
        }
        if (token == null) {
            return;
        }
        if (token.equals(this.activityState.pushToken)) {
            return;
        }
        this.activityState.pushToken = token;
        this.writeActivityStateI();
        long now = System.currentTimeMillis();
        PackageBuilder infoPackageBuilder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, this.sessionParameters, now);
        ActivityPackage infoPackage = infoPackageBuilder.buildInfoPackage("push");
        this.packageHandler.addPackage(infoPackage);
        SharedPreferencesManager sharedPreferencesManager = new SharedPreferencesManager(this.getContext());
        sharedPreferencesManager.removePushToken();
        if (this.adjustConfig.eventBufferingEnabled) {
            this.logger.info("Buffered event %s", infoPackage.getSuffix());
        } else {
            this.packageHandler.sendFirstPackage();
        }
    }

    private void gdprForgetMeI() {
        if (!this.checkActivityStateI(this.activityState)) {
            return;
        }
        if (!this.isEnabledI()) {
            return;
        }
        if (this.activityState.isGdprForgotten) {
            return;
        }
        this.activityState.isGdprForgotten = true;
        this.writeActivityStateI();
        long now = System.currentTimeMillis();
        PackageBuilder gdprPackageBuilder = new PackageBuilder(this.adjustConfig, this.deviceInfo, this.activityState, this.sessionParameters, now);
        ActivityPackage gdprPackage = gdprPackageBuilder.buildGdprPackage();
        this.packageHandler.addPackage(gdprPackage);
        SharedPreferencesManager sharedPreferencesManager = new SharedPreferencesManager(this.getContext());
        sharedPreferencesManager.removeGdprForgetMe();
        if (this.adjustConfig.eventBufferingEnabled) {
            this.logger.info("Buffered event %s", gdprPackage.getSuffix());
        } else {
            this.packageHandler.sendFirstPackage();
        }
    }

    private void gotOptOutResponseI() {
        this.activityState.isGdprForgotten = true;
        this.writeActivityStateI();
        this.packageHandler.flush();
        this.setEnabledI(false);
    }

    private void readActivityStateI(Context context) {
        try {
            this.activityState = Util.readObject(context, "AdjustIoActivityState", ACTIVITY_STATE_NAME, ActivityState.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to read %s file (%s)", ACTIVITY_STATE_NAME, e.getMessage());
            this.activityState = null;
        }
        if (this.activityState != null) {
            this.internalState.firstSdkStart = true;
        }
    }

    private void readAttributionI(Context context) {
        try {
            this.attribution = Util.readObject(context, "AdjustAttribution", ATTRIBUTION_NAME, AdjustAttribution.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to read %s file (%s)", ATTRIBUTION_NAME, e.getMessage());
            this.attribution = null;
        }
    }

    private void readSessionCallbackParametersI(Context context) {
        try {
            this.sessionParameters.callbackParameters = Util.readObject(context, "AdjustSessionCallbackParameters", SESSION_CALLBACK_PARAMETERS_NAME, Map.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to read %s file (%s)", SESSION_CALLBACK_PARAMETERS_NAME, e.getMessage());
            this.sessionParameters.callbackParameters = null;
        }
    }

    private void readSessionPartnerParametersI(Context context) {
        try {
            this.sessionParameters.partnerParameters = Util.readObject(context, "AdjustSessionPartnerParameters", SESSION_PARTNER_PARAMETERS_NAME, Map.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to read %s file (%s)", SESSION_PARTNER_PARAMETERS_NAME, e.getMessage());
            this.sessionParameters.partnerParameters = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeActivityStateI() {
        Class<ActivityState> clazz = ActivityState.class;
        synchronized (ActivityState.class) {
            if (this.activityState == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Util.writeObject(this.activityState, this.adjustConfig.context, "AdjustIoActivityState", ACTIVITY_STATE_NAME);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardownActivityStateS() {
        Class<ActivityState> clazz = ActivityState.class;
        synchronized (ActivityState.class) {
            if (this.activityState == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.activityState = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAttributionI() {
        Class<AdjustAttribution> clazz = AdjustAttribution.class;
        synchronized (AdjustAttribution.class) {
            if (this.attribution == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Util.writeObject(this.attribution, this.adjustConfig.context, "AdjustAttribution", ATTRIBUTION_NAME);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardownAttributionS() {
        Class<AdjustAttribution> clazz = AdjustAttribution.class;
        synchronized (AdjustAttribution.class) {
            if (this.attribution == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.attribution = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionCallbackParametersI() {
        Class<SessionParameters> clazz = SessionParameters.class;
        synchronized (SessionParameters.class) {
            if (this.sessionParameters == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Util.writeObject(this.sessionParameters.callbackParameters, this.adjustConfig.context, "AdjustSessionCallbackParameters", SESSION_CALLBACK_PARAMETERS_NAME);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionPartnerParametersI() {
        Class<SessionParameters> clazz = SessionParameters.class;
        synchronized (SessionParameters.class) {
            if (this.sessionParameters == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Util.writeObject(this.sessionParameters.partnerParameters, this.adjustConfig.context, "AdjustSessionPartnerParameters", SESSION_PARTNER_PARAMETERS_NAME);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardownAllSessionParametersS() {
        Class<SessionParameters> clazz = SessionParameters.class;
        synchronized (SessionParameters.class) {
            if (this.sessionParameters == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.sessionParameters = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private boolean checkEventI(AdjustEvent event) {
        if (event == null) {
            this.logger.error("Event missing", new Object[0]);
            return false;
        }
        if (!event.isValid()) {
            this.logger.error("Event not initialized correctly", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkOrderIdI(String orderId) {
        if (orderId == null || orderId.isEmpty()) {
            return true;
        }
        if (this.activityState.findOrderId(orderId)) {
            this.logger.info("Skipping duplicated order ID '%s'", orderId);
            return false;
        }
        this.activityState.addOrderId(orderId);
        this.logger.verbose("Added order ID '%s'", orderId);
        return true;
    }

    private boolean checkActivityStateI(ActivityState activityState) {
        if (this.internalState.hasFirstSdkStartNotOcurred()) {
            this.logger.error("Sdk did not yet start", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean pausedI() {
        return this.pausedI(false);
    }

    private boolean pausedI(boolean sdkClickHandlerOnly) {
        if (sdkClickHandlerOnly) {
            return this.internalState.isOffline() || !this.isEnabledI();
        }
        return this.internalState.isOffline() || !this.isEnabledI() || this.internalState.isInDelayedStart();
    }

    private boolean toSendI() {
        return this.toSendI(false);
    }

    private boolean toSendI(boolean sdkClickHandlerOnly) {
        if (this.pausedI(sdkClickHandlerOnly)) {
            return false;
        }
        if (this.adjustConfig.sendInBackground) {
            return true;
        }
        return this.internalState.isInForeground();
    }

    private void checkForInstallReferrerInfo(SdkClickResponseData responseData) {
        if (!responseData.isInstallReferrer) {
            return;
        }
        this.activityState.clickTime = responseData.clickTime;
        this.activityState.installBegin = responseData.installBegin;
        this.activityState.installReferrer = responseData.installReferrer;
        this.writeActivityStateI();
    }

    public class InternalState {
        boolean enabled;
        boolean offline;
        boolean background;
        boolean delayStart;
        boolean updatePackages;
        boolean firstLaunch;
        boolean sessionResponseProcessed;
        boolean firstSdkStart;

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDisabled() {
            return !this.enabled;
        }

        public boolean isOffline() {
            return this.offline;
        }

        public boolean isOnline() {
            return !this.offline;
        }

        public boolean isInBackground() {
            return this.background;
        }

        public boolean isInForeground() {
            return !this.background;
        }

        public boolean isInDelayedStart() {
            return this.delayStart;
        }

        public boolean isNotInDelayedStart() {
            return !this.delayStart;
        }

        public boolean itHasToUpdatePackages() {
            return this.updatePackages;
        }

        public boolean isFirstLaunch() {
            return this.firstLaunch;
        }

        public boolean isNotFirstLaunch() {
            return !this.firstLaunch;
        }

        public boolean hasSessionResponseNotBeenProcessed() {
            return !this.sessionResponseProcessed;
        }

        public boolean hasFirstSdkStartOcurred() {
            return this.firstSdkStart;
        }

        public boolean hasFirstSdkStartNotOcurred() {
            return !this.firstSdkStart;
        }
    }
}

