/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.Util;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

class DeviceInfo {
    String playAdId;
    Boolean isTrackingEnabled;
    private boolean nonGoogleIdsRead = false;
    String macSha1;
    String macShortMd5;
    String androidId;
    String fbAttributionId;
    String clientSdk;
    String packageName;
    String appVersion;
    String deviceType;
    String deviceName;
    String deviceManufacturer;
    String osName;
    String osVersion;
    String apiLevel;
    String language;
    String country;
    String screenSize;
    String screenFormat;
    String screenDensity;
    String displayWidth;
    String displayHeight;
    String hardwareName;
    String abi;
    String buildName;
    String vmInstructionSet;
    String appInstallTime;
    String appUpdateTime;
    Map<String, String> pluginKeys;

    DeviceInfo(Context context, String sdkPrefix) {
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Configuration configuration = resources.getConfiguration();
        Locale locale = Util.getLocale(configuration);
        int screenLayout = configuration.screenLayout;
        ContentResolver contentResolver = context.getContentResolver();
        this.reloadDeviceIds(context);
        this.packageName = this.getPackageName(context);
        this.appVersion = this.getAppVersion(context);
        this.deviceType = this.getDeviceType(screenLayout);
        this.deviceName = this.getDeviceName();
        this.deviceManufacturer = this.getDeviceManufacturer();
        this.osName = this.getOsName();
        this.osVersion = this.getOsVersion();
        this.apiLevel = this.getApiLevel();
        this.language = this.getLanguage(locale);
        this.country = this.getCountry(locale);
        this.screenSize = this.getScreenSize(screenLayout);
        this.screenFormat = this.getScreenFormat(screenLayout);
        this.screenDensity = this.getScreenDensity(displayMetrics);
        this.displayWidth = this.getDisplayWidth(displayMetrics);
        this.displayHeight = this.getDisplayHeight(displayMetrics);
        this.clientSdk = this.getClientSdk(sdkPrefix);
        this.fbAttributionId = this.getFacebookAttributionId(context);
        this.pluginKeys = Util.getPluginKeys(context);
        this.hardwareName = this.getHardwareName();
        this.abi = this.getABI();
        this.buildName = this.getBuildName();
        this.vmInstructionSet = this.getVmInstructionSet();
        this.appInstallTime = this.getAppInstallTime(context);
        this.appUpdateTime = this.getAppUpdateTime(context);
    }

    void reloadDeviceIds(Context context) {
        this.isTrackingEnabled = Util.isPlayTrackingEnabled(context);
        this.playAdId = Util.getPlayAdId(context);
        if (this.playAdId == null && !this.nonGoogleIdsRead) {
            if (!Util.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
                AdjustFactory.getLogger().warn("Missing permission: ACCESS_WIFI_STATE", new Object[0]);
            }
            String macAddress = Util.getMacAddress(context);
            this.macSha1 = this.getMacSha1(macAddress);
            this.macShortMd5 = this.getMacShortMd5(macAddress);
            this.androidId = Util.getAndroidId(context);
            this.nonGoogleIdsRead = true;
        }
    }

    private String getMacAddress(Context context, boolean isGooglePlayServicesAvailable) {
        if (!isGooglePlayServicesAvailable) {
            if (!Util.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
                AdjustFactory.getLogger().warn("Missing permission: ACCESS_WIFI_STATE", new Object[0]);
            }
            return Util.getMacAddress(context);
        }
        return null;
    }

    private String getPackageName(Context context) {
        return context.getPackageName();
    }

    private String getAppVersion(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            String name = context.getPackageName();
            PackageInfo info = packageManager.getPackageInfo(name, 0);
            return info.versionName;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getDeviceType(int screenLayout) {
        int screenSize = screenLayout & 0xF;
        switch (screenSize) {
            case 1: 
            case 2: {
                return "phone";
            }
            case 3: 
            case 4: {
                return "tablet";
            }
        }
        return null;
    }

    private String getDeviceName() {
        return Build.MODEL;
    }

    private String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    private String getOsName() {
        return "android";
    }

    private String getOsVersion() {
        return Build.VERSION.RELEASE;
    }

    private String getApiLevel() {
        return "" + Build.VERSION.SDK_INT;
    }

    private String getLanguage(Locale locale) {
        return locale.getLanguage();
    }

    private String getCountry(Locale locale) {
        return locale.getCountry();
    }

    private String getBuildName() {
        return Build.ID;
    }

    private String getHardwareName() {
        return Build.DISPLAY;
    }

    private String getScreenSize(int screenLayout) {
        int screenSize = screenLayout & 0xF;
        switch (screenSize) {
            case 1: {
                return "small";
            }
            case 2: {
                return "normal";
            }
            case 3: {
                return "large";
            }
            case 4: {
                return "xlarge";
            }
        }
        return null;
    }

    private String getScreenFormat(int screenLayout) {
        int screenFormat = screenLayout & 0x30;
        switch (screenFormat) {
            case 32: {
                return "long";
            }
            case 16: {
                return "normal";
            }
        }
        return null;
    }

    private String getScreenDensity(DisplayMetrics displayMetrics) {
        int density = displayMetrics.densityDpi;
        int low = 140;
        int high = 200;
        if (density == 0) {
            return null;
        }
        if (density < low) {
            return "low";
        }
        if (density > high) {
            return "high";
        }
        return "medium";
    }

    private String getDisplayWidth(DisplayMetrics displayMetrics) {
        return String.valueOf(displayMetrics.widthPixels);
    }

    private String getDisplayHeight(DisplayMetrics displayMetrics) {
        return String.valueOf(displayMetrics.heightPixels);
    }

    private String getClientSdk(String sdkPrefix) {
        if (sdkPrefix == null) {
            return "android4.12.4";
        }
        return Util.formatString("%s@%s", sdkPrefix, "android4.12.4");
    }

    private String getMacSha1(String macAddress) {
        if (macAddress == null) {
            return null;
        }
        String macSha1 = Util.sha1(macAddress);
        return macSha1;
    }

    private String getMacShortMd5(String macAddress) {
        if (macAddress == null) {
            return null;
        }
        String macShort = macAddress.replaceAll(":", "");
        String macShortMd5 = Util.md5(macShort);
        return macShortMd5;
    }

    private String getFacebookAttributionId(Context context) {
        try {
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider");
            String columnName = "aid";
            String[] projection = new String[]{"aid"};
            Cursor cursor = contentResolver.query(uri, projection, null, null, null);
            if (cursor == null) {
                return null;
            }
            if (!cursor.moveToFirst()) {
                cursor.close();
                return null;
            }
            String attributionId = cursor.getString(cursor.getColumnIndex("aid"));
            cursor.close();
            return attributionId;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getABI() {
        String[] SupportedABIS = Util.getSupportedAbis();
        if (SupportedABIS == null || SupportedABIS.length == 0) {
            return Util.getCpuAbi();
        }
        return SupportedABIS[0];
    }

    private String getVmInstructionSet() {
        String instructionSet = Util.getVmInstructionSet();
        return instructionSet;
    }

    private String getAppInstallTime(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 4096);
            String appInstallTime = Util.dateFormatter.format(new Date(packageInfo.firstInstallTime));
            return appInstallTime;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String getAppUpdateTime(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 4096);
            String appInstallTime = Util.dateFormatter.format(new Date(packageInfo.lastUpdateTime));
            return appInstallTime;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

