/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.CustomScheduledExecutor;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.ISdkClickHandler;
import com.adjust.sdk.PackageFactory;
import com.adjust.sdk.SdkClickResponseData;
import com.adjust.sdk.SharedPreferencesManager;
import com.adjust.sdk.Util;
import com.adjust.sdk.UtilNetworking;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;

public class SdkClickHandler
implements ISdkClickHandler {
    private static final double MILLISECONDS_TO_SECONDS_DIVISOR = 1000.0;
    private static final String SCHEDULED_EXECUTOR_SOURCE = "SdkClickHandler";
    private static final String SOURCE_REFTAG = "reftag";
    private static final String SOURCE_INSTALL_REFERRER = "install_referrer";
    private boolean paused;
    private ILogger logger;
    private BackoffStrategy backoffStrategy;
    private String basePath;
    private List<ActivityPackage> packageQueue;
    private CustomScheduledExecutor scheduledExecutor;
    private WeakReference<IActivityHandler> activityHandlerWeakRef;

    public SdkClickHandler(IActivityHandler activityHandler, boolean startsSending) {
        this.init(activityHandler, startsSending);
        this.logger = AdjustFactory.getLogger();
        this.backoffStrategy = AdjustFactory.getSdkClickBackoffStrategy();
        this.scheduledExecutor = new CustomScheduledExecutor(SCHEDULED_EXECUTOR_SOURCE, false);
    }

    @Override
    public void init(IActivityHandler activityHandler, boolean startsSending) {
        this.paused = !startsSending;
        this.packageQueue = new ArrayList<ActivityPackage>();
        this.activityHandlerWeakRef = new WeakReference<IActivityHandler>(activityHandler);
        this.basePath = activityHandler.getBasePath();
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
        this.sendNextSdkClick();
    }

    @Override
    public void sendSdkClick(final ActivityPackage sdkClick) {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                SdkClickHandler.this.packageQueue.add(sdkClick);
                SdkClickHandler.this.logger.debug("Added sdk_click %d", SdkClickHandler.this.packageQueue.size());
                SdkClickHandler.this.logger.verbose("%s", sdkClick.getExtendedString());
                SdkClickHandler.this.sendNextSdkClick();
            }
        });
    }

    @Override
    public void sendReftagReferrers() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                IActivityHandler activityHandler = (IActivityHandler)SdkClickHandler.this.activityHandlerWeakRef.get();
                SharedPreferencesManager sharedPreferencesManager = new SharedPreferencesManager(activityHandler.getContext());
                try {
                    JSONArray rawReferrerArray = sharedPreferencesManager.getRawReferrerArray();
                    boolean hasRawReferrersBeenChanged = false;
                    for (int i = 0; i < rawReferrerArray.length(); ++i) {
                        JSONArray savedRawReferrer = rawReferrerArray.getJSONArray(i);
                        int savedRawReferrerState = savedRawReferrer.optInt(2, -1);
                        if (savedRawReferrerState != 0) continue;
                        String savedRawReferrerString = savedRawReferrer.optString(0, null);
                        long savedClickTime = savedRawReferrer.optLong(1, -1L);
                        savedRawReferrer.put(2, 1);
                        hasRawReferrersBeenChanged = true;
                        ActivityPackage sdkClickPackage = PackageFactory.buildReftagSdkClickPackage(savedRawReferrerString, savedClickTime, activityHandler.getActivityState(), activityHandler.getAdjustConfig(), activityHandler.getDeviceInfo(), activityHandler.getSessionParameters());
                        SdkClickHandler.this.sendSdkClick(sdkClickPackage);
                    }
                    if (hasRawReferrersBeenChanged) {
                        sharedPreferencesManager.saveRawReferrerArray(rawReferrerArray);
                    }
                }
                catch (JSONException e) {
                    SdkClickHandler.this.logger.error("Send saved raw referrers error (%s)", e.getMessage());
                }
            }
        });
    }

    @Override
    public void teardown() {
        this.logger.verbose("SdkClickHandler teardown", new Object[0]);
        if (this.scheduledExecutor != null) {
            try {
                this.scheduledExecutor.shutdownNow();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.packageQueue != null) {
            this.packageQueue.clear();
        }
        if (this.activityHandlerWeakRef != null) {
            this.activityHandlerWeakRef.clear();
        }
        this.logger = null;
        this.packageQueue = null;
        this.backoffStrategy = null;
        this.scheduledExecutor = null;
    }

    private void sendNextSdkClick() {
        this.scheduledExecutor.submit(new Runnable(){

            @Override
            public void run() {
                SdkClickHandler.this.sendNextSdkClickI();
            }
        });
    }

    private void sendNextSdkClickI() {
        if (this.paused) {
            return;
        }
        if (this.packageQueue.isEmpty()) {
            return;
        }
        final ActivityPackage sdkClickPackage = this.packageQueue.remove(0);
        int retries = sdkClickPackage.getRetries();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SdkClickHandler.this.sendSdkClickI(sdkClickPackage);
                SdkClickHandler.this.sendNextSdkClick();
            }
        };
        if (retries <= 0) {
            runnable.run();
            return;
        }
        long waitTimeMilliSeconds = Util.getWaitingTime(retries, this.backoffStrategy);
        double waitTimeSeconds = (double)waitTimeMilliSeconds / 1000.0;
        String secondsString = Util.SecondsDisplayFormat.format(waitTimeSeconds);
        this.logger.verbose("Waiting for %s seconds before retrying sdk_click for the %d time", secondsString, retries);
        this.scheduledExecutor.schedule(runnable, waitTimeMilliSeconds, TimeUnit.MILLISECONDS);
    }

    private void sendSdkClickI(ActivityPackage sdkClickPackage) {
        SharedPreferencesManager sharedPreferencesManager;
        JSONArray rawReferrer;
        IActivityHandler activityHandler = (IActivityHandler)this.activityHandlerWeakRef.get();
        String source = sdkClickPackage.getParameters().get("source");
        boolean isReftag = source != null && source.equals(SOURCE_REFTAG);
        String rawReferrerString = sdkClickPackage.getParameters().get("raw_referrer");
        if (isReftag && (rawReferrer = (sharedPreferencesManager = new SharedPreferencesManager(activityHandler.getContext())).getRawReferrer(rawReferrerString, sdkClickPackage.getClickTimeInMilliseconds())) == null) {
            return;
        }
        boolean isInstallReferrer = source != null && source.equals(SOURCE_INSTALL_REFERRER);
        long clickTime = -1L;
        long installBegin = -1L;
        String installReferrer = null;
        if (isInstallReferrer) {
            clickTime = sdkClickPackage.getClickTimeInSeconds();
            installBegin = sdkClickPackage.getInstallBeginTimeInSeconds();
            installReferrer = sdkClickPackage.getParameters().get("referrer");
        }
        String url = AdjustFactory.getBaseUrl();
        if (this.basePath != null) {
            url = url + this.basePath;
        }
        String targetURL = url + sdkClickPackage.getPath();
        try {
            SdkClickResponseData responseData = (SdkClickResponseData)UtilNetworking.createPOSTHttpsURLConnection(targetURL, sdkClickPackage, this.packageQueue.size() - 1);
            if (responseData.jsonResponse == null) {
                this.retrySendingI(sdkClickPackage);
                return;
            }
            if (activityHandler == null) {
                return;
            }
            if (isReftag) {
                SharedPreferencesManager sharedPreferencesManager2 = new SharedPreferencesManager(activityHandler.getContext());
                sharedPreferencesManager2.removeRawReferrer(rawReferrerString, sdkClickPackage.getClickTimeInMilliseconds());
            }
            if (isInstallReferrer) {
                responseData.clickTime = clickTime;
                responseData.installBegin = installBegin;
                responseData.installReferrer = installReferrer;
                responseData.isInstallReferrer = true;
            }
            activityHandler.finishedTrackingActivity(responseData);
        }
        catch (UnsupportedEncodingException e) {
            this.logErrorMessageI(sdkClickPackage, "Sdk_click failed to encode parameters", e);
        }
        catch (SocketTimeoutException e) {
            this.logErrorMessageI(sdkClickPackage, "Sdk_click request timed out. Will retry later", e);
            this.retrySendingI(sdkClickPackage);
        }
        catch (IOException e) {
            this.logErrorMessageI(sdkClickPackage, "Sdk_click request failed. Will retry later", e);
            this.retrySendingI(sdkClickPackage);
        }
        catch (Throwable e) {
            this.logErrorMessageI(sdkClickPackage, "Sdk_click runtime exception", e);
        }
    }

    private void retrySendingI(ActivityPackage sdkClickPackage) {
        int retries = sdkClickPackage.increaseRetries();
        this.logger.error("Retrying sdk_click package for the %d time", retries);
        this.sendSdkClick(sdkClickPackage);
    }

    private void logErrorMessageI(ActivityPackage sdkClickPackage, String message, Throwable throwable) {
        String packageMessage = sdkClickPackage.getFailureMessage();
        String reasonString = Util.getReasonString(message, throwable);
        String finalMessage = Util.formatString("%s. (%s)", packageMessage, reasonString);
        this.logger.error(finalMessage, new Object[0]);
    }
}

