/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.Reflection;
import com.adjust.sdk.TimerOnce;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class InstallReferrer
implements InvocationHandler {
    public static final String PACKAGE_BASE_NAME = "com.android.installreferrer.";
    private static final int STATUS_SERVICE_DISCONNECTED = -1;
    private static final int STATUS_OK = 0;
    private static final int STATUS_SERVICE_UNAVAILABLE = 1;
    private static final int STATUS_FEATURE_NOT_SUPPORTED = 2;
    private static final int STATUS_DEVELOPER_ERROR = 3;
    private int retryWaitTime = 3000;
    private int retries;
    private boolean hasInstallReferrerBeenRead;
    private ILogger logger = AdjustFactory.getLogger();
    private Object referrerClient;
    private Context context;
    private Object flagLock;
    private TimerOnce retryTimer;
    private WeakReference<IActivityHandler> activityHandlerWeakRef;

    public InstallReferrer(Context context, IActivityHandler activityHandler) {
        this.context = context;
        this.flagLock = new Object();
        this.hasInstallReferrerBeenRead = false;
        this.retries = 0;
        this.retryTimer = new TimerOnce(new Runnable(){

            @Override
            public void run() {
                InstallReferrer.this.startConnection();
            }
        }, "InstallReferrer");
        this.activityHandlerWeakRef = new WeakReference<IActivityHandler>(activityHandler);
        this.startConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startConnection() {
        this.closeReferrerClient();
        Object object = this.flagLock;
        synchronized (object) {
            if (this.hasInstallReferrerBeenRead) {
                this.logger.debug("Install referrer has already been read", new Object[0]);
                return;
            }
        }
        this.referrerClient = this.createInstallReferrerClient(this.context);
        Class listenerClass = this.getInstallReferrerStateListenerClass();
        Object listenerProxy = this.createProxyInstallReferrerStateListener(listenerClass);
        this.startConnection(listenerClass, listenerProxy);
    }

    public Object createInstallReferrerClient(Context context) {
        if (context == null) {
            return null;
        }
        try {
            Object builder = Reflection.invokeStaticMethod("com.android.installreferrer.api.InstallReferrerClient", "newBuilder", new Class[]{Context.class}, context);
            return Reflection.invokeInstanceMethod(builder, "build", null, new Object[0]);
        }
        catch (Exception e) {
            this.logger.warn("Couldn't create instance of referrer client (%s)", e.getMessage());
            return null;
        }
    }

    public Class getInstallReferrerStateListenerClass() {
        try {
            return Class.forName("com.android.installreferrer.api.InstallReferrerStateListener");
        }
        catch (Exception e) {
            this.logger.error("getInstallReferrerStateListenerClass error (%s)", e.getMessage());
            return null;
        }
    }

    public Object createProxyInstallReferrerStateListener(Class installReferrerStateListenerClass) {
        if (installReferrerStateListenerClass == null) {
            return null;
        }
        return Proxy.newProxyInstance(installReferrerStateListenerClass.getClassLoader(), new Class[]{installReferrerStateListenerClass}, (InvocationHandler)this);
    }

    public void startConnection(Class listenerClass, Object listenerProxy) {
        if (this.referrerClient == null) {
            return;
        }
        if (listenerClass == null || listenerProxy == null) {
            return;
        }
        try {
            Reflection.invokeInstanceMethod(this.referrerClient, "startConnection", new Class[]{listenerClass}, listenerProxy);
        }
        catch (Exception e) {
            this.logger.error("startConnection error (%s)", e.getMessage());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            String methodName = method.getName();
            this.logger.debug("InstallReferrer invoke method name: %s", methodName);
            for (Object arg : args) {
                this.logger.debug("InstallReferrer invoke arg: %s", arg);
            }
            if (methodName.equals("onInstallReferrerSetupFinished")) {
                this.onInstallReferrerSetupFinishedInt((Integer)args[0]);
            } else if (methodName.equals("onInstallReferrerServiceDisconnected")) {
                this.logger.debug("InstallReferrer onInstallReferrerServiceDisconnected", new Object[0]);
            }
        }
        catch (Exception e) {
            this.logger.error("InstallReferrer invoke error (%s)", e.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onInstallReferrerSetupFinishedInt(int responseCode) {
        switch (responseCode) {
            case 0: {
                try {
                    Object referrerDetails = this.getInstallReferrer();
                    String installReferrer = this.getStringInstallReferrer(referrerDetails);
                    long clickTime = this.getReferrerClickTimestampSeconds(referrerDetails);
                    long installBegin = this.getInstallBeginTimestampSeconds(referrerDetails);
                    this.logger.debug("installReferrer: %s, clickTime: %d, installBeginTime: %d", installReferrer, clickTime, installBegin);
                    IActivityHandler activityHandler = (IActivityHandler)this.activityHandlerWeakRef.get();
                    if (activityHandler != null) {
                        activityHandler.sendInstallReferrer(clickTime, installBegin, installReferrer);
                    }
                    Object object = this.flagLock;
                    synchronized (object) {
                        this.hasInstallReferrerBeenRead = true;
                    }
                }
                catch (Exception e) {
                    this.logger.debug("Couldn't get install referrer from client (%s). Retrying ...", e.getMessage());
                    this.retry();
                }
                break;
            }
            case 2: {
                this.logger.debug("Install referrer not available on the current Play Store app.", new Object[0]);
                break;
            }
            case 1: {
                this.logger.debug("Could not initiate connection to the Install Referrer service. Retrying ...", new Object[0]);
                this.retry();
                break;
            }
            case 3: {
                this.logger.debug("Install referrer general errors caused by incorrect usage. Retrying ...", new Object[0]);
                this.retry();
                break;
            }
            case -1: {
                this.logger.debug("Play Store service is not connected now. Retrying ...", new Object[0]);
                this.retry();
                break;
            }
            default: {
                this.logger.debug("Unexpected response code of install referrer response: %d", responseCode);
            }
        }
        this.closeReferrerClient();
    }

    private Object getInstallReferrer() {
        if (this.referrerClient == null) {
            return null;
        }
        try {
            return Reflection.invokeInstanceMethod(this.referrerClient, "getInstallReferrer", null, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("getInstallReferrer error (%s)", e.getMessage());
            return null;
        }
    }

    private String getStringInstallReferrer(Object referrerDetails) {
        if (referrerDetails == null) {
            return null;
        }
        try {
            String stringInstallReferrer = (String)Reflection.invokeInstanceMethod(referrerDetails, "getInstallReferrer", null, new Object[0]);
            return stringInstallReferrer;
        }
        catch (Exception e) {
            this.logger.error("getStringInstallReferrer error (%s)", e.getMessage());
            return null;
        }
    }

    private long getReferrerClickTimestampSeconds(Object referrerDetails) {
        if (referrerDetails == null) {
            return -1L;
        }
        try {
            Long clickTime = (Long)Reflection.invokeInstanceMethod(referrerDetails, "getReferrerClickTimestampSeconds", null, new Object[0]);
            return clickTime;
        }
        catch (Exception e) {
            this.logger.error("getReferrerClickTimestampSeconds error (%s)", e.getMessage());
            return -1L;
        }
    }

    private long getInstallBeginTimestampSeconds(Object referrerDetails) {
        if (referrerDetails == null) {
            return -1L;
        }
        try {
            Long installBeginTime = (Long)Reflection.invokeInstanceMethod(referrerDetails, "getInstallBeginTimestampSeconds", null, new Object[0]);
            return installBeginTime;
        }
        catch (Exception e) {
            this.logger.error("getInstallBeginTimestampSeconds error (%s)", e.getMessage());
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retry() {
        Object object = this.flagLock;
        synchronized (object) {
            if (this.hasInstallReferrerBeenRead) {
                this.logger.debug("Install referrer has already been read", new Object[0]);
                return;
            }
        }
        ++this.retries;
        if (this.retries > 2) {
            this.logger.debug("Limit number of retry for install referrer surpassed", new Object[0]);
            return;
        }
        long firingIn = this.retryTimer.getFireIn();
        if (firingIn > 0L) {
            this.logger.debug("Already waiting to retry to read install referrer in %d milliseconds", firingIn);
            return;
        }
        this.retryTimer.startIn(this.retryWaitTime);
    }

    private void closeReferrerClient() {
        if (this.referrerClient == null) {
            return;
        }
        try {
            Reflection.invokeInstanceMethod(this.referrerClient, "endConnection", null, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("closeReferrerClient error (%s)", e.getMessage());
        }
        this.referrerClient = null;
    }
}

