/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.net.Uri;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.Util;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class UtilNetworking {
    private static String userAgent;

    private static ILogger getLogger() {
        return AdjustFactory.getLogger();
    }

    public static void setUserAgent(String userAgent) {
        UtilNetworking.userAgent = userAgent;
    }

    public static ResponseData createPOSTHttpsURLConnection(String urlString, ActivityPackage activityPackage, int queueSize) throws Exception {
        DataOutputStream wr = null;
        try {
            ResponseData responseData;
            URL url = new URL(urlString);
            HttpsURLConnection connection = AdjustFactory.getHttpsURLConnection(url);
            HashMap<String, String> parameters = new HashMap<String, String>(activityPackage.getParameters());
            UtilNetworking.setDefaultHttpsUrlConnectionProperties(connection, activityPackage.getClientSdk());
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(UtilNetworking.getPostDataString(parameters, queueSize));
            ResponseData responseData2 = responseData = UtilNetworking.readHttpResponse(connection, activityPackage);
            return responseData2;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (wr != null) {
                    wr.flush();
                    wr.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static ResponseData createGETHttpsURLConnection(ActivityPackage activityPackage) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>(activityPackage.getParameters());
        Uri uri = UtilNetworking.buildUri(activityPackage.getPath(), parameters);
        URL url = new URL(uri.toString());
        HttpsURLConnection connection = AdjustFactory.getHttpsURLConnection(url);
        UtilNetworking.setDefaultHttpsUrlConnectionProperties(connection, activityPackage.getClientSdk());
        connection.setRequestMethod("GET");
        ResponseData responseData = UtilNetworking.readHttpResponse(connection, activityPackage);
        return responseData;
    }

    private static ResponseData readHttpResponse(HttpsURLConnection connection, ActivityPackage activityPackage) throws Exception {
        String message;
        StringBuffer sb = new StringBuffer();
        ILogger logger = UtilNetworking.getLogger();
        Integer responseCode = null;
        ResponseData responseData = ResponseData.buildResponseData(activityPackage);
        try {
            String line;
            connection.connect();
            responseCode = connection.getResponseCode();
            InputStream inputStream = responseCode >= 400 ? connection.getErrorStream() : connection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            logger.error("Failed to read response. (%s)", e.getMessage());
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        String stringResponse = sb.toString();
        logger.verbose("Response: %s", stringResponse);
        if (stringResponse == null || stringResponse.length() == 0) {
            return responseData;
        }
        JSONObject jsonResponse = null;
        try {
            jsonResponse = new JSONObject(stringResponse);
        }
        catch (JSONException e) {
            String message2 = String.format("Failed to parse json response. (%s)", e.getMessage());
            logger.error(message2, new Object[0]);
            responseData.message = message2;
        }
        if (jsonResponse == null) {
            return responseData;
        }
        responseData.jsonResponse = jsonResponse;
        responseData.message = message = jsonResponse.optString("message", null);
        responseData.timestamp = jsonResponse.optString("timestamp", null);
        responseData.adid = jsonResponse.optString("adid", null);
        if (message == null) {
            message = "No message found";
        }
        if (responseCode != null && responseCode == 200) {
            logger.info("%s", message);
            responseData.success = true;
        } else {
            logger.error("%s", message);
        }
        return responseData;
    }

    private static String getPostDataString(Map<String, String> body, int queueSize) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : body.entrySet()) {
            String encodedValue;
            String encodedName = URLEncoder.encode(entry.getKey(), "UTF-8");
            String value = entry.getValue();
            String string = encodedValue = value != null ? URLEncoder.encode(value, "UTF-8") : "";
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName);
            result.append("=");
            result.append(encodedValue);
        }
        long now = System.currentTimeMillis();
        String dateString = Util.dateFormatter.format(now);
        result.append("&");
        result.append(URLEncoder.encode("sent_at", "UTF-8"));
        result.append("=");
        result.append(URLEncoder.encode(dateString, "UTF-8"));
        if (queueSize > 0) {
            result.append("&");
            result.append(URLEncoder.encode("queue_size", "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode("" + queueSize, "UTF-8"));
        }
        return result.toString();
    }

    private static void setDefaultHttpsUrlConnectionProperties(HttpsURLConnection connection, String clientSdk) {
        connection.setRequestProperty("Client-SDK", clientSdk);
        connection.setConnectTimeout(60000);
        connection.setReadTimeout(60000);
        if (userAgent != null) {
            connection.setRequestProperty("User-Agent", userAgent);
        }
    }

    private static Uri buildUri(String path, Map<String, String> parameters) {
        Uri.Builder uriBuilder = new Uri.Builder();
        uriBuilder.scheme("https");
        uriBuilder.authority("app.adjust.com");
        uriBuilder.appendPath(path);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        long now = System.currentTimeMillis();
        String dateString = Util.dateFormatter.format(now);
        uriBuilder.appendQueryParameter("sent_at", dateString);
        return uriBuilder.build();
    }
}

